/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.commands.general;

import java.util.Optional;
import java.util.function.Supplier;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.client.commands.VetoExecutionCommand;
import org.kie.workbench.common.dmn.client.commands.VetoUndoCommand;
import org.kie.workbench.common.dmn.client.commands.general.SetCellValueCommand;
import org.kie.workbench.common.dmn.client.widgets.grid.model.BaseUIModelMapper;
import org.kie.workbench.common.dmn.client.widgets.grid.model.GridCellValueTuple;
import org.kie.workbench.common.dmn.client.widgets.layer.DMNGridLayer;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.command.CanvasCommandResultBuilder;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommandExecutionContext;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommandResultBuilder;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.ext.wires.core.grids.client.model.GridCell;
import org.uberfire.ext.wires.core.grids.client.model.GridCellValue;
import org.uberfire.ext.wires.core.grids.client.model.GridData;

@RunWith(value=MockitoJUnitRunner.class)
public class SetCellValueCommandTest {
    private static final int ROW_INDEX = 0;
    private static final int COLUMN_INDEX = 1;
    private static final String OLD_CELL_VALUE = "old-value";
    private static final String NEW_CELL_VALUE = "new-value";
    @Mock
    private DMNGridLayer gridLayer;
    @Mock
    private GridData gridModel;
    @Mock
    private GridCell oldGridCell;
    @Mock
    private GridCellValue oldGridCellValue;
    @Mock
    private GridCell newGridCell;
    @Mock
    private GridCellValue newGridCellValue;
    @Mock
    private AbstractCanvasHandler canvasHandler;
    @Mock
    private GraphCommandExecutionContext graphCommandExecutionContext;
    @Mock
    private BaseUIModelMapper<?> uiModelMapper;
    @Captor
    private ArgumentCaptor<Supplier<Optional<GridCellValue<?>>>> gridCellValueSupplierCaptor;
    @Captor
    private ArgumentCaptor<GridCellValue<?>> gridCellValueCaptor;
    private SetCellValueCommand command;

    public void setup(GridCell oldGridCell, GridCellValue oldGridCellValue, String oldCellValue) {
        Mockito.when((Object)this.gridModel.getCell(0, 1)).thenReturn((Object)oldGridCell);
        if (oldGridCell != null) {
            Mockito.when((Object)oldGridCell.getValue()).thenReturn((Object)oldGridCellValue);
            if (oldGridCellValue != null) {
                Mockito.when((Object)oldGridCellValue.getValue()).thenReturn((Object)oldCellValue);
            }
        }
        Mockito.when((Object)this.newGridCell.getValue()).thenReturn((Object)this.newGridCellValue);
        Mockito.when((Object)this.newGridCellValue.getValue()).thenReturn((Object)NEW_CELL_VALUE);
        this.command = new SetCellValueCommand(new GridCellValueTuple(0, 1, this.gridModel, this.newGridCellValue), () -> this.uiModelMapper, () -> ((DMNGridLayer)this.gridLayer).batch());
    }

    @Test
    public void checkGraphCommand() {
        this.setup(this.oldGridCell, this.oldGridCellValue, OLD_CELL_VALUE);
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)this.command.getGraphCommand(this.canvasHandler).allow((Object)this.graphCommandExecutionContext));
        ((BaseUIModelMapper)Mockito.verify(this.uiModelMapper, (VerificationMode)Mockito.never())).toDMNModel(Mockito.anyInt(), Mockito.anyInt(), (Supplier)Mockito.any(Supplier.class));
    }

    @Test
    public void executeGraphCommand() {
        this.setup(this.oldGridCell, this.oldGridCellValue, OLD_CELL_VALUE);
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)this.command.getGraphCommand(this.canvasHandler).execute((Object)this.graphCommandExecutionContext));
        this.assertGraphMutation(this.newGridCellValue, NEW_CELL_VALUE);
    }

    @Test
    public void undoGraphCommand() {
        this.setup(this.oldGridCell, this.oldGridCellValue, OLD_CELL_VALUE);
        Assert.assertEquals((Object)GraphCommandResultBuilder.SUCCESS, (Object)this.command.getGraphCommand(this.canvasHandler).undo((Object)this.graphCommandExecutionContext));
        this.assertGraphMutation(this.oldGridCellValue, OLD_CELL_VALUE);
    }

    private void assertGraphMutation(GridCellValue gridCellValue, String value) {
        ((BaseUIModelMapper)Mockito.verify(this.uiModelMapper)).toDMNModel(Mockito.eq((int)0), Mockito.eq((int)1), (Supplier)this.gridCellValueSupplierCaptor.capture());
        Supplier gridCellValueSupplier = (Supplier)this.gridCellValueSupplierCaptor.getValue();
        Assert.assertNotNull((Object)gridCellValueSupplier);
        Optional oGridCellValue = (Optional)gridCellValueSupplier.get();
        Assert.assertTrue((boolean)oGridCellValue.isPresent());
        Assert.assertEquals((Object)gridCellValue, oGridCellValue.get());
        Assert.assertEquals((Object)value, (Object)((GridCellValue)oGridCellValue.get()).getValue());
    }

    @Test
    public void allowCanvasCommand() {
        this.setup(this.oldGridCell, this.oldGridCellValue, OLD_CELL_VALUE);
        Assert.assertEquals((Object)CanvasCommandResultBuilder.SUCCESS, (Object)this.command.getCanvasCommand(this.canvasHandler).allow((Object)this.canvasHandler));
        ((GridData)Mockito.verify((Object)this.gridModel, (VerificationMode)Mockito.never())).setCell(Mockito.anyInt(), Mockito.anyInt(), (GridCellValue)Mockito.any(GridCellValue.class));
    }

    @Test
    public void executeCanvasCommand() {
        this.setup(this.oldGridCell, this.oldGridCellValue, OLD_CELL_VALUE);
        Assert.assertEquals((Object)CanvasCommandResultBuilder.SUCCESS, (Object)this.command.getCanvasCommand(this.canvasHandler).execute((Object)this.canvasHandler));
        this.assertCanvasMutation(this.newGridCellValue);
    }

    @Test
    public void undoCanvasCommand() {
        this.setup(this.oldGridCell, this.oldGridCellValue, OLD_CELL_VALUE);
        Assert.assertEquals((Object)CanvasCommandResultBuilder.SUCCESS, (Object)this.command.getCanvasCommand(this.canvasHandler).undo((Object)this.canvasHandler));
        this.assertCanvasMutation(this.oldGridCellValue);
    }

    @Test
    public void executeCanvasCommandThenUndoWithNullOriginalCell() {
        this.setup(null, null, null);
        Assert.assertEquals((Object)CanvasCommandResultBuilder.SUCCESS, (Object)this.command.getCanvasCommand(this.canvasHandler).execute((Object)this.canvasHandler));
        this.assertCanvasMutation(this.newGridCellValue);
        Mockito.reset((Object[])new Object[]{this.gridModel, this.gridLayer});
        Assert.assertEquals((Object)CanvasCommandResultBuilder.SUCCESS, (Object)this.command.getCanvasCommand(this.canvasHandler).undo((Object)this.canvasHandler));
        ((GridData)Mockito.verify((Object)this.gridModel)).deleteCell(Mockito.eq((int)0), Mockito.eq((int)1));
        ((DMNGridLayer)Mockito.verify((Object)this.gridLayer)).batch();
    }

    @Test
    public void executeCanvasCommandThenUndoWithNullOriginalValue() {
        this.setup(this.oldGridCell, null, null);
        Assert.assertEquals((Object)CanvasCommandResultBuilder.SUCCESS, (Object)this.command.getCanvasCommand(this.canvasHandler).execute((Object)this.canvasHandler));
        this.assertCanvasMutation(this.newGridCellValue);
        Mockito.reset((Object[])new Object[]{this.gridModel, this.gridLayer});
        Assert.assertEquals((Object)CanvasCommandResultBuilder.SUCCESS, (Object)this.command.getCanvasCommand(this.canvasHandler).undo((Object)this.canvasHandler));
        ((GridData)Mockito.verify((Object)this.gridModel)).deleteCell(Mockito.eq((int)0), Mockito.eq((int)1));
        ((DMNGridLayer)Mockito.verify((Object)this.gridLayer)).batch();
    }

    private void assertCanvasMutation(GridCellValue gridCellValue) {
        ((GridData)Mockito.verify((Object)this.gridModel)).setCell(Mockito.eq((int)0), Mockito.eq((int)1), (GridCellValue)this.gridCellValueCaptor.capture());
        Assert.assertEquals((Object)gridCellValue, (Object)this.gridCellValueCaptor.getValue());
        ((DMNGridLayer)Mockito.verify((Object)this.gridLayer)).batch();
    }

    @Test
    public void checkCommandDefinition() {
        this.setup(this.oldGridCell, this.oldGridCellValue, OLD_CELL_VALUE);
        Assert.assertTrue((boolean)(this.command instanceof VetoExecutionCommand));
        Assert.assertTrue((boolean)(this.command instanceof VetoUndoCommand));
    }
}

