/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.commands.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;
import org.kie.workbench.common.dmn.api.definition.v1_1.DecisionRule;
import org.kie.workbench.common.dmn.api.property.dmn.Id;
import org.kie.workbench.common.dmn.client.commands.util.CommandUtils;

public class CommandUtilsTest {
    private DecisionRule decisionRuleOne;
    private DecisionRule decisionRuleTwo;
    private DecisionRule decisionRuleThree;
    private List<Object> allRows = new ArrayList<Object>();
    private List<Object> rowsToMove = new ArrayList<Object>();

    @Before
    public void setUp() throws Exception {
        this.decisionRuleOne = new DecisionRule();
        this.decisionRuleTwo = new DecisionRule();
        this.decisionRuleThree = new DecisionRule();
        this.decisionRuleOne.setId(new Id("1"));
        this.decisionRuleTwo.setId(new Id("2"));
        this.decisionRuleThree.setId(new Id("3"));
        this.allRows.clear();
        this.allRows.add(this.decisionRuleOne);
        this.allRows.add(this.decisionRuleTwo);
        this.allRows.add(this.decisionRuleThree);
        this.rowsToMove.clear();
    }

    @Test
    public void testMoveOneRowUp() throws Exception {
        CommandUtils.moveRows(this.allRows, Collections.singletonList(this.decisionRuleThree), (int)0);
        Assertions.assertThat(this.allRows).containsSequence(new Object[]{this.decisionRuleThree, this.decisionRuleOne, this.decisionRuleTwo});
    }

    @Test
    public void testMoveOneRowUpMiddle() throws Exception {
        CommandUtils.moveRows(this.allRows, Collections.singletonList(this.decisionRuleThree), (int)1);
        Assertions.assertThat(this.allRows).containsSequence(new Object[]{this.decisionRuleOne, this.decisionRuleThree, this.decisionRuleTwo});
    }

    @Test
    public void testMoveOneRowDown() throws Exception {
        CommandUtils.moveRows(this.allRows, Collections.singletonList(this.decisionRuleOne), (int)2);
        Assertions.assertThat(this.allRows).containsSequence(new Object[]{this.decisionRuleTwo, this.decisionRuleThree, this.decisionRuleOne});
    }

    @Test
    public void testMoveOneRowDownMiddle() throws Exception {
        CommandUtils.moveRows(this.allRows, Collections.singletonList(this.decisionRuleOne), (int)1);
        Assertions.assertThat(this.allRows).containsSequence(new Object[]{this.decisionRuleTwo, this.decisionRuleOne, this.decisionRuleThree});
    }

    @Test
    public void testMoveTwoRowsUp() throws Exception {
        CommandUtils.moveRows(this.allRows, Arrays.asList(this.decisionRuleTwo, this.decisionRuleThree), (int)0);
        Assertions.assertThat(this.allRows).containsSequence(new Object[]{this.decisionRuleTwo, this.decisionRuleThree, this.decisionRuleOne});
    }

    @Test
    public void testMoveTwoRowsDown() throws Exception {
        CommandUtils.moveRows(this.allRows, Arrays.asList(this.decisionRuleOne, this.decisionRuleTwo), (int)2);
        Assertions.assertThat(this.allRows).containsSequence(new Object[]{this.decisionRuleThree, this.decisionRuleOne, this.decisionRuleTwo});
    }
}

