/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.components.palette.factory;

import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.DMNDefinitionSet;
import org.kie.workbench.common.dmn.client.components.palette.factory.DMNPaletteDefinitionFactory;
import org.kie.workbench.common.dmn.client.components.palette.widget.DMNPaletteWidget;
import org.kie.workbench.common.stunner.core.client.api.ShapeManager;
import org.kie.workbench.common.stunner.core.client.components.palette.model.definition.DefinitionsPaletteBuilder;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class DMNPaletteDefinitionFactoryTest {
    @Mock
    private ShapeManager shapeManager;
    @Mock
    private DefinitionsPaletteBuilder paletteBuilder;
    @Mock
    private ManagedInstance<DMNPaletteWidget> palette;
    private DMNPaletteDefinitionFactory factory;

    @Before
    public void setup() {
        this.factory = new DMNPaletteDefinitionFactory(this.shapeManager, this.paletteBuilder, this.palette);
    }

    @Test
    public void checkCategoryExclusions() {
        ((DefinitionsPaletteBuilder)Mockito.verify((Object)this.paletteBuilder)).excludeCategory("DMN Diagram");
        ((DefinitionsPaletteBuilder)Mockito.verify((Object)this.paletteBuilder)).excludeCategory("DMN Connectors");
        ((DefinitionsPaletteBuilder)Mockito.verify((Object)this.paletteBuilder)).excludeCategory("DMN Miscellaneous objects - should not be in Palette");
    }

    @Test
    public void checkPaletteBuilderReuse() {
        Assert.assertEquals((Object)this.paletteBuilder, (Object)this.factory.newBuilder());
    }

    @Test
    public void assertDefinitionSetType() {
        Assert.assertEquals(DMNDefinitionSet.class, (Object)this.factory.getDefinitionSetType());
    }
}

