/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.components.palette.widget;

import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.client.components.palette.widget.DMNPaletteItemWidget;
import org.kie.workbench.common.dmn.client.components.palette.widget.DMNPaletteItemWidgetView;
import org.kie.workbench.common.stunner.core.client.components.palette.Palette;
import org.kie.workbench.common.stunner.core.client.components.palette.model.definition.DefinitionPaletteItem;
import org.kie.workbench.common.stunner.core.client.shape.factory.ShapeFactory;
import org.kie.workbench.common.stunner.core.definition.shape.Glyph;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class DMNPaletteItemWidgetTest {
    private static final String ITEM_ID = "itemId";
    private static final String DEFINITION_ID = "definitionId";
    @Mock
    private DMNPaletteItemWidgetView view;
    @Mock
    private DefinitionPaletteItem item;
    @Mock
    private ShapeFactory shapeFactory;
    @Mock
    private Palette.ItemMouseDownCallback itemMouseDownCallback;
    @Mock
    private Glyph glyph;
    private DMNPaletteItemWidget widget;

    @Before
    public void setup() {
        this.widget = new DMNPaletteItemWidget(this.view);
        Mockito.when((Object)this.item.getId()).thenReturn((Object)ITEM_ID);
        Mockito.when((Object)this.item.getDefinitionId()).thenReturn((Object)DEFINITION_ID);
        Mockito.when((Object)this.shapeFactory.getGlyph((String)Matchers.eq((Object)DEFINITION_ID))).thenReturn((Object)this.glyph);
    }

    @Test
    public void checkViewHasPresenterInjected() {
        this.widget.init();
        ((DMNPaletteItemWidgetView)Mockito.verify((Object)this.view)).init(Matchers.eq((Object)this.widget));
    }

    @Test
    public void checkInitialiseRendersGlyph() {
        this.widget.initialize(this.item, this.shapeFactory, this.itemMouseDownCallback);
        ((DMNPaletteItemWidgetView)Mockito.verify((Object)this.view)).render((Glyph)Matchers.eq((Object)this.glyph), Matchers.eq((double)32.0), Matchers.eq((double)32.0));
    }

    @Test
    public void checkOnMouseDownNotInvokedIfCallbackIsSet() {
        this.widget.initialize(this.item, this.shapeFactory, this.itemMouseDownCallback);
        this.widget.onMouseDown(5, 10, 15, 20);
        ((Palette.ItemMouseDownCallback)Mockito.verify((Object)this.itemMouseDownCallback)).onItemMouseDown((String)Matchers.eq((Object)ITEM_ID), Matchers.eq((double)5.0), Matchers.eq((double)10.0), Matchers.eq((double)15.0), Matchers.eq((double)20.0));
    }

    @Test
    public void checkOnMouseDownNotInvokedIfCallbackIsNotSet() {
        this.widget.onMouseDown(5, 10, 15, 20);
        ((Palette.ItemMouseDownCallback)Mockito.verify((Object)this.itemMouseDownCallback, (VerificationMode)Mockito.never())).onItemMouseDown(Mockito.anyString(), (double)Mockito.anyInt(), (double)Mockito.anyInt(), (double)Mockito.anyInt(), (double)Mockito.anyInt());
    }
}

