/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.components.palette.widget;

import java.util.ArrayList;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.client.commands.general.BaseNavigateCommand;
import org.kie.workbench.common.dmn.client.components.palette.widget.DMNPaletteItemWidget;
import org.kie.workbench.common.dmn.client.components.palette.widget.DMNPaletteWidget;
import org.kie.workbench.common.dmn.client.components.palette.widget.DMNPaletteWidgetView;
import org.kie.workbench.common.stunner.client.widgets.palette.PaletteWidget;
import org.kie.workbench.common.stunner.client.widgets.palette.factory.BS3PaletteViewFactory;
import org.kie.workbench.common.stunner.core.client.ShapeSet;
import org.kie.workbench.common.stunner.core.client.api.ClientFactoryManager;
import org.kie.workbench.common.stunner.core.client.api.ShapeManager;
import org.kie.workbench.common.stunner.core.client.components.palette.Palette;
import org.kie.workbench.common.stunner.core.client.components.palette.model.HasPaletteItems;
import org.kie.workbench.common.stunner.core.client.components.palette.model.definition.DefinitionPaletteItem;
import org.kie.workbench.common.stunner.core.client.components.palette.model.definition.DefinitionsPalette;
import org.kie.workbench.common.stunner.core.client.event.screen.ScreenMaximizedEvent;
import org.kie.workbench.common.stunner.core.client.event.screen.ScreenMinimizedEvent;
import org.kie.workbench.common.stunner.core.client.service.ClientFactoryService;
import org.kie.workbench.common.stunner.core.client.shape.factory.ShapeFactory;
import org.kie.workbench.common.stunner.core.definition.shape.Glyph;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class DMNPaletteWidgetTest {
    private static final String DEFINITION_SET_ID = "definitionSetId";
    private static final String DEFINITION_ID = "definitionId";
    @Mock
    private ShapeManager shapeManager;
    @Mock
    private ClientFactoryService clientFactoryServices;
    @Mock
    private DMNPaletteWidgetView view;
    @Mock
    private ManagedInstance<DMNPaletteItemWidget> paletteItemWidgets;
    @Mock
    private ClientFactoryManager clientFactoryManager;
    @Mock
    private DefinitionsPalette palette;
    @Mock
    private ShapeSet shapeSet;
    @Mock
    private ShapeFactory shapeFactory;
    @Mock
    private Glyph glyph;
    @Mock
    private PaletteWidget.ItemDragStartCallback itemDragStartCallback;
    @Mock
    private PaletteWidget.ItemDragUpdateCallback itemDragUpdateCallback;
    @Mock
    private PaletteWidget.ItemDropCallback itemDropCallback;
    private Object definition = new Object();
    private DMNPaletteWidget widget;

    @Before
    public void setup() {
        this.widget = new DMNPaletteWidget(this.shapeManager, this.clientFactoryServices, this.view, this.paletteItemWidgets);
        Mockito.when((Object)this.clientFactoryServices.getClientFactoryManager()).thenReturn((Object)this.clientFactoryManager);
        Mockito.when((Object)this.clientFactoryManager.newDefinition((String)Matchers.eq((Object)DEFINITION_ID))).thenReturn(this.definition);
        Mockito.when((Object)this.palette.getDefinitionSetId()).thenReturn((Object)DEFINITION_SET_ID);
        Mockito.when((Object)this.shapeManager.getDefaultShapeSet((String)Matchers.eq((Object)DEFINITION_SET_ID))).thenReturn((Object)this.shapeSet);
        Mockito.when((Object)this.shapeSet.getShapeFactory()).thenReturn((Object)this.shapeFactory);
        Mockito.when((Object)this.shapeFactory.getGlyph((String)Matchers.eq((Object)DEFINITION_ID))).thenReturn((Object)this.glyph);
    }

    @Test
    public void checkViewHasPresenterInjected() {
        this.widget.init();
        ((DMNPaletteWidgetView)Mockito.verify((Object)this.view)).init(Matchers.eq((Object)this.widget));
        ((DMNPaletteWidgetView)Mockito.verify((Object)this.view)).setBackgroundColor((String)Matchers.eq((Object)"#D3D3D3"));
        ((DMNPaletteWidgetView)Mockito.verify((Object)this.view)).showEmptyView(Matchers.eq((boolean)true));
    }

    @Test
    public void checkOnDragStartWhenCallbackIsSet() {
        this.widget.onItemDragStart(this.itemDragStartCallback);
        this.widget.bind((HasPaletteItems)this.palette);
        this.widget.onDragStart(DEFINITION_ID, 10.0, 20.0);
        ((ClientFactoryService)Mockito.verify((Object)this.clientFactoryServices)).getClientFactoryManager();
        ((ClientFactoryManager)Mockito.verify((Object)this.clientFactoryManager)).newDefinition((String)Matchers.eq((Object)DEFINITION_ID));
        ((PaletteWidget.ItemDragStartCallback)Mockito.verify((Object)this.itemDragStartCallback)).onDragStartItem(Matchers.eq((Object)this.definition), (ShapeFactory)Matchers.eq((Object)this.shapeFactory), Matchers.eq((double)10.0), Matchers.eq((double)20.0));
    }

    @Test
    public void checkOnDragStartWhenCallbackIsNotSet() {
        this.widget.onDragStart(DEFINITION_ID, 10.0, 20.0);
        ((ClientFactoryService)Mockito.verify((Object)this.clientFactoryServices, (VerificationMode)Mockito.never())).getClientFactoryManager();
    }

    @Test
    public void checkOnDragProxyMoveWhenCallbackIsSet() {
        this.widget.onItemDragUpdate(this.itemDragUpdateCallback);
        this.widget.bind((HasPaletteItems)this.palette);
        this.widget.onDragProxyMove(DEFINITION_ID, 10.0, 20.0);
        ((ClientFactoryService)Mockito.verify((Object)this.clientFactoryServices)).getClientFactoryManager();
        ((ClientFactoryManager)Mockito.verify((Object)this.clientFactoryManager)).newDefinition((String)Matchers.eq((Object)DEFINITION_ID));
        ((PaletteWidget.ItemDragUpdateCallback)Mockito.verify((Object)this.itemDragUpdateCallback)).onDragUpdateItem(Matchers.eq((Object)this.definition), (ShapeFactory)Matchers.eq((Object)this.shapeFactory), Matchers.eq((double)10.0), Matchers.eq((double)20.0));
    }

    @Test
    public void checkOnDragProxyMoveWhenCallbackIsNotSet() {
        this.widget.onDragProxyMove(DEFINITION_ID, 10.0, 20.0);
        ((ClientFactoryService)Mockito.verify((Object)this.clientFactoryServices, (VerificationMode)Mockito.never())).getClientFactoryManager();
    }

    @Test
    public void checkOnDragProxyCompleteWhenCallbackIsSet() {
        this.widget.onItemDrop(this.itemDropCallback);
        this.widget.bind((HasPaletteItems)this.palette);
        this.widget.onDragProxyComplete(DEFINITION_ID, 10.0, 20.0);
        ((ClientFactoryService)Mockito.verify((Object)this.clientFactoryServices)).getClientFactoryManager();
        ((ClientFactoryManager)Mockito.verify((Object)this.clientFactoryManager)).newDefinition((String)Matchers.eq((Object)DEFINITION_ID));
        ((PaletteWidget.ItemDropCallback)Mockito.verify((Object)this.itemDropCallback)).onDropItem(Matchers.eq((Object)this.definition), (ShapeFactory)Matchers.eq((Object)this.shapeFactory), Matchers.eq((double)10.0), Matchers.eq((double)20.0));
    }

    @Test
    public void checkOnDragProxyCompleteWhenCallbackIsNotSet() {
        this.widget.onDragProxyComplete(DEFINITION_ID, 10.0, 20.0);
        ((ClientFactoryService)Mockito.verify((Object)this.clientFactoryServices, (VerificationMode)Mockito.never())).getClientFactoryManager();
    }

    @Test
    public void checkGetShapeGlyphForKnownDefinition() {
        this.widget.bind((HasPaletteItems)this.palette);
        Assert.assertEquals((Object)this.glyph, (Object)this.widget.getShapeGlyph(DEFINITION_ID));
    }

    @Test
    public void checkGetShapeGlyphForUnknownDefinition() {
        this.widget.bind((HasPaletteItems)this.palette);
        Assert.assertNull((Object)this.widget.getShapeGlyph(""));
    }

    @Test
    public void checkBeforeBindClearsView() {
        this.widget.beforeBind();
        ((DMNPaletteWidgetView)Mockito.verify((Object)this.view)).clear();
        ((DMNPaletteWidgetView)Mockito.verify((Object)this.view)).showEmptyView(Matchers.eq((boolean)false));
    }

    @Test
    public void checkBindInitialisesView() {
        final DefinitionPaletteItem item1 = (DefinitionPaletteItem)Mockito.mock(DefinitionPaletteItem.class);
        final DefinitionPaletteItem item2 = (DefinitionPaletteItem)Mockito.mock(DefinitionPaletteItem.class);
        ArrayList<DefinitionPaletteItem> items = new ArrayList<DefinitionPaletteItem>(){
            {
                this.add(item1);
                this.add(item2);
            }
        };
        DMNPaletteItemWidget paletteItemWidget = (DMNPaletteItemWidget)Mockito.mock(DMNPaletteItemWidget.class);
        Mockito.when((Object)this.palette.getItems()).thenReturn((Object)items);
        Mockito.when((Object)this.paletteItemWidgets.get()).thenReturn((Object)paletteItemWidget);
        this.widget.bind((HasPaletteItems)this.palette);
        ((DMNPaletteItemWidget)Mockito.verify((Object)paletteItemWidget, (VerificationMode)Mockito.times((int)1))).initialize((DefinitionPaletteItem)Matchers.eq((Object)item1), (ShapeFactory)Matchers.eq((Object)this.shapeFactory), (Palette.ItemMouseDownCallback)Mockito.any(Palette.ItemMouseDownCallback.class));
        ((DMNPaletteItemWidget)Mockito.verify((Object)paletteItemWidget, (VerificationMode)Mockito.times((int)1))).initialize((DefinitionPaletteItem)Matchers.eq((Object)item2), (ShapeFactory)Matchers.eq((Object)this.shapeFactory), (Palette.ItemMouseDownCallback)Mockito.any(Palette.ItemMouseDownCallback.class));
        ((DMNPaletteWidgetView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)2))).add(paletteItemWidget);
    }

    @Test
    public void checkUnbindWhenPaletteIsBound() {
        this.widget.bind((HasPaletteItems)this.palette);
        Mockito.reset((Object[])new DMNPaletteWidgetView[]{this.view});
        this.widget.unbind();
        ((DMNPaletteWidgetView)Mockito.verify((Object)this.view)).clear();
        ((DMNPaletteWidgetView)Mockito.verify((Object)this.view)).showEmptyView(Matchers.eq((boolean)true));
    }

    @Test
    public void checkUnbindWhenPaletteIsNotBound() {
        this.widget.unbind();
        ((DMNPaletteWidgetView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).clear();
        ((DMNPaletteWidgetView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).showEmptyView(Mockito.anyBoolean());
    }

    @Test
    public void checkDoDestroy() {
        BS3PaletteViewFactory viewFactory = (BS3PaletteViewFactory)Mockito.mock(BS3PaletteViewFactory.class);
        this.widget.setViewFactory(viewFactory);
        this.widget.doDestroy();
        ((ManagedInstance)Mockito.verify(this.paletteItemWidgets)).destroyAll();
        ((BS3PaletteViewFactory)Mockito.verify((Object)viewFactory)).destroy();
        ((DMNPaletteWidgetView)Mockito.verify((Object)this.view)).destroy();
    }

    @Test
    public void checkOnScreenMaximisedDiagramEditor() {
        ScreenMaximizedEvent event = new ScreenMaximizedEvent(true);
        this.widget.onScreenMaximized(event);
        ((DMNPaletteWidgetView)Mockito.verify((Object)this.view)).showEmptyView(false);
    }

    @Test
    public void checkOnScreenMaximisedDiagramEditorShowingExpressionEditor() {
        this.widget.setVisible(BaseNavigateCommand.HIDDEN);
        Mockito.reset((Object[])new DMNPaletteWidgetView[]{this.view});
        ScreenMaximizedEvent event = new ScreenMaximizedEvent(true);
        this.widget.onScreenMaximized(event);
        ((DMNPaletteWidgetView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).showEmptyView(Mockito.anyBoolean());
    }

    @Test
    public void checkOnScreenMaximisedNotDiagramEditor() {
        Mockito.reset((Object[])new DMNPaletteWidgetView[]{this.view});
        ScreenMaximizedEvent event = new ScreenMaximizedEvent(false);
        this.widget.onScreenMaximized(event);
        ((DMNPaletteWidgetView)Mockito.verify((Object)this.view)).showEmptyView(true);
    }

    @Test
    public void checkOnScreenMinimisedDiagramEditor() {
        ScreenMinimizedEvent event = new ScreenMinimizedEvent(true);
        this.widget.onScreenMinimized(event);
        ((DMNPaletteWidgetView)Mockito.verify((Object)this.view)).showEmptyView(false);
    }

    @Test
    public void checkOnScreenMinimisedDiagramEditorShowingExpressionEditor() {
        this.widget.setVisible(BaseNavigateCommand.HIDDEN);
        Mockito.reset((Object[])new DMNPaletteWidgetView[]{this.view});
        ScreenMinimizedEvent event = new ScreenMinimizedEvent(true);
        this.widget.onScreenMinimized(event);
        ((DMNPaletteWidgetView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).showEmptyView(Mockito.anyBoolean());
    }

    @Test
    public void checkOnScreenMinimisedNotDiagramEditor() {
        ScreenMinimizedEvent event = new ScreenMinimizedEvent(false);
        this.widget.onScreenMinimized(event);
        ((DMNPaletteWidgetView)Mockito.verify((Object)this.view)).showEmptyView(false);
    }
}

