/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.expressions;

import com.ait.lienzo.client.core.mediator.IMediator;
import com.ait.lienzo.client.core.mediator.Mediators;
import com.ait.lienzo.client.core.shape.IPrimitive;
import com.ait.lienzo.client.core.shape.Viewport;
import com.ait.lienzo.client.core.types.Transform;
import com.ait.lienzo.test.LienzoMockitoTestRunner;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.Element;
import java.util.Optional;
import org.jboss.errai.common.client.dom.Anchor;
import org.jboss.errai.common.client.dom.Div;
import org.jboss.errai.common.client.dom.Document;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.definition.HasExpression;
import org.kie.workbench.common.dmn.api.definition.HasName;
import org.kie.workbench.common.dmn.api.definition.v1_1.Expression;
import org.kie.workbench.common.dmn.api.property.dmn.Name;
import org.kie.workbench.common.dmn.client.editors.expressions.ExpressionEditorViewImpl;
import org.kie.workbench.common.dmn.client.editors.expressions.types.ExpressionEditorDefinition;
import org.kie.workbench.common.dmn.client.widgets.grid.BaseExpressionGrid;
import org.kie.workbench.common.dmn.client.widgets.grid.model.GridCellTuple;
import org.kie.workbench.common.dmn.client.widgets.layer.DMNGridLayer;
import org.kie.workbench.common.dmn.client.widgets.panel.DMNGridPanel;
import org.kie.workbench.common.stunner.core.client.api.SessionManager;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.command.SessionCommandManager;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridData;
import org.uberfire.ext.wires.core.grids.client.widget.grid.GridWidget;
import org.uberfire.ext.wires.core.grids.client.widget.layer.impl.DefaultGridLayer;
import org.uberfire.ext.wires.core.grids.client.widget.layer.pinning.TransformMediator;
import org.uberfire.ext.wires.core.grids.client.widget.layer.pinning.impl.RestrictedMousePanMediator;

@RunWith(value=LienzoMockitoTestRunner.class)
public class ExpressionEditorViewImplTest {
    @Mock
    private Anchor returnToDRG;
    @Mock
    private Div expressionEditorControls;
    @Mock
    private Document document;
    @Mock
    private TranslationService translationService;
    @Mock
    private DMNGridPanel gridPanel;
    @Mock
    private DMNGridLayer gridLayer;
    @Mock
    private RestrictedMousePanMediator mousePanMediator;
    @Mock
    private SessionManager sessionManager;
    @Mock
    private SessionCommandManager<AbstractCanvasHandler> sessionCommandManager;
    @Mock
    private Viewport viewport;
    @Mock
    private Element gridPanelElement;
    @Mock
    private Mediators viewportMediators;
    @Mock
    private ExpressionEditorDefinition<Expression> editorDefinition;
    @Mock
    private BaseExpressionGrid editor;
    @Mock
    private HasExpression hasExpression;
    @Captor
    private ArgumentCaptor<Transform> transformArgumentCaptor;
    @Captor
    private ArgumentCaptor<GridWidget> expressionContainerArgumentCaptor;
    @Captor
    private ArgumentCaptor<TransformMediator> transformMediatorArgumentCaptor;
    private GridCellTuple expressionContainerTuple;
    private ExpressionEditorViewImpl view;

    @Before
    public void setup() {
        ((DMNGridPanel)Mockito.doReturn((Object)this.viewport).when((Object)this.gridPanel)).getViewport();
        ((Viewport)Mockito.doReturn((Object)this.viewportMediators).when((Object)this.viewport)).getMediators();
        ((DMNGridPanel)Mockito.doReturn((Object)this.gridPanelElement).when((Object)this.gridPanel)).getElement();
        ((ExpressionEditorDefinition)Mockito.doReturn(Optional.of(this.editor)).when(this.editorDefinition)).getEditor((GridCellTuple)Matchers.any(GridCellTuple.class), (HasExpression)Matchers.any(HasExpression.class), (Optional)Matchers.any(Optional.class), (Optional)Matchers.any(Optional.class), Matchers.anyBoolean());
        ((BaseExpressionGrid)Mockito.doReturn((Object)new BaseGridData()).when((Object)this.editor)).getModel();
        ((BaseExpressionGrid)Mockito.doReturn(Optional.empty()).when((Object)this.editor)).getEditorControls();
        this.view = (ExpressionEditorViewImpl)Mockito.spy((Object)new ExpressionEditorViewImpl(this.returnToDRG, this.expressionEditorControls, this.document, this.translationService, this.gridPanel, this.gridLayer, this.mousePanMediator, this.sessionManager, this.sessionCommandManager));
        ((ExpressionEditorViewImpl)Mockito.doAnswer(i -> {
            this.expressionContainerTuple = (GridCellTuple)Mockito.spy((Object)i.callRealMethod());
            return this.expressionContainerTuple;
        }).when((Object)this.view)).getExpressionContainerTuple();
        ((TranslationService)Mockito.doAnswer(i -> i.getArguments()[1]).when((Object)this.translationService)).format(Matchers.anyString(), (Object[])Matchers.anyObject());
    }

    @Test
    public void testSetupGridPanel() {
        ((Viewport)Mockito.verify((Object)this.viewport)).setTransform((Transform)this.transformArgumentCaptor.capture());
        Transform transform = (Transform)this.transformArgumentCaptor.getValue();
        Assert.assertEquals((double)1.0, (double)transform.getScaleX(), (double)0.0);
        Assert.assertEquals((double)1.0, (double)transform.getScaleY(), (double)0.0);
        ((DMNGridPanel)Mockito.verify((Object)this.gridPanel)).add((DefaultGridLayer)this.gridLayer);
    }

    @Test
    public void testSetupGridWidget() {
        ((DMNGridLayer)Mockito.verify((Object)this.gridLayer)).removeAll();
        ((DMNGridLayer)Mockito.verify((Object)this.gridLayer)).add((IPrimitive)this.expressionContainerArgumentCaptor.capture());
        GridWidget expressionContainer = (GridWidget)this.expressionContainerArgumentCaptor.getValue();
        ((DMNGridLayer)Mockito.verify((Object)this.gridLayer)).select((GridWidget)Matchers.eq((Object)expressionContainer));
        ((DMNGridLayer)Mockito.verify((Object)this.gridLayer)).enterPinnedMode((GridWidget)Matchers.eq((Object)expressionContainer), (Command)Matchers.any(Command.class));
    }

    @Test
    public void testSetupGridWidgetPanControl() {
        ((RestrictedMousePanMediator)Mockito.verify((Object)this.mousePanMediator)).setTransformMediator((TransformMediator)this.transformMediatorArgumentCaptor.capture());
        TransformMediator transformMediator = (TransformMediator)this.transformMediatorArgumentCaptor.getValue();
        ((RestrictedMousePanMediator)Mockito.verify((Object)this.mousePanMediator)).setBatchDraw(true);
        ((DMNGridLayer)Mockito.verify((Object)this.gridLayer)).setDefaultTransformMediator((TransformMediator)Matchers.eq((Object)transformMediator));
        ((Mediators)Mockito.verify((Object)this.viewportMediators)).push((IMediator)Matchers.eq((Object)this.mousePanMediator));
    }

    @Test
    public void testOnResize() {
        this.view.onResize();
        ((DMNGridPanel)Mockito.verify((Object)this.gridPanel)).onResize();
    }

    @Test
    public void testSetEditorResizesContainer() {
        Optional hasName = Optional.empty();
        Optional expression = Optional.empty();
        this.view.setEditor(this.editorDefinition, this.hasExpression, hasName, expression);
        ((GridCellTuple)Mockito.verify((Object)this.expressionContainerTuple)).onResize();
    }

    @Test
    public void testSetEditorDoesUpdateReturnToDRGTextWhenHasNameIsNotEmpty() {
        String NAME = "NAME";
        Name name = new Name("NAME");
        HasName hasNameMock = (HasName)Mockito.mock(HasName.class);
        ((HasName)Mockito.doReturn((Object)name).when((Object)hasNameMock)).getName();
        Optional<HasName> hasName = Optional.of(hasNameMock);
        Optional expression = Optional.empty();
        this.view.setEditor(this.editorDefinition, this.hasExpression, hasName, expression);
        ((Anchor)Mockito.verify((Object)this.returnToDRG)).setTextContent((String)Matchers.eq((Object)"NAME"));
    }

    @Test
    public void testSetEditorDoesNotUpdateReturnToDRGTextWhenHasNameIsEmpty() {
        Optional hasName = Optional.empty();
        Optional expression = Optional.empty();
        this.view.setEditor(this.editorDefinition, this.hasExpression, hasName, expression);
        ((Anchor)Mockito.verify((Object)this.returnToDRG, (VerificationMode)Mockito.never())).setTextContent((String)Matchers.any(String.class));
    }
}

