/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.expressions.types.context;

import com.ait.lienzo.test.LienzoMockitoTestRunner;
import java.util.Collections;
import java.util.Optional;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.definition.v1_1.Context;
import org.kie.workbench.common.dmn.client.commands.expressions.types.context.MoveRowsCommand;
import org.kie.workbench.common.dmn.client.editors.expressions.types.context.ContextGridData;
import org.kie.workbench.common.dmn.client.widgets.grid.model.DMNGridData;
import org.kie.workbench.common.stunner.core.client.api.SessionManager;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.command.SessionCommandManager;
import org.kie.workbench.common.stunner.core.client.session.ClientSession;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommandResultBuilder;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.ext.wires.core.grids.client.model.GridRow;
import org.uberfire.mvp.Command;

@RunWith(value=LienzoMockitoTestRunner.class)
public class ContextGridDataTest {
    @Mock
    private GridRow gridRow;
    @Mock
    private SessionManager sessionManager;
    @Mock
    private SessionCommandManager<AbstractCanvasHandler> sessionCommandManager;
    @Mock
    private ClientSession session;
    @Mock
    private AbstractCanvasHandler canvasHandler;
    @Mock
    private Command canvasOperation;
    @Mock
    private DMNGridData delegate;
    private ContextGridData uiModel;
    private Optional<Context> expression = Optional.of(new Context());

    @Before
    public void setup() {
        this.uiModel = new ContextGridData(this.delegate, this.sessionManager, this.sessionCommandManager, this.expression, this.canvasOperation);
        ((SessionManager)Mockito.doReturn((Object)this.session).when((Object)this.sessionManager)).getCurrentSession();
        ((ClientSession)Mockito.doReturn((Object)this.canvasHandler).when((Object)this.session)).getCanvasHandler();
    }

    @Test
    public void testMoveRowToPermitted() {
        ((SessionCommandManager)Mockito.doReturn((Object)GraphCommandResultBuilder.SUCCESS).when(this.sessionCommandManager)).allow(Matchers.eq((Object)this.canvasHandler), (org.kie.workbench.common.stunner.core.command.Command)Matchers.any(MoveRowsCommand.class));
        this.uiModel.moveRowTo(0, this.gridRow);
        ((SessionCommandManager)Mockito.verify(this.sessionCommandManager)).execute(Matchers.eq((Object)this.canvasHandler), (org.kie.workbench.common.stunner.core.command.Command)Matchers.any(MoveRowsCommand.class));
    }

    @Test
    public void testMoveRowsToPermitted() {
        ((SessionCommandManager)Mockito.doReturn((Object)GraphCommandResultBuilder.SUCCESS).when(this.sessionCommandManager)).allow(Matchers.eq((Object)this.canvasHandler), (org.kie.workbench.common.stunner.core.command.Command)Matchers.any(MoveRowsCommand.class));
        this.uiModel.moveRowsTo(0, Collections.singletonList(this.gridRow));
        ((SessionCommandManager)Mockito.verify(this.sessionCommandManager)).execute(Matchers.eq((Object)this.canvasHandler), (org.kie.workbench.common.stunner.core.command.Command)Matchers.any(MoveRowsCommand.class));
    }

    @Test
    public void testMoveRowToNotPermitted() {
        ((SessionCommandManager)Mockito.doReturn((Object)GraphCommandResultBuilder.FAILED).when(this.sessionCommandManager)).allow(Matchers.eq((Object)this.canvasHandler), (org.kie.workbench.common.stunner.core.command.Command)Matchers.any(MoveRowsCommand.class));
        this.uiModel.moveRowTo(0, this.gridRow);
        ((SessionCommandManager)Mockito.verify(this.sessionCommandManager, (VerificationMode)Mockito.never())).execute(Matchers.any(AbstractCanvasHandler.class), (org.kie.workbench.common.stunner.core.command.Command)Matchers.any(MoveRowsCommand.class));
    }

    @Test
    public void testMoveRowsToNotPermitted() {
        ((SessionCommandManager)Mockito.doReturn((Object)GraphCommandResultBuilder.FAILED).when(this.sessionCommandManager)).allow(Matchers.eq((Object)this.canvasHandler), (org.kie.workbench.common.stunner.core.command.Command)Matchers.any(MoveRowsCommand.class));
        this.uiModel.moveRowsTo(0, Collections.singletonList(this.gridRow));
        ((SessionCommandManager)Mockito.verify(this.sessionCommandManager, (VerificationMode)Mockito.never())).execute(Matchers.any(AbstractCanvasHandler.class), (org.kie.workbench.common.stunner.core.command.Command)Matchers.any(MoveRowsCommand.class));
    }
}

