/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.expressions.types.context;

import com.ait.lienzo.test.LienzoMockitoTestRunner;
import java.util.ArrayList;
import java.util.Optional;
import java.util.function.Supplier;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.definition.HasExpression;
import org.kie.workbench.common.dmn.api.definition.HasName;
import org.kie.workbench.common.dmn.api.definition.v1_1.LiteralExpression;
import org.kie.workbench.common.dmn.client.commands.expressions.types.context.AddContextEntryCommand;
import org.kie.workbench.common.dmn.client.editors.expressions.types.ExpressionEditorDefinition;
import org.kie.workbench.common.dmn.client.editors.expressions.types.ExpressionEditorDefinitions;
import org.kie.workbench.common.dmn.client.editors.expressions.types.context.ContextEditorDefinition;
import org.kie.workbench.common.dmn.client.editors.expressions.types.context.ContextGrid;
import org.kie.workbench.common.dmn.client.editors.expressions.types.context.ContextGridControls;
import org.kie.workbench.common.dmn.client.editors.expressions.types.context.ContextGridData;
import org.kie.workbench.common.dmn.client.editors.expressions.types.context.ExpressionCellValue;
import org.kie.workbench.common.dmn.client.editors.expressions.types.context.ExpressionEditorColumn;
import org.kie.workbench.common.dmn.client.editors.expressions.types.context.NameColumn;
import org.kie.workbench.common.dmn.client.events.ExpressionEditorSelectedEvent;
import org.kie.workbench.common.dmn.client.widgets.grid.BaseExpressionGrid;
import org.kie.workbench.common.dmn.client.widgets.grid.model.GridCellTuple;
import org.kie.workbench.common.dmn.client.widgets.layer.DMNGridLayer;
import org.kie.workbench.common.dmn.client.widgets.panel.DMNGridPanel;
import org.kie.workbench.common.stunner.core.client.api.SessionManager;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.command.SessionCommandManager;
import org.kie.workbench.common.stunner.core.client.session.ClientSession;
import org.kie.workbench.common.stunner.core.command.Command;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.uberfire.ext.wires.core.grids.client.model.GridData;
import org.uberfire.ext.wires.core.grids.client.model.GridRow;
import org.uberfire.ext.wires.core.grids.client.widget.dnd.GridWidgetDnDHandlersState;
import org.uberfire.ext.wires.core.grids.client.widget.grid.columns.RowNumberColumn;
import org.uberfire.mocks.EventSourceMock;

@RunWith(value=LienzoMockitoTestRunner.class)
public class ContextGridTest {
    @Mock
    private DMNGridPanel gridPanel;
    @Mock
    private DMNGridLayer gridLayer;
    @Mock
    private SessionManager sessionManager;
    @Mock
    private ClientSession session;
    @Mock
    private AbstractCanvasHandler handler;
    @Mock
    private SessionCommandManager<AbstractCanvasHandler> sessionCommandManager;
    @Mock
    private Supplier<ExpressionEditorDefinitions> expressionEditorDefinitionsSupplier;
    @Mock
    private EventSourceMock<ExpressionEditorSelectedEvent> editorSelectedEvent;
    @Mock
    private ManagedInstance<ContextGridControls> controlsProvider;
    @Mock
    private ContextGridControls controls;
    @Mock
    private GridCellTuple parent;
    @Mock
    private HasExpression hasExpression;
    @Mock
    private ExpressionEditorDefinition literalExpressionEditorDefinition;
    @Mock
    private BaseExpressionGrid literalExpressionEditor;
    @Mock
    private GridWidgetDnDHandlersState dndHandlersState;
    @Captor
    private ArgumentCaptor<AddContextEntryCommand> addContextEntryCommandCaptor;
    private LiteralExpression literalExpression = new LiteralExpression();
    private Optional<HasName> hasName = Optional.empty();
    private ContextGrid grid;

    @Before
    public void setup() {
        ContextEditorDefinition definition = new ContextEditorDefinition(this.gridPanel, this.gridLayer, this.sessionManager, this.sessionCommandManager, this.expressionEditorDefinitionsSupplier, this.editorSelectedEvent, this.controlsProvider);
        Optional expression = definition.getModelClass();
        ExpressionEditorDefinitions expressionEditorDefinitions = new ExpressionEditorDefinitions();
        expressionEditorDefinitions.add((Object)definition);
        expressionEditorDefinitions.add((Object)this.literalExpressionEditorDefinition);
        ((ManagedInstance)Mockito.doReturn((Object)this.controls).when(this.controlsProvider)).get();
        ((Supplier)Mockito.doReturn((Object)expressionEditorDefinitions).when(this.expressionEditorDefinitionsSupplier)).get();
        ((ExpressionEditorDefinition)Mockito.doReturn(Optional.of(this.literalExpression)).when((Object)this.literalExpressionEditorDefinition)).getModelClass();
        ((ExpressionEditorDefinition)Mockito.doReturn(Optional.of(this.literalExpressionEditor)).when((Object)this.literalExpressionEditorDefinition)).getEditor((GridCellTuple)Matchers.any(GridCellTuple.class), (HasExpression)Matchers.any(HasExpression.class), (Optional)Matchers.any(Optional.class), (Optional)Matchers.any(Optional.class), Matchers.anyBoolean());
        ((SessionManager)Mockito.doReturn((Object)this.session).when((Object)this.sessionManager)).getCurrentSession();
        ((ClientSession)Mockito.doReturn((Object)this.handler).when((Object)this.session)).getCanvasHandler();
        this.grid = (ContextGrid)definition.getEditor(this.parent, this.hasExpression, expression, this.hasName, false).get();
    }

    @Test
    public void testInitialSetupFromDefinition() {
        GridData uiModel = this.grid.getModel();
        Assert.assertTrue((boolean)(uiModel instanceof ContextGridData));
        Assert.assertEquals((long)3L, (long)uiModel.getColumnCount());
        Assert.assertTrue((boolean)(uiModel.getColumns().get(0) instanceof RowNumberColumn));
        Assert.assertTrue((boolean)(uiModel.getColumns().get(1) instanceof NameColumn));
        Assert.assertTrue((boolean)(uiModel.getColumns().get(2) instanceof ExpressionEditorColumn));
        Assert.assertEquals((long)2L, (long)uiModel.getRowCount());
        Assert.assertEquals((Object)1, (Object)uiModel.getCell(0, 0).getValue().getValue());
        Assert.assertEquals((Object)"My name", (Object)uiModel.getCell(0, 1).getValue().getValue());
        Assert.assertNull((Object)uiModel.getCell(0, 2));
        Assert.assertNull((Object)uiModel.getCell(1, 0));
        Assert.assertEquals((Object)"default", (Object)uiModel.getCell(1, 1).getValue().getValue());
        Assert.assertTrue((boolean)(uiModel.getCell(1, 2).getValue() instanceof ExpressionCellValue));
        ExpressionCellValue dcv = (ExpressionCellValue)uiModel.getCell(1, 2).getValue();
        Assert.assertEquals((Object)this.literalExpressionEditor, ((Optional)dcv.getValue()).get());
    }

    @Test
    public void testRowDragPermittedNotPendingRowMove() {
        ((GridWidgetDnDHandlersState)Mockito.doReturn((Object)GridWidgetDnDHandlersState.GridWidgetHandlersOperation.NONE).when((Object)this.dndHandlersState)).getOperation();
        Assert.assertTrue((boolean)this.grid.isRowDragPermitted(this.dndHandlersState));
    }

    @Test
    public void testRowDragPermittedPendingRowMoveNotLastRow() {
        this.assertRowDragPermitted(0, true);
    }

    @Test
    public void testRowDragPermittedPendingRowMoveLastRow() {
        this.assertRowDragPermitted(1, false);
    }

    private void assertRowDragPermitted(int uiModelRowIndex, boolean isPermitted) {
        ArrayList<GridRow> rows = new ArrayList<GridRow>();
        rows.add(this.grid.getModel().getRow(uiModelRowIndex));
        ((GridWidgetDnDHandlersState)Mockito.doReturn((Object)GridWidgetDnDHandlersState.GridWidgetHandlersOperation.ROW_MOVE_PENDING).when((Object)this.dndHandlersState)).getOperation();
        ((GridWidgetDnDHandlersState)Mockito.doReturn(rows).when((Object)this.dndHandlersState)).getActiveGridRows();
        Assert.assertEquals((Object)isPermitted, (Object)this.grid.isRowDragPermitted(this.dndHandlersState));
    }

    @Test
    public void testAddContextEntry() {
        this.grid.addContextEntry();
        ((SessionCommandManager)Mockito.verify(this.sessionCommandManager)).execute(Matchers.eq((Object)this.handler), (Command)this.addContextEntryCommandCaptor.capture());
        AddContextEntryCommand addContextEntryCommand = (AddContextEntryCommand)this.addContextEntryCommandCaptor.getValue();
        addContextEntryCommand.execute(this.handler);
        ((GridCellTuple)Mockito.verify((Object)this.parent)).onResize();
        ((DMNGridPanel)Mockito.verify((Object)this.gridPanel)).refreshScrollPosition();
        ((DMNGridPanel)Mockito.verify((Object)this.gridPanel)).updatePanelSize();
        ((DMNGridLayer)Mockito.verify((Object)this.gridLayer)).batch();
    }
}

