/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.expressions.types.context;

import java.util.Optional;
import java.util.function.Supplier;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.definition.HasExpression;
import org.kie.workbench.common.dmn.api.definition.v1_1.Context;
import org.kie.workbench.common.dmn.api.definition.v1_1.ContextEntry;
import org.kie.workbench.common.dmn.api.definition.v1_1.Expression;
import org.kie.workbench.common.dmn.api.definition.v1_1.InformationItem;
import org.kie.workbench.common.dmn.api.definition.v1_1.LiteralExpression;
import org.kie.workbench.common.dmn.api.property.dmn.Name;
import org.kie.workbench.common.dmn.client.editors.expressions.types.ExpressionEditorDefinition;
import org.kie.workbench.common.dmn.client.editors.expressions.types.ExpressionEditorDefinitions;
import org.kie.workbench.common.dmn.client.editors.expressions.types.context.ContextUIModelMapper;
import org.kie.workbench.common.dmn.client.editors.expressions.types.context.ExpressionCellValue;
import org.kie.workbench.common.dmn.client.editors.expressions.types.context.ExpressionEditorColumn;
import org.kie.workbench.common.dmn.client.editors.expressions.types.context.NameColumn;
import org.kie.workbench.common.dmn.client.editors.expressions.types.literal.LiteralExpressionGrid;
import org.kie.workbench.common.dmn.client.widgets.grid.model.DMNGridRow;
import org.kie.workbench.common.dmn.client.widgets.grid.model.GridCellTuple;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.uberfire.ext.wires.core.grids.client.model.GridCellValue;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.model.GridRow;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridCellValue;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridData;
import org.uberfire.ext.wires.core.grids.client.widget.grid.columns.RowNumberColumn;

@RunWith(value=MockitoJUnitRunner.class)
public class ContextUIModelMapperTest {
    @Mock
    private RowNumberColumn uiRowNumberColumn;
    @Mock
    private NameColumn uiNameColumn;
    @Mock
    private ExpressionEditorColumn uiExpressionEditorColumn;
    @Mock
    private Supplier<ExpressionEditorDefinitions> expressionEditorDefinitionsSupplier;
    @Mock
    private ExpressionEditorDefinition literalExpressionEditorDefinition;
    @Mock
    private LiteralExpressionGrid literalExpressionEditor;
    private LiteralExpression literalExpression = new LiteralExpression();
    private BaseGridData uiModel;
    private Context context;
    private Supplier<Optional<GridCellValue<?>>> cellValueSupplier;
    private ContextUIModelMapper mapper;

    @Before
    public void setup() {
        this.uiModel = new BaseGridData();
        this.uiModel.appendRow((GridRow)new DMNGridRow());
        this.uiModel.appendRow((GridRow)new DMNGridRow());
        this.uiModel.appendColumn((GridColumn)this.uiRowNumberColumn);
        this.uiModel.appendColumn((GridColumn)this.uiNameColumn);
        this.uiModel.appendColumn((GridColumn)this.uiExpressionEditorColumn);
        ((RowNumberColumn)Mockito.doReturn((Object)0).when((Object)this.uiRowNumberColumn)).getIndex();
        ((NameColumn)Mockito.doReturn((Object)1).when((Object)this.uiNameColumn)).getIndex();
        ((ExpressionEditorColumn)Mockito.doReturn((Object)2).when((Object)this.uiExpressionEditorColumn)).getIndex();
        ExpressionEditorDefinitions expressionEditorDefinitions = new ExpressionEditorDefinitions();
        expressionEditorDefinitions.add((Object)this.literalExpressionEditorDefinition);
        ((Supplier)Mockito.doReturn((Object)expressionEditorDefinitions).when(this.expressionEditorDefinitionsSupplier)).get();
        ((ExpressionEditorDefinition)Mockito.doReturn(Optional.of(this.literalExpression)).when((Object)this.literalExpressionEditorDefinition)).getModelClass();
        ((LiteralExpressionGrid)Mockito.doReturn(Optional.of(this.literalExpression)).when((Object)this.literalExpressionEditor)).getExpression();
        ((ExpressionEditorDefinition)Mockito.doReturn(Optional.of(this.literalExpressionEditor)).when((Object)this.literalExpressionEditorDefinition)).getEditor((GridCellTuple)Matchers.any(GridCellTuple.class), (HasExpression)Matchers.any(HasExpression.class), (Optional)Matchers.any(Optional.class), (Optional)Matchers.any(Optional.class), Matchers.anyBoolean());
        this.context = new Context();
        this.context.getContextEntry().add(new ContextEntry(){
            {
                this.setVariable(new InformationItem(){
                    {
                        this.setName(new Name("ii1"));
                    }
                });
            }
        });
        this.context.getContextEntry().add(new ContextEntry(){
            {
                this.setExpression((Expression)new LiteralExpression());
            }
        });
        this.mapper = new ContextUIModelMapper(() -> this.uiModel, () -> Optional.of(this.context), this.expressionEditorDefinitionsSupplier);
        this.cellValueSupplier = Optional::empty;
    }

    @Test
    public void testFromDMNModelRowNumber() {
        this.mapper.fromDMNModel(0, 0);
        this.mapper.fromDMNModel(1, 0);
        Assert.assertEquals((Object)1, (Object)this.uiModel.getCell(0, 0).getValue().getValue());
        Assert.assertEquals((Object)2, (Object)this.uiModel.getCell(1, 0).getValue().getValue());
    }

    @Test
    public void testFromDMNModelName() {
        this.mapper.fromDMNModel(0, 1);
        this.mapper.fromDMNModel(1, 1);
        Assert.assertEquals((Object)"ii1", (Object)this.uiModel.getCell(0, 1).getValue().getValue());
        Assert.assertEquals((Object)"default", (Object)this.uiModel.getCell(1, 1).getValue().getValue());
    }

    @Test
    public void testFromDMNModelExpression() {
        this.mapper.fromDMNModel(0, 2);
        this.mapper.fromDMNModel(1, 2);
        Assert.assertNull((Object)this.uiModel.getCell(0, 2));
        Assert.assertTrue((boolean)(this.uiModel.getCell(1, 2).getValue() instanceof ExpressionCellValue));
        ExpressionCellValue dcv = (ExpressionCellValue)this.uiModel.getCell(1, 2).getValue();
        Assert.assertEquals((Object)this.literalExpressionEditor, ((Optional)dcv.getValue()).get());
    }

    @Test
    public void testToDMNModelName() {
        this.cellValueSupplier = () -> Optional.of(new BaseGridCellValue((Object)"ii2"));
        this.mapper.toDMNModel(0, 1, this.cellValueSupplier);
        Assert.assertEquals((Object)"ii2", (Object)((ContextEntry)this.context.getContextEntry().get(0)).getVariable().getName().getValue());
    }

    @Test
    public void testToDMNModelExpression() {
        this.cellValueSupplier = () -> Optional.of(new ExpressionCellValue(Optional.of(this.literalExpressionEditor)));
        this.mapper.toDMNModel(0, 2, this.cellValueSupplier);
        Assert.assertEquals((Object)this.literalExpression, (Object)((ContextEntry)this.context.getContextEntry().get(0)).getExpression());
    }
}

