/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.expressions.types.context;

import com.ait.lienzo.client.core.shape.Group;
import com.ait.lienzo.client.core.shape.IPrimitive;
import com.ait.lienzo.test.LienzoMockitoTestRunner;
import com.google.gwtmockito.GwtMockito;
import java.util.Optional;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.client.editors.expressions.types.context.ExpressionCellValue;
import org.kie.workbench.common.dmn.client.editors.expressions.types.context.ExpressionEditorColumnRenderer;
import org.kie.workbench.common.dmn.client.widgets.grid.BaseExpressionGrid;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.ext.wires.core.grids.client.model.GridCell;
import org.uberfire.ext.wires.core.grids.client.model.GridCellValue;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridCell;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridCellValue;
import org.uberfire.ext.wires.core.grids.client.widget.context.GridBodyCellRenderContext;

@RunWith(value=LienzoMockitoTestRunner.class)
public class ExpressionEditorColumnRendererTest {
    @Mock
    private GridBodyCellRenderContext context;
    @Mock
    private BaseExpressionGrid widget;
    @Mock
    private Group renderedGroup;
    @Mock
    private Group editorGroup;
    private GridCell<Optional<BaseExpressionGrid>> cell;
    private ExpressionEditorColumnRenderer renderer;

    @Before
    public void setUp() throws Exception {
        GwtMockito.useProviderForType(Group.class, aClass -> this.renderedGroup);
        this.renderer = new ExpressionEditorColumnRenderer();
        ((BaseExpressionGrid)Mockito.doReturn((Object)this.editorGroup).when((Object)this.widget)).setX(Matchers.anyDouble());
        ((Group)Mockito.doReturn((Object)this.editorGroup).when((Object)this.editorGroup)).setY(Matchers.anyDouble());
    }

    @Test
    public void testRenderCellNoDMNExpression() throws Exception {
        this.cell = new BaseGridCell((GridCellValue)new BaseGridCellValue(Optional.of(this.widget)));
        this.renderer.renderCell(this.cell, this.context);
        ((Group)Mockito.verify((Object)this.renderedGroup, (VerificationMode)Mockito.never())).add((IPrimitive)Matchers.any());
    }

    @Test
    public void testRenderCellDMNExpression() throws Exception {
        this.cell = new BaseGridCell((GridCellValue)new ExpressionCellValue(Optional.of(this.widget)));
        this.renderer.renderCell(this.cell, this.context);
        ((Group)Mockito.verify((Object)this.renderedGroup)).add((IPrimitive)this.editorGroup);
    }
}

