/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.expressions.types.context;

import com.ait.lienzo.test.LienzoMockitoTestRunner;
import java.util.Optional;
import javax.enterprise.event.Event;
import org.assertj.core.api.Assertions;
import org.jboss.errai.common.client.api.IsElement;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.definition.HasExpression;
import org.kie.workbench.common.dmn.api.definition.HasName;
import org.kie.workbench.common.dmn.api.definition.v1_1.LiteralExpression;
import org.kie.workbench.common.dmn.client.editors.expressions.mocks.MockHasDOMElementResourcesHeaderMetaData;
import org.kie.workbench.common.dmn.client.editors.expressions.types.context.ExpressionCellValue;
import org.kie.workbench.common.dmn.client.editors.expressions.types.context.ExpressionEditorColumn;
import org.kie.workbench.common.dmn.client.events.ExpressionEditorSelectedEvent;
import org.kie.workbench.common.dmn.client.widgets.grid.BaseExpressionGrid;
import org.kie.workbench.common.dmn.client.widgets.grid.model.BaseUIModelMapper;
import org.kie.workbench.common.dmn.client.widgets.grid.model.DMNGridColumn;
import org.kie.workbench.common.dmn.client.widgets.grid.model.DMNGridRow;
import org.kie.workbench.common.dmn.client.widgets.grid.model.GridCellTuple;
import org.kie.workbench.common.dmn.client.widgets.layer.DMNGridLayer;
import org.kie.workbench.common.dmn.client.widgets.panel.DMNGridPanel;
import org.kie.workbench.common.stunner.core.client.api.SessionManager;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.command.SessionCommandManager;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.uberfire.ext.wires.core.grids.client.model.GridCellValue;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.model.GridData;
import org.uberfire.ext.wires.core.grids.client.model.GridRow;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridData;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseHeaderMetaData;
import org.uberfire.ext.wires.core.grids.client.widget.grid.GridWidget;
import org.uberfire.ext.wires.core.grids.client.widget.grid.impl.BaseGridWidget;
import org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.columns.GridColumnRenderer;
import org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.grids.GridRenderer;
import org.uberfire.ext.wires.core.grids.client.widget.layer.GridSelectionManager;
import org.uberfire.ext.wires.core.grids.client.widget.layer.pinning.GridPinnedModeManager;
import org.uberfire.mocks.EventSourceMock;

@RunWith(value=LienzoMockitoTestRunner.class)
public class ExpressionEditorColumnTest {
    private static final double DEFAULT_WIDTH = 100.0;
    @Mock
    private GridSelectionManager selectionManager;
    @Mock
    private GridPinnedModeManager pinnedModeManager;
    @Mock
    private GridRenderer renderer;
    @Mock
    private DMNGridPanel gridPanel;
    @Mock
    private DMNGridLayer gridLayer;
    @Mock
    private SessionManager sessionManager;
    @Mock
    private SessionCommandManager<AbstractCanvasHandler> sessionCommandManager;
    @Mock
    private EventSourceMock<ExpressionEditorSelectedEvent> editorSelectedEvent;
    private BaseGridData gridData;
    private GridWidget widget;
    private ExpressionEditorColumn column;

    @Before
    public void setUp() throws Exception {
        this.gridData = new BaseGridData();
        this.widget = new BaseGridWidget((GridData)this.gridData, this.selectionManager, this.pinnedModeManager, this.renderer);
        this.column = new ExpressionEditorColumn((GridColumn.HeaderMetaData)new BaseHeaderMetaData("column header"), this.widget);
    }

    @Test
    public void testMinimalWidthNoContent() throws Exception {
        this.gridData.appendColumn((GridColumn)this.column);
        Assertions.assertThat((Double)this.column.getMinimumWidth()).isEqualTo(100.0);
    }

    @Test
    public void testMinimalWidthOneCellInEachRow() throws Exception {
        this.gridData.appendColumn((GridColumn)this.column);
        this.gridData.appendRow((GridRow)new DMNGridRow());
        this.gridData.appendRow((GridRow)new DMNGridRow());
        this.gridData.appendRow((GridRow)new DMNGridRow());
        this.mockCells(0, 0, 100.0);
        this.mockCells(1, 0, 150.0);
        this.mockCells(2, 0, 125.0);
        Assertions.assertThat((Double)this.column.getMinimumWidth()).isEqualTo(150.0);
    }

    @Test
    public void testMinimalWidthTwoCellsSum() throws Exception {
        this.gridData.appendColumn((GridColumn)this.column);
        this.gridData.appendRow((GridRow)new DMNGridRow());
        this.gridData.appendRow((GridRow)new DMNGridRow());
        this.gridData.appendRow((GridRow)new DMNGridRow());
        this.mockCells(0, 0, 100.0);
        this.mockCells(1, 0, 50.0, 60.0);
        this.mockCells(2, 0, 105.0);
        Assertions.assertThat((Double)this.column.getMinimumWidth()).isEqualTo(110.0);
    }

    @Test
    public void testMinimalWidthThreeCellsSum() throws Exception {
        this.gridData.appendColumn((GridColumn)this.column);
        this.gridData.appendRow((GridRow)new DMNGridRow());
        this.gridData.appendRow((GridRow)new DMNGridRow());
        this.gridData.appendRow((GridRow)new DMNGridRow());
        this.mockCells(0, 0, 100.0);
        this.mockCells(1, 0, 50.0, 60.0);
        this.mockCells(2, 0, 50.0, 60.0, 10.0);
        Assertions.assertThat((Double)this.column.getMinimumWidth()).isEqualTo(120.0);
    }

    @Test
    public void testMinimalWidthDefaultWidth() throws Exception {
        this.gridData.appendColumn((GridColumn)this.column);
        this.gridData.appendRow((GridRow)new DMNGridRow());
        this.gridData.appendRow((GridRow)new DMNGridRow());
        this.gridData.appendRow((GridRow)new DMNGridRow());
        this.mockCells(0, 0, 99.0);
        this.mockCells(1, 0, 30.0, 30.0, 30.0);
        this.mockCells(2, 0, 49.0, 50.0);
        Assertions.assertThat((Double)this.column.getMinimumWidth()).isEqualTo(100.0);
    }

    @Test
    public void testMinimalWidthNoCellsInMiddle() throws Exception {
        this.gridData.appendColumn((GridColumn)this.column);
        this.gridData.appendRow((GridRow)new DMNGridRow());
        this.gridData.appendRow((GridRow)new DMNGridRow());
        this.gridData.appendRow((GridRow)new DMNGridRow());
        this.mockCells(0, 0, 100.0);
        this.mockCells(1, 0, new double[0]);
        this.mockCells(2, 0, 50.0, 60.0);
        Assertions.assertThat((Double)this.column.getMinimumWidth()).isEqualTo(110.0);
    }

    @Test
    public void testUpdateInternalWidth() throws Exception {
        this.gridData.appendColumn((GridColumn)this.column);
        this.gridData.appendRow((GridRow)new DMNGridRow());
        this.gridData.appendRow((GridRow)new DMNGridRow());
        this.gridData.appendRow((GridRow)new DMNGridRow());
        this.mockCells(0, 0, 100.0);
        this.mockCells(1, 0, 110.0);
        this.mockCells(2, 0, 50.0, 60.0);
        this.column.setWidthInternal(200.0);
        Assertions.assertThat((double)this.getColumnWidth(0, 0, 0)).isEqualTo(200.0);
        Assertions.assertThat((double)this.getColumnWidth(1, 0, 0)).isEqualTo(200.0);
        Assertions.assertThat((double)this.getColumnWidth(2, 0, 0)).isEqualTo(50.0);
        Assertions.assertThat((double)this.getColumnWidth(2, 0, 1)).isEqualTo(150.0);
    }

    @Test
    public void testUpdateInternalWidthNoCellsInMiddle() throws Exception {
        this.gridData.appendColumn((GridColumn)this.column);
        this.gridData.appendRow((GridRow)new DMNGridRow());
        this.gridData.appendRow((GridRow)new DMNGridRow());
        this.gridData.appendRow((GridRow)new DMNGridRow());
        this.mockCells(0, 0, 100.0);
        this.mockCells(1, 0, new double[0]);
        this.mockCells(2, 0, 50.0, 60.0);
        this.column.setWidthInternal(200.0);
        Assertions.assertThat((double)this.getColumnWidth(0, 0, 0)).isEqualTo(200.0);
        Assertions.assertThat((double)this.getColumnWidth(2, 0, 0)).isEqualTo(50.0);
        Assertions.assertThat((double)this.getColumnWidth(2, 0, 1)).isEqualTo(150.0);
    }

    @Test
    public void testUpdateInternalWidthResizedToSmaller() throws Exception {
        this.gridData.appendColumn((GridColumn)this.column);
        this.gridData.appendRow((GridRow)new DMNGridRow());
        this.gridData.appendRow((GridRow)new DMNGridRow());
        this.gridData.appendRow((GridRow)new DMNGridRow());
        this.mockCells(0, 0, 100.0);
        this.mockCells(1, 0, 30.0, 30.0, 30.0);
        this.mockCells(2, 0, 50.0, 60.0);
        this.column.setWidthInternal(80.0);
        Assertions.assertThat((double)this.getColumnWidth(0, 0, 0)).isEqualTo(80.0);
        Assertions.assertThat((double)this.getColumnWidth(1, 0, 0)).isEqualTo(30.0);
        Assertions.assertThat((double)this.getColumnWidth(1, 0, 1)).isEqualTo(30.0);
        Assertions.assertThat((double)this.getColumnWidth(1, 0, 2)).isEqualTo(20.0);
        Assertions.assertThat((double)this.getColumnWidth(2, 0, 0)).isEqualTo(50.0);
        Assertions.assertThat((double)this.getColumnWidth(2, 0, 1)).isEqualTo(30.0);
    }

    @Test
    public void testHeaderDOMElementsAreDestroyed() {
        MockHasDOMElementResourcesHeaderMetaData mockHeaderMetaData = (MockHasDOMElementResourcesHeaderMetaData)Mockito.mock(MockHasDOMElementResourcesHeaderMetaData.class);
        this.column.getHeaderMetaData().add(mockHeaderMetaData);
        this.column.destroyResources();
        ((MockHasDOMElementResourcesHeaderMetaData)Mockito.verify((Object)mockHeaderMetaData)).destroyResources();
    }

    private void mockCells(int rowIndex, int columnIndex, double ... widthOfCells) {
        this.gridData.setCell(rowIndex, columnIndex, (GridCellValue)new ExpressionCellValue(Optional.of(this.mockEditor(widthOfCells))));
    }

    private BaseExpressionGrid mockEditor(final double ... widthOfCells) {
        final GridColumn.HeaderMetaData headerMetaData = (GridColumn.HeaderMetaData)Mockito.mock(GridColumn.HeaderMetaData.class);
        final GridColumnRenderer gridColumnRenderer = (GridColumnRenderer)Mockito.mock(GridColumnRenderer.class);
        final BaseExpressionGrid gridWidget = (BaseExpressionGrid)Mockito.mock(BaseExpressionGrid.class);
        GridCellTuple parent = new GridCellTuple(0, 0, null);
        HasExpression hasExpression = (HasExpression)Mockito.mock(HasExpression.class);
        Optional<Object> expression = Optional.of(Mockito.mock(LiteralExpression.class));
        Optional<Object> hasName = Optional.of(Mockito.mock(HasName.class));
        return new BaseExpressionGrid(parent, hasExpression, expression, hasName, this.gridPanel, this.gridLayer, this.renderer, this.sessionManager, (SessionCommandManager)this.sessionCommandManager, (Event)this.editorSelectedEvent){

            protected BaseUIModelMapper makeUiModelMapper() {
                return null;
            }

            protected void initialiseUiColumns() {
                for (final double width : widthOfCells) {
                    this.model.appendColumn((GridColumn)new DMNGridColumn<Object>(headerMetaData, gridColumnRenderer, (GridWidget)gridWidget){
                        {
                            super(x0, x1, x2);
                            this.setMinimumWidth(width);
                            this.setWidth(width);
                        }
                    });
                }
            }

            protected void initialiseUiModel() {
            }

            public Optional<IsElement> getEditorControls() {
                return Optional.empty();
            }
        };
    }

    private double getColumnWidth(int rowOfCell, int columnOfCell, int columnInCell) {
        return ((GridColumn)((BaseExpressionGrid)((Optional)((ExpressionCellValue)this.gridData.getCell(rowOfCell, columnOfCell).getValue()).getValue()).get()).getModel().getColumns().get(columnInCell)).getWidth();
    }
}

