/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.expressions.types.function;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.definition.v1_1.FunctionDefinition;
import org.kie.workbench.common.dmn.api.definition.v1_1.InformationItem;
import org.kie.workbench.common.dmn.api.property.dmn.Name;
import org.kie.workbench.common.dmn.client.editors.expressions.types.function.FunctionColumnParametersHeaderMetaData;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class FunctionColumnParametersHeaderMetaDataTest {
    private FunctionDefinition.Kind kind;
    private List<InformationItem> parameters = new ArrayList<InformationItem>();
    private Supplier<FunctionDefinition.Kind> expressionLanguageSupplier;
    private Supplier<List<InformationItem>> formalParametersSupplier;
    private FunctionColumnParametersHeaderMetaData header;

    @Before
    public void setup() {
        this.expressionLanguageSupplier = () -> this.kind;
        this.formalParametersSupplier = () -> this.parameters;
        this.header = new FunctionColumnParametersHeaderMetaData(this.expressionLanguageSupplier, this.formalParametersSupplier);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testSetColumnGroup() {
        this.header.setColumnGroup("group");
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testSetTitle() {
        this.header.setTitle("title");
    }

    @Test
    public void testGetExpressionLanguageTitle() {
        this.kind = FunctionDefinition.Kind.FEEL;
        Assert.assertEquals((Object)FunctionDefinition.Kind.FEEL.code(), (Object)this.header.getExpressionLanguageTitle());
    }

    @Test
    public void testGetFormalParametersTitleOneParameter() {
        this.setupFormalParameters("p0");
        Assert.assertEquals((Object)"(p0)", (Object)this.header.getFormalParametersTitle());
    }

    @Test
    public void testGetFormalParametersTitleMultipleParameters() {
        this.setupFormalParameters("p0", "p1");
        Assert.assertEquals((Object)"(p0, p1)", (Object)this.header.getFormalParametersTitle());
    }

    @Test
    public void testGetColumnGroup() {
        Assert.assertEquals((Object)"FunctionColumnParametersHeaderMetaData$Parameters", (Object)this.header.getColumnGroup());
    }

    @Test
    public void testGetTitle() {
        this.kind = FunctionDefinition.Kind.FEEL;
        this.setupFormalParameters("p0", "p1");
        Assert.assertEquals((Object)"F : (p0, p1)", (Object)this.header.getTitle());
    }

    private void setupFormalParameters(String ... parameters) {
        Arrays.asList(parameters).forEach(p -> this.parameters.add(new InformationItem((String)p){
            final /* synthetic */ String val$p;
            {
                this.val$p = string;
                this.setName(new Name(this.val$p));
            }
        }));
    }
}

