/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.expressions.types.function;

import com.ait.lienzo.test.LienzoMockitoTestRunner;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.definition.HasExpression;
import org.kie.workbench.common.dmn.api.definition.v1_1.Decision;
import org.kie.workbench.common.dmn.api.definition.v1_1.Expression;
import org.kie.workbench.common.dmn.api.definition.v1_1.FunctionDefinition;
import org.kie.workbench.common.dmn.api.definition.v1_1.InformationItem;
import org.kie.workbench.common.dmn.api.definition.v1_1.LiteralExpression;
import org.kie.workbench.common.dmn.api.property.dmn.Name;
import org.kie.workbench.common.dmn.client.commands.expressions.types.function.AddParameterCommand;
import org.kie.workbench.common.dmn.client.commands.expressions.types.function.SetKindCommand;
import org.kie.workbench.common.dmn.client.commands.general.SetCellValueCommand;
import org.kie.workbench.common.dmn.client.editors.expressions.types.ExpressionEditorDefinition;
import org.kie.workbench.common.dmn.client.editors.expressions.types.ExpressionEditorDefinitions;
import org.kie.workbench.common.dmn.client.editors.expressions.types.ExpressionType;
import org.kie.workbench.common.dmn.client.editors.expressions.types.context.ExpressionCellValue;
import org.kie.workbench.common.dmn.client.editors.expressions.types.context.ExpressionEditorColumn;
import org.kie.workbench.common.dmn.client.editors.expressions.types.function.FunctionColumnNameHeaderMetaData;
import org.kie.workbench.common.dmn.client.editors.expressions.types.function.FunctionColumnParametersHeaderMetaData;
import org.kie.workbench.common.dmn.client.editors.expressions.types.function.FunctionEditorDefinition;
import org.kie.workbench.common.dmn.client.editors.expressions.types.function.FunctionGrid;
import org.kie.workbench.common.dmn.client.editors.expressions.types.function.FunctionGridControls;
import org.kie.workbench.common.dmn.client.events.ExpressionEditorSelectedEvent;
import org.kie.workbench.common.dmn.client.widgets.grid.BaseExpressionGrid;
import org.kie.workbench.common.dmn.client.widgets.grid.model.DMNGridData;
import org.kie.workbench.common.dmn.client.widgets.grid.model.GridCellTuple;
import org.kie.workbench.common.dmn.client.widgets.layer.DMNGridLayer;
import org.kie.workbench.common.dmn.client.widgets.panel.DMNGridPanel;
import org.kie.workbench.common.stunner.core.client.api.SessionManager;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.command.SessionCommandManager;
import org.kie.workbench.common.stunner.core.client.session.ClientSession;
import org.kie.workbench.common.stunner.core.command.Command;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.model.GridData;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridData;
import org.uberfire.ext.wires.core.grids.client.widget.dnd.GridWidgetDnDHandlersState;
import org.uberfire.ext.wires.core.grids.client.widget.grid.GridWidget;
import org.uberfire.ext.wires.core.grids.client.widget.layer.impl.GridLayerRedrawManager;
import org.uberfire.mocks.EventSourceMock;

@RunWith(value=LienzoMockitoTestRunner.class)
public class FunctionGridTest {
    @Mock
    private DMNGridPanel gridPanel;
    @Mock
    private DMNGridLayer gridLayer;
    @Mock
    private SessionManager sessionManager;
    @Mock
    private SessionCommandManager<AbstractCanvasHandler> sessionCommandManager;
    @Mock
    private ClientSession session;
    @Mock
    private AbstractCanvasHandler canvasHandler;
    @Mock
    private Supplier<ExpressionEditorDefinitions> expressionEditorDefinitionsSupplier;
    @Mock
    private Supplier<ExpressionEditorDefinitions> supplementaryEditorDefinitionsSupplier;
    @Mock
    private EventSourceMock<ExpressionEditorSelectedEvent> editorSelectedEvent;
    @Mock
    private ManagedInstance<FunctionGridControls> controlsProvider;
    @Mock
    private FunctionGridControls controls;
    @Mock
    private GridCellTuple parent;
    @Mock
    private HasExpression hasExpression;
    @Mock
    private ExpressionEditorDefinition literalExpressionEditorDefinition;
    @Mock
    private BaseExpressionGrid literalExpressionEditor;
    private LiteralExpression literalExpression = new LiteralExpression();
    @Mock
    private ExpressionEditorDefinition supplementaryLiteralExpressionEditorDefinition;
    @Mock
    private GridWidget supplementaryLiteralExpressionEditor;
    private LiteralExpression supplementaryLiteralExpression = new LiteralExpression();
    @Mock
    private GridWidgetDnDHandlersState dndHandlersState;
    @Captor
    private ArgumentCaptor<Optional<Expression>> expressionCaptor;
    @Captor
    private ArgumentCaptor<Optional<BaseExpressionGrid>> gridWidgetCaptor;
    @Captor
    private ArgumentCaptor<GridLayerRedrawManager.PrioritizedCommand> redrawCaptor;
    private Optional<FunctionDefinition> expression;
    private FunctionGrid grid;

    @Before
    public void setup() {
        FunctionEditorDefinition definition = new FunctionEditorDefinition(this.gridPanel, this.gridLayer, this.sessionManager, this.sessionCommandManager, this.expressionEditorDefinitionsSupplier, this.supplementaryEditorDefinitionsSupplier, this.editorSelectedEvent, this.controlsProvider);
        this.expression = definition.getModelClass();
        this.expression.get().getFormalParameter().add(new InformationItem(){
            {
                this.setName(new Name("p0"));
            }
        });
        ExpressionEditorDefinitions expressionEditorDefinitions = new ExpressionEditorDefinitions();
        expressionEditorDefinitions.add((Object)definition);
        expressionEditorDefinitions.add((Object)this.literalExpressionEditorDefinition);
        expressionEditorDefinitions.add((Object)this.supplementaryLiteralExpressionEditorDefinition);
        Decision decision = new Decision();
        decision.setName(new Name("name"));
        Optional<Decision> hasName = Optional.of(decision);
        ((ManagedInstance)Mockito.doReturn((Object)this.controls).when(this.controlsProvider)).get();
        ((Supplier)Mockito.doReturn((Object)expressionEditorDefinitions).when(this.expressionEditorDefinitionsSupplier)).get();
        ((Supplier)Mockito.doReturn((Object)expressionEditorDefinitions).when(this.supplementaryEditorDefinitionsSupplier)).get();
        ((ExpressionEditorDefinition)Mockito.doReturn((Object)ExpressionType.LITERAL_EXPRESSION).when((Object)this.literalExpressionEditorDefinition)).getType();
        ((ExpressionEditorDefinition)Mockito.doReturn(Optional.of(this.literalExpression)).when((Object)this.literalExpressionEditorDefinition)).getModelClass();
        ((ExpressionEditorDefinition)Mockito.doReturn(Optional.of(this.literalExpressionEditor)).when((Object)this.literalExpressionEditorDefinition)).getEditor((GridCellTuple)Matchers.any(GridCellTuple.class), (HasExpression)Matchers.any(HasExpression.class), (Optional)Matchers.any(Optional.class), (Optional)Matchers.any(Optional.class), Matchers.anyBoolean());
        ((ExpressionEditorDefinition)Mockito.doReturn(Optional.of(this.supplementaryLiteralExpression)).when((Object)this.supplementaryLiteralExpressionEditorDefinition)).getModelClass();
        ((ExpressionEditorDefinition)Mockito.doReturn(Optional.of(this.supplementaryLiteralExpressionEditor)).when((Object)this.supplementaryLiteralExpressionEditorDefinition)).getEditor((GridCellTuple)Matchers.any(GridCellTuple.class), (HasExpression)Matchers.any(HasExpression.class), (Optional)Matchers.any(Optional.class), (Optional)Matchers.any(Optional.class), Matchers.anyBoolean());
        BaseGridData uiLiteralExpressionModel = new BaseGridData();
        ((BaseExpressionGrid)Mockito.doReturn((Object)uiLiteralExpressionModel).when((Object)this.literalExpressionEditor)).getModel();
        ((SessionManager)Mockito.doReturn((Object)this.session).when((Object)this.sessionManager)).getCurrentSession();
        ((ClientSession)Mockito.doReturn((Object)this.canvasHandler).when((Object)this.session)).getCanvasHandler();
        this.grid = (FunctionGrid)Mockito.spy((Object)((FunctionGrid)definition.getEditor(this.parent, this.hasExpression, this.expression, hasName, false).get()));
    }

    @Test
    public void testInitialSetupFromDefinition() {
        GridData uiModel = this.grid.getModel();
        Assert.assertTrue((boolean)(uiModel instanceof DMNGridData));
        Assert.assertEquals((long)1L, (long)uiModel.getColumnCount());
        Assert.assertTrue((boolean)(uiModel.getColumns().get(0) instanceof ExpressionEditorColumn));
        Assert.assertEquals((long)1L, (long)uiModel.getRowCount());
        Assert.assertTrue((boolean)(uiModel.getCell(0, 0).getValue() instanceof ExpressionCellValue));
        ExpressionCellValue dcv = (ExpressionCellValue)uiModel.getCell(0, 0).getValue();
        Assert.assertEquals((Object)this.literalExpressionEditor, ((Optional)dcv.getValue()).get());
    }

    @Test
    public void testGetEditorControls() {
        this.grid.getEditorControls();
        ((FunctionGridControls)Mockito.verify((Object)this.controls)).initSelectedKind((FunctionDefinition.Kind)Matchers.eq((Object)FunctionDefinition.Kind.FEEL));
        ((FunctionGridControls)Mockito.verify((Object)this.controls)).enableKind(Matchers.eq((boolean)true));
        ((FunctionGridControls)Mockito.verify((Object)this.controls)).initSelectedExpressionType((ExpressionType)Matchers.eq((Object)ExpressionType.LITERAL_EXPRESSION));
        ((FunctionGridControls)Mockito.verify((Object)this.controls)).enableExpressionType(Matchers.eq((boolean)true));
    }

    @Test
    public void testColumnMetaData() {
        GridColumn column = (GridColumn)this.grid.getModel().getColumns().get(0);
        List header = column.getHeaderMetaData();
        Assert.assertEquals((long)2L, (long)header.size());
        Assert.assertTrue((boolean)(header.get(0) instanceof FunctionColumnNameHeaderMetaData));
        Assert.assertTrue((boolean)(header.get(1) instanceof FunctionColumnParametersHeaderMetaData));
        FunctionColumnNameHeaderMetaData md1 = (FunctionColumnNameHeaderMetaData)header.get(0);
        FunctionColumnParametersHeaderMetaData md2 = (FunctionColumnParametersHeaderMetaData)header.get(1);
        Assert.assertEquals((Object)"name", (Object)md1.getTitle());
        Assert.assertEquals((Object)"F", (Object)md2.getExpressionLanguageTitle());
        Assert.assertEquals((Object)"(p0)", (Object)md2.getFormalParametersTitle());
    }

    @Test
    public void testAddFormalParameter() {
        this.grid.addFormalParameter();
        ((SessionCommandManager)Mockito.verify(this.sessionCommandManager)).execute(Matchers.any(AbstractCanvasHandler.class), (Command)Matchers.any(AddParameterCommand.class));
    }

    @Test
    public void testSetKindFEEL() {
        this.grid.setKind(FunctionDefinition.Kind.FEEL);
        this.assertSetKind(FunctionDefinition.Kind.FEEL, (Expression)this.literalExpression, (GridWidget)this.literalExpressionEditor);
    }

    @Test
    public void testSetKindJava() {
        ((ExpressionEditorDefinition)Mockito.doReturn((Object)ExpressionType.FUNCTION_JAVA).when((Object)this.supplementaryLiteralExpressionEditorDefinition)).getType();
        this.grid.setKind(FunctionDefinition.Kind.JAVA);
        this.assertSetKind(FunctionDefinition.Kind.JAVA, (Expression)this.supplementaryLiteralExpression, this.supplementaryLiteralExpressionEditor);
    }

    @Test
    public void testSetKindPMML() {
        ((ExpressionEditorDefinition)Mockito.doReturn((Object)ExpressionType.FUNCTION_PMML).when((Object)this.supplementaryLiteralExpressionEditorDefinition)).getType();
        this.grid.setKind(FunctionDefinition.Kind.PMML);
        this.assertSetKind(FunctionDefinition.Kind.PMML, (Expression)this.supplementaryLiteralExpression, this.supplementaryLiteralExpressionEditor);
    }

    private void assertSetKind(FunctionDefinition.Kind expectedKind, Expression expectedExpression, GridWidget expectedEditor) {
        ((FunctionGrid)Mockito.verify((Object)this.grid)).doSetKind((FunctionDefinition.Kind)Matchers.eq((Object)expectedKind), (FunctionDefinition)Matchers.eq((Object)this.expression.get()), (Optional)this.expressionCaptor.capture(), (Optional)this.gridWidgetCaptor.capture());
        Assert.assertEquals((Object)expectedExpression, ((Optional)this.expressionCaptor.getValue()).get());
        Assert.assertEquals((Object)expectedEditor, ((Optional)this.gridWidgetCaptor.getValue()).get());
        ((SessionCommandManager)Mockito.verify(this.sessionCommandManager)).execute(Matchers.any(AbstractCanvasHandler.class), (Command)Matchers.any(SetKindCommand.class));
    }

    @Test
    public void testSetExpressionType() {
        this.grid.setExpressionType(ExpressionType.LITERAL_EXPRESSION);
        ((SessionCommandManager)Mockito.verify(this.sessionCommandManager)).execute(Matchers.any(AbstractCanvasHandler.class), (Command)Matchers.any(SetCellValueCommand.class));
    }

    @Test
    public void testSynchroniseViewWhenExpressionEditorChanged() {
        this.grid.synchroniseViewWhenExpressionEditorChanged(Optional.of(this.literalExpressionEditor));
        ((GridCellTuple)Mockito.verify((Object)this.parent)).onResize();
        ((DMNGridPanel)Mockito.verify((Object)this.gridPanel)).refreshScrollPosition();
        ((DMNGridPanel)Mockito.verify((Object)this.gridPanel)).updatePanelSize();
        ((DMNGridLayer)Mockito.verify((Object)this.gridLayer)).batch((GridLayerRedrawManager.PrioritizedCommand)this.redrawCaptor.capture());
        ((FunctionGrid)Mockito.verify((Object)this.grid)).getEditorControls();
        GridLayerRedrawManager.PrioritizedCommand command = (GridLayerRedrawManager.PrioritizedCommand)this.redrawCaptor.getValue();
        command.execute();
        ((DMNGridLayer)Mockito.verify((Object)this.gridLayer)).draw();
        ((DMNGridLayer)Mockito.verify((Object)this.gridLayer)).select((GridWidget)Matchers.eq((Object)this.literalExpressionEditor));
    }
}

