/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.expressions.types.function;

import java.util.Optional;
import java.util.function.Supplier;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.definition.HasExpression;
import org.kie.workbench.common.dmn.api.definition.v1_1.Context;
import org.kie.workbench.common.dmn.api.definition.v1_1.Expression;
import org.kie.workbench.common.dmn.api.definition.v1_1.FunctionDefinition;
import org.kie.workbench.common.dmn.api.definition.v1_1.LiteralExpression;
import org.kie.workbench.common.dmn.client.editors.expressions.types.ExpressionEditorDefinition;
import org.kie.workbench.common.dmn.client.editors.expressions.types.ExpressionEditorDefinitions;
import org.kie.workbench.common.dmn.client.editors.expressions.types.context.ExpressionCellValue;
import org.kie.workbench.common.dmn.client.editors.expressions.types.context.ExpressionEditorColumn;
import org.kie.workbench.common.dmn.client.editors.expressions.types.function.FunctionUIModelMapper;
import org.kie.workbench.common.dmn.client.editors.expressions.types.function.supplementary.FunctionSupplementaryGrid;
import org.kie.workbench.common.dmn.client.editors.expressions.types.literal.LiteralExpressionGrid;
import org.kie.workbench.common.dmn.client.widgets.grid.BaseExpressionGrid;
import org.kie.workbench.common.dmn.client.widgets.grid.model.DMNGridRow;
import org.kie.workbench.common.dmn.client.widgets.grid.model.GridCellTuple;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.uberfire.ext.wires.core.grids.client.model.GridCellValue;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.model.GridRow;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridData;

@RunWith(value=MockitoJUnitRunner.class)
public class FunctionUIModelMapperTest {
    @Mock
    private ExpressionEditorColumn uiExpressionEditorColumn;
    @Mock
    private Supplier<ExpressionEditorDefinitions> expressionEditorDefinitionsSupplier;
    @Mock
    private ExpressionEditorDefinition literalExpressionEditorDefinition;
    @Mock
    private LiteralExpressionGrid literalExpressionEditor;
    private LiteralExpression literalExpression = new LiteralExpression();
    @Mock
    private Supplier<ExpressionEditorDefinitions> supplementaryEditorDefinitionsSupplier;
    @Mock
    private ExpressionEditorDefinition supplementaryEditorDefinition;
    @Mock
    private FunctionSupplementaryGrid supplementaryEditor;
    private Context context = new Context();
    private BaseGridData uiModel;
    private FunctionDefinition function;
    private Supplier<Optional<GridCellValue<?>>> cellValueSupplier;
    private FunctionUIModelMapper mapper;

    @Before
    public void setup() {
        this.uiModel = new BaseGridData();
        this.uiModel.appendRow((GridRow)new DMNGridRow());
        this.uiModel.appendRow((GridRow)new DMNGridRow());
        this.uiModel.appendColumn((GridColumn)this.uiExpressionEditorColumn);
        ((ExpressionEditorColumn)Mockito.doReturn((Object)0).when((Object)this.uiExpressionEditorColumn)).getIndex();
        ExpressionEditorDefinitions expressionEditorDefinitions = new ExpressionEditorDefinitions();
        expressionEditorDefinitions.add((Object)this.literalExpressionEditorDefinition);
        ((Supplier)Mockito.doReturn((Object)expressionEditorDefinitions).when(this.expressionEditorDefinitionsSupplier)).get();
        ((ExpressionEditorDefinition)Mockito.doReturn(Optional.of(this.literalExpression)).when((Object)this.literalExpressionEditorDefinition)).getModelClass();
        ((LiteralExpressionGrid)Mockito.doReturn(Optional.of(this.literalExpression)).when((Object)this.literalExpressionEditor)).getExpression();
        ((ExpressionEditorDefinition)Mockito.doReturn(Optional.of(this.literalExpressionEditor)).when((Object)this.literalExpressionEditorDefinition)).getEditor((GridCellTuple)Matchers.any(GridCellTuple.class), (HasExpression)Matchers.any(HasExpression.class), (Optional)Matchers.any(Optional.class), (Optional)Matchers.any(Optional.class), Matchers.anyBoolean());
        ExpressionEditorDefinitions supplementaryEditorDefinitions = new ExpressionEditorDefinitions();
        supplementaryEditorDefinitions.add((Object)this.supplementaryEditorDefinition);
        ((Supplier)Mockito.doReturn((Object)supplementaryEditorDefinitions).when(this.supplementaryEditorDefinitionsSupplier)).get();
        ((ExpressionEditorDefinition)Mockito.doReturn(Optional.of(this.context)).when((Object)this.supplementaryEditorDefinition)).getModelClass();
        ((FunctionSupplementaryGrid)Mockito.doReturn(Optional.of(this.context)).when((Object)this.supplementaryEditor)).getExpression();
        ((ExpressionEditorDefinition)Mockito.doReturn(Optional.of(this.supplementaryEditor)).when((Object)this.supplementaryEditorDefinition)).getEditor((GridCellTuple)Matchers.any(GridCellTuple.class), (HasExpression)Matchers.any(HasExpression.class), (Optional)Matchers.any(Optional.class), (Optional)Matchers.any(Optional.class), Matchers.anyBoolean());
        this.function = new FunctionDefinition();
        this.mapper = new FunctionUIModelMapper(() -> this.uiModel, () -> Optional.of(this.function), this.expressionEditorDefinitionsSupplier, this.supplementaryEditorDefinitionsSupplier);
        this.cellValueSupplier = Optional::empty;
    }

    @Test
    public void testFromDMNModelExpressionKindFEEL() {
        this.function.setExpression((Expression)this.literalExpression);
        this.function.getAdditionalAttributes().put(FunctionDefinition.KIND_QNAME, FunctionDefinition.Kind.FEEL.code());
        this.mapper.fromDMNModel(0, 0);
        this.assertFromDMNModelEditor((BaseExpressionGrid)this.literalExpressionEditor);
    }

    @Test
    public void testFromDMNModelExpressionKindJava() {
        this.function.setExpression((Expression)this.context);
        this.function.getAdditionalAttributes().put(FunctionDefinition.KIND_QNAME, FunctionDefinition.Kind.JAVA.code());
        this.mapper.fromDMNModel(0, 0);
        this.assertFromDMNModelEditor((BaseExpressionGrid)this.supplementaryEditor);
    }

    @Test
    public void testFromDMNModelExpressionKindPMML() {
        this.function.setExpression((Expression)this.context);
        this.function.getAdditionalAttributes().put(FunctionDefinition.KIND_QNAME, FunctionDefinition.Kind.PMML.code());
        this.mapper.fromDMNModel(0, 0);
        this.assertFromDMNModelEditor((BaseExpressionGrid)this.supplementaryEditor);
    }

    private void assertFromDMNModelEditor(BaseExpressionGrid editor) {
        Assert.assertTrue((boolean)(this.uiModel.getCell(0, 0).getValue() instanceof ExpressionCellValue));
        ExpressionCellValue dcv = (ExpressionCellValue)this.uiModel.getCell(0, 0).getValue();
        Assert.assertEquals((Object)editor, ((Optional)dcv.getValue()).get());
    }

    @Test
    public void testToDMNModelExpressionKindFEEL() {
        this.cellValueSupplier = () -> Optional.of(new ExpressionCellValue(Optional.of(this.literalExpressionEditor)));
        this.mapper.toDMNModel(0, 0, this.cellValueSupplier);
        Assert.assertEquals((Object)this.literalExpression, (Object)this.function.getExpression());
    }

    @Test
    public void testToDMNModelExpressionKindJavaAndPMML() {
        this.cellValueSupplier = () -> Optional.of(new ExpressionCellValue(Optional.of(this.supplementaryEditor)));
        this.mapper.toDMNModel(0, 0, this.cellValueSupplier);
        Assert.assertEquals((Object)this.context, (Object)this.function.getExpression());
    }
}

