/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.expressions.types.function.supplementary;

import com.ait.lienzo.test.LienzoMockitoTestRunner;
import java.util.Optional;
import java.util.function.Supplier;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.definition.HasExpression;
import org.kie.workbench.common.dmn.api.definition.HasName;
import org.kie.workbench.common.dmn.api.definition.v1_1.Context;
import org.kie.workbench.common.dmn.api.definition.v1_1.LiteralExpression;
import org.kie.workbench.common.dmn.client.editors.expressions.types.ExpressionEditorDefinition;
import org.kie.workbench.common.dmn.client.editors.expressions.types.ExpressionEditorDefinitions;
import org.kie.workbench.common.dmn.client.editors.expressions.types.context.ExpressionCellValue;
import org.kie.workbench.common.dmn.client.editors.expressions.types.context.ExpressionEditorColumn;
import org.kie.workbench.common.dmn.client.editors.expressions.types.function.supplementary.FunctionSupplementaryGrid;
import org.kie.workbench.common.dmn.client.editors.expressions.types.function.supplementary.FunctionSupplementaryGridData;
import org.kie.workbench.common.dmn.client.editors.expressions.types.function.supplementary.NameColumn;
import org.kie.workbench.common.dmn.client.events.ExpressionEditorSelectedEvent;
import org.kie.workbench.common.dmn.client.widgets.grid.BaseExpressionGrid;
import org.kie.workbench.common.dmn.client.widgets.grid.model.GridCellTuple;
import org.kie.workbench.common.dmn.client.widgets.layer.DMNGridLayer;
import org.kie.workbench.common.dmn.client.widgets.panel.DMNGridPanel;
import org.kie.workbench.common.stunner.core.client.api.SessionManager;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.command.SessionCommandManager;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.uberfire.ext.wires.core.grids.client.model.GridData;
import org.uberfire.ext.wires.core.grids.client.widget.grid.columns.RowNumberColumn;
import org.uberfire.mocks.EventSourceMock;

@RunWith(value=LienzoMockitoTestRunner.class)
public abstract class BaseFunctionSupplementaryGridTest<D extends ExpressionEditorDefinition<Context>> {
    @Mock
    protected DMNGridPanel gridPanel;
    @Mock
    protected DMNGridLayer gridLayer;
    @Mock
    protected SessionManager sessionManager;
    @Mock
    protected SessionCommandManager<AbstractCanvasHandler> sessionCommandManager;
    @Mock
    protected Supplier<ExpressionEditorDefinitions> expressionEditorDefinitionsSupplier;
    @Mock
    protected EventSourceMock<ExpressionEditorSelectedEvent> editorSelectedEvent;
    @Mock
    private GridCellTuple parent;
    @Mock
    private HasExpression hasExpression;
    @Mock
    private ExpressionEditorDefinition literalExpressionEditorDefinition;
    @Mock
    private BaseExpressionGrid literalExpressionEditor;
    private LiteralExpression literalExpression = new LiteralExpression();
    private Optional<HasName> hasName = Optional.empty();
    private FunctionSupplementaryGrid grid;

    @Before
    public void setup() {
        D definition = this.getEditorDefinition();
        Optional expression = definition.getModelClass();
        ExpressionEditorDefinitions expressionEditorDefinitions = new ExpressionEditorDefinitions();
        expressionEditorDefinitions.add(definition);
        expressionEditorDefinitions.add((Object)this.literalExpressionEditorDefinition);
        ((Supplier)Mockito.doReturn((Object)expressionEditorDefinitions).when(this.expressionEditorDefinitionsSupplier)).get();
        ((ExpressionEditorDefinition)Mockito.doReturn(Optional.of(this.literalExpression)).when((Object)this.literalExpressionEditorDefinition)).getModelClass();
        ((ExpressionEditorDefinition)Mockito.doReturn(Optional.of(this.literalExpressionEditor)).when((Object)this.literalExpressionEditorDefinition)).getEditor((GridCellTuple)Matchers.any(GridCellTuple.class), (HasExpression)Matchers.any(HasExpression.class), (Optional)Matchers.any(Optional.class), (Optional)Matchers.any(Optional.class), Matchers.anyBoolean());
        this.grid = (FunctionSupplementaryGrid)definition.getEditor(this.parent, this.hasExpression, expression, this.hasName, false).get();
    }

    protected abstract D getEditorDefinition();

    protected abstract String[] getExpectedNames();

    @Test
    public void testInitialSetupFromDefinition() {
        GridData uiModel = this.grid.getModel();
        Assert.assertTrue((boolean)(uiModel instanceof FunctionSupplementaryGridData));
        Assert.assertEquals((long)3L, (long)uiModel.getColumnCount());
        Assert.assertTrue((boolean)(uiModel.getColumns().get(0) instanceof RowNumberColumn));
        Assert.assertTrue((boolean)(uiModel.getColumns().get(1) instanceof NameColumn));
        Assert.assertTrue((boolean)(uiModel.getColumns().get(2) instanceof ExpressionEditorColumn));
        Assert.assertEquals((long)2L, (long)uiModel.getRowCount());
        String[] expectedNames = this.getExpectedNames();
        for (int i = 0; i < uiModel.getRowCount(); ++i) {
            Assert.assertEquals((Object)(i + 1), (Object)uiModel.getCell(i, 0).getValue().getValue());
            Assert.assertEquals((Object)expectedNames[i], (Object)uiModel.getCell(i, 1).getValue().getValue());
            Assert.assertTrue((boolean)(uiModel.getCell(i, 2).getValue() instanceof ExpressionCellValue));
            ExpressionCellValue dcv = (ExpressionCellValue)uiModel.getCell(i, 2).getValue();
            Assert.assertEquals((Object)this.literalExpressionEditor, ((Optional)dcv.getValue()).get());
        }
    }
}

