/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.expressions.types.function.supplementary.pmml;

import com.ait.lienzo.test.LienzoMockitoTestRunner;
import java.util.Optional;
import java.util.function.Supplier;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.definition.HasExpression;
import org.kie.workbench.common.dmn.api.definition.HasName;
import org.kie.workbench.common.dmn.api.definition.v1_1.Context;
import org.kie.workbench.common.dmn.api.definition.v1_1.ContextEntry;
import org.kie.workbench.common.dmn.api.definition.v1_1.LiteralExpression;
import org.kie.workbench.common.dmn.client.editors.expressions.types.ExpressionEditorDefinitions;
import org.kie.workbench.common.dmn.client.editors.expressions.types.ExpressionType;
import org.kie.workbench.common.dmn.client.editors.expressions.types.function.supplementary.FunctionSupplementaryGrid;
import org.kie.workbench.common.dmn.client.editors.expressions.types.function.supplementary.pmml.PMMLFunctionEditorDefinition;
import org.kie.workbench.common.dmn.client.events.ExpressionEditorSelectedEvent;
import org.kie.workbench.common.dmn.client.widgets.grid.model.GridCellTuple;
import org.kie.workbench.common.dmn.client.widgets.layer.DMNGridLayer;
import org.kie.workbench.common.dmn.client.widgets.panel.DMNGridPanel;
import org.kie.workbench.common.stunner.core.client.api.SessionManager;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.command.SessionCommandManager;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.uberfire.ext.wires.core.grids.client.widget.grid.GridWidget;
import org.uberfire.mocks.EventSourceMock;

@RunWith(value=LienzoMockitoTestRunner.class)
public class PMMLFunctionEditorDefinitionTest {
    @Mock
    private DMNGridPanel gridPanel;
    @Mock
    private DMNGridLayer gridLayer;
    @Mock
    private SessionManager sessionManager;
    @Mock
    private SessionCommandManager<AbstractCanvasHandler> sessionCommandManager;
    @Mock
    private Supplier<ExpressionEditorDefinitions> expressionEditorDefinitionsSupplier;
    @Mock
    private EventSourceMock<ExpressionEditorSelectedEvent> editorSelectedEvent;
    @Mock
    private GridCellTuple parent;
    @Mock
    private HasExpression hasExpression;
    private Optional<HasName> hasName = Optional.empty();
    private PMMLFunctionEditorDefinition definition;

    @Before
    public void setup() {
        this.definition = new PMMLFunctionEditorDefinition(this.gridPanel, this.gridLayer, this.sessionManager, this.sessionCommandManager, this.expressionEditorDefinitionsSupplier, this.editorSelectedEvent);
        ExpressionEditorDefinitions expressionEditorDefinitions = new ExpressionEditorDefinitions();
        expressionEditorDefinitions.add((Object)this.definition);
        ((Supplier)Mockito.doReturn((Object)expressionEditorDefinitions).when(this.expressionEditorDefinitionsSupplier)).get();
    }

    @Test
    public void testType() {
        Assert.assertEquals((Object)ExpressionType.FUNCTION_PMML, (Object)this.definition.getType());
    }

    @Test
    public void testName() {
        Assert.assertEquals((Object)Context.class.getSimpleName(), (Object)this.definition.getName());
    }

    @Test
    public void testModelDefinition() {
        Optional oModel = this.definition.getModelClass();
        Assert.assertTrue((boolean)oModel.isPresent());
        Context model = (Context)oModel.get();
        Assert.assertEquals((long)2L, (long)model.getContextEntry().size());
        Assert.assertEquals((Object)"document", (Object)((ContextEntry)model.getContextEntry().get(0)).getVariable().getName().getValue());
        Assert.assertTrue((boolean)(((ContextEntry)model.getContextEntry().get(0)).getExpression() instanceof LiteralExpression));
        Assert.assertEquals((Object)"model", (Object)((ContextEntry)model.getContextEntry().get(1)).getVariable().getName().getValue());
        Assert.assertTrue((boolean)(((ContextEntry)model.getContextEntry().get(1)).getExpression() instanceof LiteralExpression));
    }

    @Test
    public void testEditor() {
        Optional expression = this.definition.getModelClass();
        Optional oEditor = this.definition.getEditor(this.parent, this.hasExpression, expression, this.hasName, false);
        Assert.assertTrue((boolean)oEditor.isPresent());
        GridWidget editor = (GridWidget)oEditor.get();
        Assert.assertTrue((boolean)(editor instanceof FunctionSupplementaryGrid));
    }
}

