/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.expressions.types.invocation;

import com.ait.lienzo.test.LienzoMockitoTestRunner;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.definition.HasExpression;
import org.kie.workbench.common.dmn.api.definition.v1_1.Decision;
import org.kie.workbench.common.dmn.api.definition.v1_1.LiteralExpression;
import org.kie.workbench.common.dmn.api.property.dmn.Name;
import org.kie.workbench.common.dmn.client.commands.expressions.types.invocation.AddParameterBindingCommand;
import org.kie.workbench.common.dmn.client.editors.expressions.types.ExpressionEditorDefinition;
import org.kie.workbench.common.dmn.client.editors.expressions.types.ExpressionEditorDefinitions;
import org.kie.workbench.common.dmn.client.editors.expressions.types.context.ExpressionEditorColumn;
import org.kie.workbench.common.dmn.client.editors.expressions.types.context.NameColumnHeaderMetaData;
import org.kie.workbench.common.dmn.client.editors.expressions.types.invocation.InvocationColumnExpressionHeaderMetaData;
import org.kie.workbench.common.dmn.client.editors.expressions.types.invocation.InvocationEditorDefinition;
import org.kie.workbench.common.dmn.client.editors.expressions.types.invocation.InvocationGrid;
import org.kie.workbench.common.dmn.client.editors.expressions.types.invocation.InvocationGridControls;
import org.kie.workbench.common.dmn.client.editors.expressions.types.invocation.InvocationGridData;
import org.kie.workbench.common.dmn.client.editors.expressions.types.invocation.NameColumn;
import org.kie.workbench.common.dmn.client.events.ExpressionEditorSelectedEvent;
import org.kie.workbench.common.dmn.client.widgets.grid.BaseExpressionGrid;
import org.kie.workbench.common.dmn.client.widgets.grid.model.GridCellTuple;
import org.kie.workbench.common.dmn.client.widgets.layer.DMNGridLayer;
import org.kie.workbench.common.dmn.client.widgets.panel.DMNGridPanel;
import org.kie.workbench.common.stunner.core.client.api.SessionManager;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.command.SessionCommandManager;
import org.kie.workbench.common.stunner.core.client.session.ClientSession;
import org.kie.workbench.common.stunner.core.command.Command;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommandExecutionContext;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.model.GridData;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseHeaderMetaData;
import org.uberfire.ext.wires.core.grids.client.widget.dnd.GridWidgetDnDHandlersState;
import org.uberfire.ext.wires.core.grids.client.widget.grid.columns.RowNumberColumn;
import org.uberfire.mocks.EventSourceMock;

@RunWith(value=LienzoMockitoTestRunner.class)
public class InvocationGridTest {
    @Mock
    private DMNGridPanel gridPanel;
    @Mock
    private DMNGridLayer gridLayer;
    @Mock
    private SessionManager sessionManager;
    @Mock
    private ClientSession session;
    @Mock
    private AbstractCanvasHandler canvasContext;
    @Mock
    private GraphCommandExecutionContext graphContext;
    @Mock
    private SessionCommandManager<AbstractCanvasHandler> sessionCommandManager;
    @Mock
    private Supplier<ExpressionEditorDefinitions> expressionEditorDefinitionsSupplier;
    @Mock
    private EventSourceMock<ExpressionEditorSelectedEvent> editorSelectedEvent;
    @Mock
    private ManagedInstance<InvocationGridControls> controlsProvider;
    @Mock
    private InvocationGridControls controls;
    @Mock
    private GridCellTuple parent;
    @Mock
    private HasExpression hasExpression;
    @Mock
    private ExpressionEditorDefinition literalExpressionEditorDefinition;
    @Mock
    private BaseExpressionGrid literalExpressionEditor;
    @Mock
    private GridWidgetDnDHandlersState dndHandlersState;
    @Captor
    private ArgumentCaptor<AddParameterBindingCommand> addParameterBindingCommandCaptor;
    private LiteralExpression literalExpression = new LiteralExpression();
    private InvocationGrid grid;

    @Before
    public void setup() {
        InvocationEditorDefinition definition = new InvocationEditorDefinition(this.gridPanel, this.gridLayer, this.sessionManager, this.sessionCommandManager, this.expressionEditorDefinitionsSupplier, this.editorSelectedEvent, this.controlsProvider);
        Optional expression = definition.getModelClass();
        expression.ifPresent(invocation -> ((LiteralExpression)invocation.getExpression()).setText("invocation-expression"));
        ExpressionEditorDefinitions expressionEditorDefinitions = new ExpressionEditorDefinitions();
        expressionEditorDefinitions.add((Object)definition);
        expressionEditorDefinitions.add((Object)this.literalExpressionEditorDefinition);
        ((ManagedInstance)Mockito.doReturn((Object)this.controls).when(this.controlsProvider)).get();
        ((Supplier)Mockito.doReturn((Object)expressionEditorDefinitions).when(this.expressionEditorDefinitionsSupplier)).get();
        ((ExpressionEditorDefinition)Mockito.doReturn(Optional.of(this.literalExpression)).when((Object)this.literalExpressionEditorDefinition)).getModelClass();
        ((ExpressionEditorDefinition)Mockito.doReturn(Optional.of(this.literalExpressionEditor)).when((Object)this.literalExpressionEditorDefinition)).getEditor((GridCellTuple)Matchers.any(GridCellTuple.class), (HasExpression)Matchers.any(HasExpression.class), (Optional)Matchers.any(Optional.class), (Optional)Matchers.any(Optional.class), Matchers.anyBoolean());
        ((SessionManager)Mockito.doReturn((Object)this.session).when((Object)this.sessionManager)).getCurrentSession();
        ((ClientSession)Mockito.doReturn((Object)this.canvasContext).when((Object)this.session)).getCanvasHandler();
        ((AbstractCanvasHandler)Mockito.doReturn((Object)this.graphContext).when((Object)this.canvasContext)).getGraphExecutionContext();
        Decision decision = new Decision();
        decision.setName(new Name("name"));
        Optional<Decision> hasName = Optional.of(decision);
        this.grid = (InvocationGrid)definition.getEditor(this.parent, this.hasExpression, expression, hasName, false).get();
    }

    @Test
    public void testInitialSetupFromDefinition() {
        GridData uiModel = this.grid.getModel();
        Assert.assertTrue((boolean)(uiModel instanceof InvocationGridData));
        Assert.assertEquals((long)3L, (long)uiModel.getColumnCount());
        Assert.assertTrue((boolean)(uiModel.getColumns().get(0) instanceof RowNumberColumn));
        Assert.assertTrue((boolean)(uiModel.getColumns().get(1) instanceof NameColumn));
        Assert.assertTrue((boolean)(uiModel.getColumns().get(2) instanceof ExpressionEditorColumn));
        Assert.assertEquals((long)1L, (long)uiModel.getRowCount());
        Assert.assertEquals((Object)1, (Object)uiModel.getCell(0, 0).getValue().getValue());
        Assert.assertEquals((Object)"p0", (Object)uiModel.getCell(0, 1).getValue().getValue());
        Assert.assertNull((Object)uiModel.getCell(0, 2));
    }

    @Test
    public void testNameColumnMetaData() {
        GridColumn column = (GridColumn)this.grid.getModel().getColumns().get(1);
        List header = column.getHeaderMetaData();
        Assert.assertEquals((long)2L, (long)header.size());
        Assert.assertTrue((boolean)(header.get(0) instanceof NameColumnHeaderMetaData));
        Assert.assertTrue((boolean)(header.get(1) instanceof InvocationColumnExpressionHeaderMetaData));
        NameColumnHeaderMetaData md1 = (NameColumnHeaderMetaData)header.get(0);
        InvocationColumnExpressionHeaderMetaData md2 = (InvocationColumnExpressionHeaderMetaData)header.get(1);
        Assert.assertEquals((Object)"name", (Object)md1.getTitle());
        Assert.assertEquals((Object)"invocation-expression", (Object)md2.getTitle());
    }

    @Test
    public void testExpressionColumnMetaData() {
        GridColumn column = (GridColumn)this.grid.getModel().getColumns().get(2);
        List header = column.getHeaderMetaData();
        Assert.assertEquals((long)2L, (long)header.size());
        Assert.assertTrue((boolean)(header.get(0) instanceof BaseHeaderMetaData));
        Assert.assertTrue((boolean)(header.get(1) instanceof InvocationColumnExpressionHeaderMetaData));
        BaseHeaderMetaData md1 = (BaseHeaderMetaData)header.get(0);
        InvocationColumnExpressionHeaderMetaData md2 = (InvocationColumnExpressionHeaderMetaData)header.get(1);
        Assert.assertEquals((Object)"", (Object)md1.getTitle());
        Assert.assertEquals((Object)"invocation-expression", (Object)md2.getTitle());
    }

    @Test
    public void testAddParameterBinding() {
        this.grid.addParameterBinding();
        ((SessionCommandManager)Mockito.verify(this.sessionCommandManager)).execute(Matchers.eq((Object)this.canvasContext), (Command)this.addParameterBindingCommandCaptor.capture());
        AddParameterBindingCommand addParameterBindingCommand = (AddParameterBindingCommand)this.addParameterBindingCommandCaptor.getValue();
        addParameterBindingCommand.execute(this.canvasContext);
        ((DMNGridPanel)Mockito.verify((Object)this.gridPanel)).refreshScrollPosition();
        ((DMNGridPanel)Mockito.verify((Object)this.gridPanel)).updatePanelSize();
        ((DMNGridLayer)Mockito.verify((Object)this.gridLayer)).batch();
    }
}

