/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.expressions.types.invocation;

import java.util.Optional;
import java.util.function.Supplier;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.definition.HasExpression;
import org.kie.workbench.common.dmn.api.definition.v1_1.Binding;
import org.kie.workbench.common.dmn.api.definition.v1_1.Expression;
import org.kie.workbench.common.dmn.api.definition.v1_1.InformationItem;
import org.kie.workbench.common.dmn.api.definition.v1_1.Invocation;
import org.kie.workbench.common.dmn.api.definition.v1_1.LiteralExpression;
import org.kie.workbench.common.dmn.api.property.dmn.Name;
import org.kie.workbench.common.dmn.client.editors.expressions.types.ExpressionEditorDefinition;
import org.kie.workbench.common.dmn.client.editors.expressions.types.ExpressionEditorDefinitions;
import org.kie.workbench.common.dmn.client.editors.expressions.types.context.ExpressionCellValue;
import org.kie.workbench.common.dmn.client.editors.expressions.types.context.ExpressionEditorColumn;
import org.kie.workbench.common.dmn.client.editors.expressions.types.invocation.InvocationUIModelMapper;
import org.kie.workbench.common.dmn.client.editors.expressions.types.invocation.NameColumn;
import org.kie.workbench.common.dmn.client.editors.expressions.types.literal.LiteralExpressionGrid;
import org.kie.workbench.common.dmn.client.widgets.grid.model.DMNGridRow;
import org.kie.workbench.common.dmn.client.widgets.grid.model.GridCellTuple;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.uberfire.ext.wires.core.grids.client.model.GridCellValue;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.model.GridRow;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridCellValue;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridData;
import org.uberfire.ext.wires.core.grids.client.widget.grid.columns.RowNumberColumn;

@RunWith(value=MockitoJUnitRunner.class)
public class InvocationUIModelMapperTest {
    @Mock
    private RowNumberColumn uiRowNumberColumn;
    @Mock
    private NameColumn uiNameColumn;
    @Mock
    private ExpressionEditorColumn uiExpressionEditorColumn;
    @Mock
    private Supplier<ExpressionEditorDefinitions> expressionEditorDefinitionsSupplier;
    @Mock
    private ExpressionEditorDefinition literalExpressionEditorDefinition;
    @Mock
    private LiteralExpressionGrid literalExpressionEditor;
    private LiteralExpression literalExpression = new LiteralExpression();
    private BaseGridData uiModel;
    private Invocation invocation;
    private Supplier<Optional<GridCellValue<?>>> cellValueSupplier;
    private InvocationUIModelMapper mapper;

    @Before
    public void setup() {
        this.uiModel = new BaseGridData();
        this.uiModel.appendRow((GridRow)new DMNGridRow());
        this.uiModel.appendRow((GridRow)new DMNGridRow());
        this.uiModel.appendColumn((GridColumn)this.uiRowNumberColumn);
        this.uiModel.appendColumn((GridColumn)this.uiNameColumn);
        this.uiModel.appendColumn((GridColumn)this.uiExpressionEditorColumn);
        ((RowNumberColumn)Mockito.doReturn((Object)0).when((Object)this.uiRowNumberColumn)).getIndex();
        ((NameColumn)Mockito.doReturn((Object)1).when((Object)this.uiNameColumn)).getIndex();
        ((ExpressionEditorColumn)Mockito.doReturn((Object)2).when((Object)this.uiExpressionEditorColumn)).getIndex();
        ExpressionEditorDefinitions expressionEditorDefinitions = new ExpressionEditorDefinitions();
        expressionEditorDefinitions.add((Object)this.literalExpressionEditorDefinition);
        ((Supplier)Mockito.doReturn((Object)expressionEditorDefinitions).when(this.expressionEditorDefinitionsSupplier)).get();
        ((ExpressionEditorDefinition)Mockito.doReturn(Optional.of(this.literalExpression)).when((Object)this.literalExpressionEditorDefinition)).getModelClass();
        ((LiteralExpressionGrid)Mockito.doReturn(Optional.of(this.literalExpression)).when((Object)this.literalExpressionEditor)).getExpression();
        ((ExpressionEditorDefinition)Mockito.doReturn(Optional.of(this.literalExpressionEditor)).when((Object)this.literalExpressionEditorDefinition)).getEditor((GridCellTuple)Matchers.any(GridCellTuple.class), (HasExpression)Matchers.any(HasExpression.class), (Optional)Matchers.any(Optional.class), (Optional)Matchers.any(Optional.class), Matchers.anyBoolean());
        LiteralExpression invocationExpression = new LiteralExpression();
        invocationExpression.setText("invocation-expression");
        LiteralExpression bindingExpression = new LiteralExpression();
        bindingExpression.setText("binding-expression");
        Binding binding = new Binding();
        InformationItem parameter = new InformationItem();
        parameter.setName(new Name("p0"));
        binding.setParameter(parameter);
        binding.setExpression((Expression)bindingExpression);
        this.invocation = new Invocation();
        this.invocation.setExpression((Expression)invocationExpression);
        this.invocation.getBinding().add(binding);
        this.mapper = new InvocationUIModelMapper(() -> this.uiModel, () -> Optional.of(this.invocation), this.expressionEditorDefinitionsSupplier);
        this.cellValueSupplier = Optional::empty;
    }

    @Test
    public void testFromDMNModelRowNumber() {
        this.mapper.fromDMNModel(0, 0);
        Assert.assertEquals((Object)1, (Object)this.uiModel.getCell(0, 0).getValue().getValue());
    }

    @Test
    public void testFromDMNModelBindingParameter() {
        this.mapper.fromDMNModel(0, 1);
        Assert.assertEquals((Object)"p0", (Object)this.uiModel.getCell(0, 1).getValue().getValue());
    }

    @Test
    public void testFromDMNModelBindingExpression() {
        this.mapper.fromDMNModel(0, 2);
        Assert.assertNotNull((Object)this.uiModel.getCell(0, 2));
        Assert.assertTrue((boolean)(this.uiModel.getCell(0, 2).getValue() instanceof ExpressionCellValue));
        ExpressionCellValue dcv = (ExpressionCellValue)this.uiModel.getCell(0, 2).getValue();
        Assert.assertEquals((Object)this.literalExpressionEditor, ((Optional)dcv.getValue()).get());
    }

    @Test
    public void testToDMNModelBindingParameter() {
        this.cellValueSupplier = () -> Optional.of(new BaseGridCellValue((Object)"updated"));
        this.mapper.toDMNModel(0, 1, this.cellValueSupplier);
        Assert.assertEquals((Object)"updated", (Object)((Binding)this.invocation.getBinding().get(0)).getParameter().getName().getValue());
    }

    @Test
    public void testToDMNModelBindingExpression() {
        this.cellValueSupplier = () -> Optional.of(new ExpressionCellValue(Optional.of(this.literalExpressionEditor)));
        this.mapper.toDMNModel(0, 2, this.cellValueSupplier);
        Assert.assertEquals((Object)this.literalExpression, (Object)((Binding)this.invocation.getBinding().get(0)).getExpression());
    }
}

