/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.expressions.types.literal;

import java.util.Optional;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.definition.v1_1.LiteralExpression;
import org.kie.workbench.common.dmn.client.editors.expressions.types.literal.LiteralExpressionColumn;
import org.kie.workbench.common.dmn.client.editors.expressions.types.literal.LiteralExpressionGrid;
import org.kie.workbench.common.dmn.client.editors.expressions.types.literal.LiteralExpressionUIModelMapper;
import org.kie.workbench.common.dmn.client.widgets.grid.model.DMNGridRow;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.model.GridRow;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridCellValue;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridData;

@RunWith(value=MockitoJUnitRunner.class)
public class LiteralExpressionUIModelMapperTest {
    @Mock
    private LiteralExpressionColumn uiLiteralExpressionColumn;
    @Mock
    private LiteralExpressionGrid literalExpressionEditor;
    private BaseGridData uiModel;
    private LiteralExpression literalExpression;
    private LiteralExpressionUIModelMapper mapper;

    @Before
    public void setup() {
        this.uiModel = new BaseGridData();
        this.uiModel.appendRow((GridRow)new DMNGridRow());
        this.uiModel.appendColumn((GridColumn)this.uiLiteralExpressionColumn);
        ((LiteralExpressionColumn)Mockito.doReturn((Object)0).when((Object)this.uiLiteralExpressionColumn)).getIndex();
        this.literalExpression = new LiteralExpression();
        this.mapper = new LiteralExpressionUIModelMapper(() -> this.uiModel, () -> Optional.of(this.literalExpression));
    }

    @Test
    public void testFromDmn_Empty() throws Exception {
        this.mapper.fromDMNModel(0, 0);
        Assert.assertEquals((Object)"", (Object)((BaseGridCellValue)this.uiModel.getCell(0, 0).getValue()).getValue());
    }

    @Test
    public void testFromDmn_MultiByte() throws Exception {
        this.literalExpression.setText("\u5b66\u6821");
        this.mapper.fromDMNModel(0, 0);
        Assert.assertEquals((Object)"\u5b66\u6821", (Object)((BaseGridCellValue)this.uiModel.getCell(0, 0).getValue()).getValue());
    }

    @Test
    public void testToDmn_Empty() throws Exception {
        this.mapper.toDMNModel(0, 0, () -> Optional.of(new BaseGridCellValue((Object)"")));
        Assert.assertEquals((Object)"", (Object)this.literalExpression.getText());
    }

    @Test
    public void testToDmn_MultiByte() throws Exception {
        this.mapper.toDMNModel(0, 0, () -> Optional.of(new BaseGridCellValue((Object)"\u5b66\u6821")));
        Assert.assertEquals((Object)"\u5b66\u6821", (Object)this.literalExpression.getText());
    }
}

