/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.expressions.types.relation;

import com.ait.lienzo.test.LienzoMockitoTestRunner;
import java.util.Optional;
import org.gwtbootstrap3.client.ui.TextArea;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.client.editors.expressions.mocks.MockHasDOMElementResourcesHeaderMetaData;
import org.kie.workbench.common.dmn.client.editors.expressions.types.context.ExpressionCellValue;
import org.kie.workbench.common.dmn.client.editors.expressions.types.context.ExpressionEditorColumn;
import org.kie.workbench.common.dmn.client.editors.expressions.types.relation.RelationColumn;
import org.kie.workbench.common.dmn.client.editors.expressions.types.relation.RelationGrid;
import org.kie.workbench.common.dmn.client.widgets.grid.BaseExpressionGrid;
import org.kie.workbench.common.dmn.client.widgets.grid.columns.factory.TextAreaSingletonDOMElementFactory;
import org.kie.workbench.common.dmn.client.widgets.grid.columns.factory.dom.TextAreaDOMElement;
import org.kie.workbench.common.dmn.client.widgets.grid.model.GridCellTuple;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.uberfire.client.callbacks.Callback;
import org.uberfire.ext.wires.core.grids.client.model.GridCell;
import org.uberfire.ext.wires.core.grids.client.model.GridCellValue;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.model.GridData;
import org.uberfire.ext.wires.core.grids.client.model.GridRow;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridCell;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridCellValue;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridData;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridRow;
import org.uberfire.ext.wires.core.grids.client.widget.context.GridBodyCellRenderContext;

@RunWith(value=LienzoMockitoTestRunner.class)
public class RelationColumnTest {
    @Mock
    private GridColumn.HeaderMetaData headerMetaData;
    @Mock
    private TextAreaSingletonDOMElementFactory factory;
    @Mock
    private RelationGrid gridWidget;
    @Mock
    private GridBodyCellRenderContext context;
    @Mock
    private Callback callback;
    @Mock
    private TextArea textArea;
    @Mock
    private TextAreaDOMElement textAreaDOMElement;
    @Mock
    private BaseExpressionGrid peerExpressionEditor;
    @Captor
    private ArgumentCaptor<Callback<TextAreaDOMElement>> textAreaDOMElementCallback;
    private GridCellTuple parent;
    private GridData parentUiModel;
    private RelationColumn relationColumn;

    @Before
    public void setUp() throws Exception {
        this.relationColumn = new RelationColumn(this.headerMetaData, this.factory, this.gridWidget);
        this.parentUiModel = new BaseGridData();
        this.parentUiModel.appendRow((GridRow)new BaseGridRow());
        this.parentUiModel.appendRow((GridRow)new BaseGridRow());
        this.parentUiModel.appendColumn((GridColumn)Mockito.mock(ExpressionEditorColumn.class));
        this.parent = new GridCellTuple(0, 0, this.parentUiModel);
        ((TextAreaDOMElement)Mockito.doReturn((Object)this.textArea).when((Object)this.textAreaDOMElement)).getWidget();
        ((RelationGrid)Mockito.doReturn((Object)this.parent).when((Object)this.gridWidget)).getParentInformation();
        ((RelationGrid)Mockito.doReturn((Object)100.0).when((Object)this.gridWidget)).getWidth();
    }

    @Test
    public void testEditNullCell() throws Exception {
        this.relationColumn.edit(null, this.context, this.callback);
        ((TextAreaSingletonDOMElementFactory)Mockito.verify((Object)this.factory)).attachDomElement((GridBodyCellRenderContext)Matchers.eq((Object)this.context), (Callback)this.textAreaDOMElementCallback.capture(), (Callback)Matchers.any(Callback.class));
        ((Callback)this.textAreaDOMElementCallback.getValue()).callback((Object)this.textAreaDOMElement);
        ((TextArea)Mockito.verify((Object)this.textArea)).setValue((Object)"");
    }

    @Test
    public void testEditEmptyCell() throws Exception {
        this.relationColumn.edit((GridCell)new BaseGridCell(null), this.context, this.callback);
        ((TextAreaSingletonDOMElementFactory)Mockito.verify((Object)this.factory)).attachDomElement((GridBodyCellRenderContext)Matchers.eq((Object)this.context), (Callback)this.textAreaDOMElementCallback.capture(), (Callback)Matchers.any(Callback.class));
        ((Callback)this.textAreaDOMElementCallback.getValue()).callback((Object)this.textAreaDOMElement);
        ((TextArea)Mockito.verify((Object)this.textArea)).setValue((Object)"");
    }

    @Test
    public void testEditCell() throws Exception {
        String cellValue = "abc";
        this.relationColumn.edit((GridCell)new BaseGridCell((GridCellValue)new BaseGridCellValue((Object)"abc")), this.context, this.callback);
        ((TextAreaSingletonDOMElementFactory)Mockito.verify((Object)this.factory)).attachDomElement((GridBodyCellRenderContext)Matchers.eq((Object)this.context), (Callback)this.textAreaDOMElementCallback.capture(), (Callback)Matchers.any(Callback.class));
        ((Callback)this.textAreaDOMElementCallback.getValue()).callback((Object)this.textAreaDOMElement);
        ((TextArea)Mockito.verify((Object)this.textArea)).setValue((Object)"abc");
    }

    @Test
    public void testGetMinimumWidthWithNoPeers() {
        Assert.assertEquals((double)100.0, (double)this.relationColumn.getMinimumWidth(), (double)0.0);
    }

    @Test
    public void testGetMinimumWidthWithPeerNarrowerThanThisGrid() {
        double PEER_WIDTH = 50.0;
        double RELATION_GRID_WIDTH = 100.0;
        this.assertMinimumWidth(Optional.of(this.peerExpressionEditor), 50.0, 100.0, 100.0);
    }

    @Test
    public void testGetMinimumWidthWithPeerWiderThanThisGrid() {
        double PEER_WIDTH = 150.0;
        double RELATION_GRID_WIDTH = 100.0;
        this.assertMinimumWidth(Optional.of(this.peerExpressionEditor), 150.0, 100.0, 150.0);
    }

    @Test
    public void testGetMinimumWidthWithPeerNarrowerThanThisGridThatIsWiderThanThisColumn() {
        double PEER_WIDTH = 200.0;
        double RELATION_GRID_WIDTH = 150.0;
        this.assertMinimumWidth(Optional.of(this.peerExpressionEditor), 200.0, 150.0, 150.0);
    }

    @Test
    public void testGetMinimumWidthWithPeerWiderThanThisGridThatIsWiderThanThisColumn() {
        double PEER_WIDTH = 150.0;
        double RELATION_GRID_WIDTH = 100.0;
        this.assertMinimumWidth(Optional.of(this.peerExpressionEditor), 150.0, 100.0, 150.0);
    }

    @Test
    public void testHeaderDOMElementsAreDestroyed() {
        MockHasDOMElementResourcesHeaderMetaData mockHeaderMetaData = (MockHasDOMElementResourcesHeaderMetaData)Mockito.mock(MockHasDOMElementResourcesHeaderMetaData.class);
        this.relationColumn.getHeaderMetaData().add(mockHeaderMetaData);
        this.relationColumn.destroyResources();
        ((MockHasDOMElementResourcesHeaderMetaData)Mockito.verify((Object)mockHeaderMetaData)).destroyResources();
    }

    private void assertMinimumWidth(Optional<BaseExpressionGrid> peer, double peerWidth, double relationGridWidth, double expectedMinimumWidth) {
        ((BaseExpressionGrid)Mockito.doReturn((Object)peerWidth).when((Object)this.peerExpressionEditor)).getMinimumWidth();
        ((RelationGrid)Mockito.doReturn((Object)relationGridWidth).when((Object)this.gridWidget)).getWidth();
        this.parentUiModel.setCell(1, 0, (GridCellValue)new ExpressionCellValue(peer));
        Assert.assertEquals((double)expectedMinimumWidth, (double)this.relationColumn.getMinimumWidth(), (double)0.0);
    }
}

