/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.expressions.types.relation;

import com.ait.lienzo.test.LienzoMockitoTestRunner;
import java.util.Collections;
import java.util.Optional;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.definition.v1_1.Relation;
import org.kie.workbench.common.dmn.client.commands.expressions.types.context.MoveRowsCommand;
import org.kie.workbench.common.dmn.client.commands.expressions.types.relation.MoveColumnsCommand;
import org.kie.workbench.common.dmn.client.editors.expressions.types.relation.RelationGridData;
import org.kie.workbench.common.dmn.client.widgets.grid.model.DMNGridData;
import org.kie.workbench.common.dmn.client.widgets.layer.DMNGridLayer;
import org.kie.workbench.common.stunner.core.client.api.SessionManager;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.command.SessionCommandManager;
import org.kie.workbench.common.stunner.core.client.session.ClientSession;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.model.GridRow;
import org.uberfire.mvp.Command;

@RunWith(value=LienzoMockitoTestRunner.class)
public class RelationGridDataTest {
    @Mock
    private GridRow gridRow;
    @Mock
    private GridColumn gridColumn;
    @Mock
    private DMNGridLayer gridLayer;
    @Mock
    private SessionManager sessionManager;
    @Mock
    private SessionCommandManager<AbstractCanvasHandler> sessionCommandManager;
    @Mock
    private ClientSession session;
    @Mock
    private AbstractCanvasHandler canvasHandler;
    @Mock
    private Command canvasOperation;
    private DMNGridData delegate;
    private RelationGridData uiModel;
    private Optional<Relation> expression = Optional.of(new Relation());

    @Before
    public void setup() {
        this.delegate = (DMNGridData)Mockito.spy((Object)new DMNGridData(this.gridLayer));
        this.uiModel = new RelationGridData(this.delegate, this.sessionManager, this.sessionCommandManager, this.expression, this.canvasOperation);
        ((SessionManager)Mockito.doReturn((Object)this.session).when((Object)this.sessionManager)).getCurrentSession();
        ((ClientSession)Mockito.doReturn((Object)this.canvasHandler).when((Object)this.session)).getCanvasHandler();
    }

    @Test
    public void testMoveRowTo() {
        this.uiModel.moveRowTo(0, this.gridRow);
        ((SessionCommandManager)Mockito.verify(this.sessionCommandManager)).execute(Matchers.eq((Object)this.canvasHandler), (org.kie.workbench.common.stunner.core.command.Command)Matchers.any(MoveRowsCommand.class));
    }

    @Test
    public void testMoveRowsTo() {
        this.uiModel.moveRowsTo(0, Collections.singletonList(this.gridRow));
        ((SessionCommandManager)Mockito.verify(this.sessionCommandManager)).execute(Matchers.eq((Object)this.canvasHandler), (org.kie.workbench.common.stunner.core.command.Command)Matchers.any(MoveRowsCommand.class));
    }

    @Test
    public void testMoveColumnTo() {
        this.uiModel.moveColumnTo(0, this.gridColumn);
        ((SessionCommandManager)Mockito.verify(this.sessionCommandManager)).execute(Matchers.eq((Object)this.canvasHandler), (org.kie.workbench.common.stunner.core.command.Command)Matchers.any(MoveColumnsCommand.class));
    }

    @Test
    public void testMoveColumnsTo() {
        this.uiModel.moveColumnsTo(0, Collections.singletonList(this.gridColumn));
        ((SessionCommandManager)Mockito.verify(this.sessionCommandManager)).execute(Matchers.eq((Object)this.canvasHandler), (org.kie.workbench.common.stunner.core.command.Command)Matchers.any(MoveColumnsCommand.class));
    }

    @Test
    public void testAppendColumn() {
        this.uiModel.appendColumn(this.gridColumn);
        ((DMNGridData)Mockito.verify((Object)this.delegate)).appendColumn((GridColumn)Matchers.eq((Object)this.gridColumn));
        ((GridColumn)Mockito.verify((Object)this.gridColumn)).setResizable(Matchers.eq((boolean)false));
    }

    @Test
    public void testInsertColumn() {
        this.uiModel.insertColumn(0, this.gridColumn);
        ((DMNGridData)Mockito.verify((Object)this.delegate)).insertColumn(Matchers.eq((int)0), (GridColumn)Matchers.eq((Object)this.gridColumn));
        ((GridColumn)Mockito.verify((Object)this.gridColumn)).setResizable(Matchers.eq((boolean)false));
    }

    @Test
    public void testDeleteColumn() {
        GridColumn anotherGridColumn = (GridColumn)Mockito.mock(GridColumn.class);
        this.uiModel.appendColumn(anotherGridColumn);
        this.uiModel.appendColumn(this.gridColumn);
        Mockito.reset((Object[])new GridColumn[]{anotherGridColumn});
        this.uiModel.deleteColumn(this.gridColumn);
        ((DMNGridData)Mockito.verify((Object)this.delegate)).deleteColumn((GridColumn)Matchers.eq((Object)this.gridColumn));
        ((GridColumn)Mockito.verify((Object)anotherGridColumn)).setResizable(Matchers.eq((boolean)false));
    }
}

