/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.expressions.types.relation;

import com.ait.lienzo.test.LienzoMockitoTestRunner;
import java.util.Optional;
import javax.enterprise.event.Event;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.definition.HasExpression;
import org.kie.workbench.common.dmn.api.definition.HasName;
import org.kie.workbench.common.dmn.api.definition.v1_1.InformationItem;
import org.kie.workbench.common.dmn.api.definition.v1_1.List;
import org.kie.workbench.common.dmn.api.definition.v1_1.LiteralExpression;
import org.kie.workbench.common.dmn.api.definition.v1_1.Relation;
import org.kie.workbench.common.dmn.client.commands.expressions.types.relation.AddRelationColumnCommand;
import org.kie.workbench.common.dmn.client.commands.expressions.types.relation.AddRelationRowCommand;
import org.kie.workbench.common.dmn.client.editors.expressions.types.relation.RelationGrid;
import org.kie.workbench.common.dmn.client.editors.expressions.types.relation.RelationGridControls;
import org.kie.workbench.common.dmn.client.events.ExpressionEditorSelectedEvent;
import org.kie.workbench.common.dmn.client.session.DMNClientFullSession;
import org.kie.workbench.common.dmn.client.widgets.grid.model.GridCellTuple;
import org.kie.workbench.common.dmn.client.widgets.layer.DMNGridLayer;
import org.kie.workbench.common.dmn.client.widgets.panel.DMNGridPanel;
import org.kie.workbench.common.stunner.core.client.api.SessionManager;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.command.SessionCommandManager;
import org.kie.workbench.common.stunner.core.command.Command;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.uberfire.ext.wires.core.grids.client.model.GridCell;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.widget.grid.columns.RowNumberColumn;
import org.uberfire.mocks.EventSourceMock;

@RunWith(value=LienzoMockitoTestRunner.class)
public class RelationGridTest {
    @Mock
    private GridCellTuple parent;
    @Mock
    private HasExpression hasExpression;
    private Relation relation = new Relation();
    private Optional<Relation> expression = Optional.of(this.relation);
    private Optional<HasName> hasName = Optional.empty();
    @Mock
    private DMNGridPanel gridPanel;
    @Mock
    private DMNGridLayer gridLayer;
    @Mock
    private SessionManager sessionManager;
    @Mock
    private DMNClientFullSession dmnClientFullSession;
    @Mock
    private AbstractCanvasHandler abstractCanvasHandler;
    @Mock
    private SessionCommandManager<AbstractCanvasHandler> sessionCommandManager;
    private Event<ExpressionEditorSelectedEvent> editorSelectedEvent;
    @Mock
    private RelationGridControls controls;
    @Captor
    private ArgumentCaptor<AddRelationColumnCommand> addColumnCommand;
    @Captor
    private ArgumentCaptor<AddRelationRowCommand> addRowCommand;
    private RelationGrid relationGrid;

    @Before
    public void setUp() throws Exception {
        this.editorSelectedEvent = new EventSourceMock();
        ((DMNClientFullSession)Mockito.doReturn((Object)this.abstractCanvasHandler).when((Object)this.dmnClientFullSession)).getCanvasHandler();
        ((SessionManager)Mockito.doReturn((Object)this.dmnClientFullSession).when((Object)this.sessionManager)).getCurrentSession();
    }

    @Test
    public void testInitialiseUiColumnsEmptyModel() throws Exception {
        this.relationGrid = new RelationGrid(this.parent, this.hasExpression, this.expression, this.hasName, this.gridPanel, this.gridLayer, this.sessionManager, this.sessionCommandManager, this.editorSelectedEvent, this.controls);
        Assert.assertEquals((long)0L, (long)this.relationGrid.getModel().getRowCount());
        Assert.assertEquals((long)1L, (long)this.relationGrid.getModel().getColumns().size());
        Assert.assertTrue((boolean)(this.relationGrid.getModel().getColumns().get(0) instanceof RowNumberColumn));
    }

    @Test
    public void testInitialiseUiColumns() throws Exception {
        String columnHeader = "first column";
        this.relation.getColumn().add(new InformationItem(){
            {
                this.getName().setValue("first column");
            }
        });
        this.relationGrid = new RelationGrid(this.parent, this.hasExpression, this.expression, this.hasName, this.gridPanel, this.gridLayer, this.sessionManager, this.sessionCommandManager, this.editorSelectedEvent, this.controls);
        Assert.assertEquals((long)2L, (long)this.relationGrid.getModel().getColumns().size());
        Assert.assertTrue((boolean)(this.relationGrid.getModel().getColumns().get(0) instanceof RowNumberColumn));
        Assert.assertEquals((Object)"first column", (Object)((GridColumn.HeaderMetaData)((GridColumn)this.relationGrid.getModel().getColumns().get(1)).getHeaderMetaData().get(0)).getTitle());
    }

    @Test
    public void testInitialiseUiModel() throws Exception {
        this.relation.getColumn().add(new InformationItem(){
            {
                this.getName().setValue("first column header");
            }
        });
        String firstRowValue = "first column value 1";
        String secondRowValue = "first column value 2";
        this.relation.getRow().add(new List(){
            {
                this.getExpression().add(new LiteralExpression(){
                    {
                        this.setText("first column value 1");
                    }
                });
            }
        });
        this.relation.getRow().add(new List(){
            {
                this.getExpression().add(new LiteralExpression(){
                    {
                        this.setText("first column value 2");
                    }
                });
            }
        });
        this.relationGrid = new RelationGrid(this.parent, this.hasExpression, this.expression, this.hasName, this.gridPanel, this.gridLayer, this.sessionManager, this.sessionCommandManager, this.editorSelectedEvent, this.controls);
        Assert.assertEquals((long)2L, (long)this.relationGrid.getModel().getRowCount());
        Assert.assertEquals((Object)"first column value 1", (Object)((GridCell)this.relationGrid.getModel().getRow(0).getCells().get(1)).getValue().getValue());
        Assert.assertEquals((Object)"first column value 2", (Object)((GridCell)this.relationGrid.getModel().getRow(1).getCells().get(1)).getValue().getValue());
    }

    @Test
    public void testAddColumn() throws Exception {
        this.relationGrid = new RelationGrid(this.parent, this.hasExpression, this.expression, this.hasName, this.gridPanel, this.gridLayer, this.sessionManager, this.sessionCommandManager, this.editorSelectedEvent, this.controls);
        this.relationGrid.addColumn();
        ((SessionCommandManager)Mockito.verify(this.sessionCommandManager)).execute(Matchers.eq((Object)this.abstractCanvasHandler), (Command)this.addColumnCommand.capture());
        ((AddRelationColumnCommand)this.addColumnCommand.getValue()).execute(this.abstractCanvasHandler);
        ((DMNGridPanel)Mockito.verify((Object)this.gridPanel)).refreshScrollPosition();
        ((DMNGridPanel)Mockito.verify((Object)this.gridPanel)).updatePanelSize();
        ((DMNGridLayer)Mockito.verify((Object)this.gridLayer)).batch();
    }

    @Test
    public void testAddRow() throws Exception {
        this.relationGrid = new RelationGrid(this.parent, this.hasExpression, this.expression, this.hasName, this.gridPanel, this.gridLayer, this.sessionManager, this.sessionCommandManager, this.editorSelectedEvent, this.controls);
        this.relationGrid.addRow();
        ((SessionCommandManager)Mockito.verify(this.sessionCommandManager)).execute(Matchers.eq((Object)this.abstractCanvasHandler), (Command)this.addRowCommand.capture());
        ((AddRelationRowCommand)this.addRowCommand.getValue()).execute(this.abstractCanvasHandler);
        ((DMNGridPanel)Mockito.verify((Object)this.gridPanel)).refreshScrollPosition();
        ((DMNGridPanel)Mockito.verify((Object)this.gridPanel)).updatePanelSize();
        ((DMNGridLayer)Mockito.verify((Object)this.gridLayer)).batch();
    }
}

