/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.expressions.types.relation;

import java.util.Optional;
import java.util.function.Supplier;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.definition.v1_1.InformationItem;
import org.kie.workbench.common.dmn.api.definition.v1_1.List;
import org.kie.workbench.common.dmn.api.definition.v1_1.LiteralExpression;
import org.kie.workbench.common.dmn.api.definition.v1_1.Relation;
import org.kie.workbench.common.dmn.client.editors.expressions.types.relation.RelationColumn;
import org.kie.workbench.common.dmn.client.editors.expressions.types.relation.RelationUIModelMapper;
import org.kie.workbench.common.dmn.client.widgets.grid.model.DMNGridRow;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.uberfire.ext.wires.core.grids.client.model.GridCellValue;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.model.GridRow;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridCellValue;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridData;
import org.uberfire.ext.wires.core.grids.client.widget.grid.columns.RowNumberColumn;

@RunWith(value=MockitoJUnitRunner.class)
public class RelationUIModelMapperTest {
    @Mock
    private RowNumberColumn uiRowNumberColumn;
    @Mock
    private RelationColumn uiRelationColumn1;
    @Mock
    private RelationColumn uiRelationColumn2;
    private BaseGridData uiModel;
    private Relation relation;
    private Supplier<Optional<GridCellValue<?>>> cellValueSupplier;
    private RelationUIModelMapper mapper;

    @Before
    public void setup() {
        this.uiModel = new BaseGridData();
        this.uiModel.appendRow((GridRow)new DMNGridRow());
        this.uiModel.appendRow((GridRow)new DMNGridRow());
        this.uiModel.appendColumn((GridColumn)this.uiRowNumberColumn);
        this.uiModel.appendColumn((GridColumn)this.uiRelationColumn1);
        this.uiModel.appendColumn((GridColumn)this.uiRelationColumn2);
        ((RowNumberColumn)Mockito.doReturn((Object)0).when((Object)this.uiRowNumberColumn)).getIndex();
        ((RelationColumn)Mockito.doReturn((Object)1).when((Object)this.uiRelationColumn1)).getIndex();
        ((RelationColumn)Mockito.doReturn((Object)2).when((Object)this.uiRelationColumn2)).getIndex();
        this.relation = new Relation();
        this.relation.getColumn().add(new InformationItem());
        this.relation.getColumn().add(new InformationItem());
        this.relation.getRow().add(new List(){
            {
                this.getExpression().add(new LiteralExpression(){
                    {
                        this.setText("le(1,0)");
                    }
                });
                this.getExpression().add(new LiteralExpression(){
                    {
                        this.setText("le(2,0)");
                    }
                });
            }
        });
        this.relation.getRow().add(new List(){
            {
                this.getExpression().add(new LiteralExpression(){
                    {
                        this.setText("le(1,1)");
                    }
                });
                this.getExpression().add(new LiteralExpression(){
                    {
                        this.setText("le(2,1)");
                    }
                });
            }
        });
        this.mapper = new RelationUIModelMapper(() -> this.uiModel, () -> Optional.of(this.relation));
        this.cellValueSupplier = Optional::empty;
    }

    @Test
    public void testFromDMNModelRowNumber() {
        this.mapper.fromDMNModel(0, 0);
        this.mapper.fromDMNModel(1, 0);
        Assert.assertEquals((Object)1, (Object)this.uiModel.getCell(0, 0).getValue().getValue());
        Assert.assertEquals((Object)2, (Object)this.uiModel.getCell(1, 0).getValue().getValue());
    }

    @Test
    public void testFromDMNModelLiteralExpressions() {
        this.mapper.fromDMNModel(0, 1);
        this.mapper.fromDMNModel(0, 2);
        this.mapper.fromDMNModel(1, 1);
        this.mapper.fromDMNModel(1, 2);
        Assert.assertEquals((Object)"le(1,0)", (Object)this.uiModel.getCell(0, 1).getValue().getValue());
        Assert.assertEquals((Object)"le(2,0)", (Object)this.uiModel.getCell(0, 2).getValue().getValue());
        Assert.assertEquals((Object)"le(1,1)", (Object)this.uiModel.getCell(1, 1).getValue().getValue());
        Assert.assertEquals((Object)"le(2,1)", (Object)this.uiModel.getCell(1, 2).getValue().getValue());
    }

    @Test
    public void testToDMNModelLiteralExpressionsEmptyValue() {
        for (int uiRowIndex = 0; uiRowIndex < this.uiModel.getRowCount(); ++uiRowIndex) {
            for (int uiColumnIndex = 1; uiColumnIndex < this.uiModel.getColumnCount(); ++uiColumnIndex) {
                this.mapper.toDMNModel(uiRowIndex, uiColumnIndex, this.cellValueSupplier);
                LiteralExpression le = (LiteralExpression)((List)this.relation.getRow().get(uiRowIndex)).getExpression().get(uiColumnIndex - 1);
                Assert.assertEquals((Object)"", (Object)le.getText());
            }
        }
    }

    @Test
    public void testToDMNModelLiteralExpressionsNonEmptyValue() {
        for (int uiRowIndex = 0; uiRowIndex < this.uiModel.getRowCount(); ++uiRowIndex) {
            for (int uiColumnIndex = 1; uiColumnIndex < this.uiModel.getColumnCount(); ++uiColumnIndex) {
                String value = "(" + uiColumnIndex + "," + uiRowIndex + ")";
                this.cellValueSupplier = () -> Optional.of(new BaseGridCellValue((Object)value));
                this.mapper.toDMNModel(uiRowIndex, uiColumnIndex, this.cellValueSupplier);
                LiteralExpression le = (LiteralExpression)((List)this.relation.getRow().get(uiRowIndex)).getExpression().get(uiColumnIndex - 1);
                Assert.assertEquals((Object)value, (Object)le.getText());
            }
        }
    }
}

