/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.expressions.types.undefined;

import com.ait.lienzo.client.core.event.NodeMouseEnterEvent;
import com.ait.lienzo.client.core.event.NodeMouseEnterHandler;
import com.ait.lienzo.client.core.shape.Group;
import com.ait.lienzo.client.core.shape.Rectangle;
import com.ait.lienzo.client.core.shape.Viewport;
import com.ait.lienzo.client.core.types.Point2D;
import com.ait.lienzo.client.core.types.Transform;
import com.ait.lienzo.test.LienzoMockitoTestRunner;
import com.google.gwtmockito.GwtMockito;
import java.util.Optional;
import java.util.function.Supplier;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.definition.v1_1.Expression;
import org.kie.workbench.common.dmn.api.definition.v1_1.LiteralExpression;
import org.kie.workbench.common.dmn.client.editors.expressions.types.ExpressionEditorDefinition;
import org.kie.workbench.common.dmn.client.editors.expressions.types.ExpressionEditorDefinitions;
import org.kie.workbench.common.dmn.client.editors.expressions.types.ExpressionType;
import org.kie.workbench.common.dmn.client.editors.expressions.types.undefined.ExpressionEditorTooltip;
import org.kie.workbench.common.dmn.client.editors.expressions.types.undefined.UndefinedExpressionColumnRenderer;
import org.kie.workbench.common.dmn.client.editors.expressions.types.undefined.UndefinedExpressionGrid;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;

@RunWith(value=LienzoMockitoTestRunner.class)
public class UndefinedExpressionColumnRendererTest {
    @Mock
    private ExpressionEditorDefinition<Expression> editorDefinition;
    @Mock
    private LiteralExpression expression;
    @Mock
    private Supplier<ExpressionEditorDefinitions> expressionEditorDefinitionsSupplier;
    @Mock
    private Group editorTypesContainer;
    @Mock
    private Point2D editorTypesContainerLocation;
    @Mock
    private ExpressionEditorTooltip tooltip;
    @Mock
    private Rectangle tooltipPlaceholder;
    @Mock
    private UndefinedExpressionGrid gridWidget;
    @Mock
    private Viewport viewport;
    @Mock
    private Transform transform;
    @Mock
    private NodeMouseEnterEvent mouseEnterEvent;
    private UndefinedExpressionColumnRenderer renderer;

    @Before
    public void setup() {
        ExpressionEditorDefinitions expressionEditorDefinitions = new ExpressionEditorDefinitions();
        expressionEditorDefinitions.add(this.editorDefinition);
        ((Supplier)Mockito.doReturn((Object)expressionEditorDefinitions).when(this.expressionEditorDefinitionsSupplier)).get();
        ((ExpressionEditorDefinition)Mockito.doReturn((Object)ExpressionType.LITERAL_EXPRESSION).when(this.editorDefinition)).getType();
        ((ExpressionEditorDefinition)Mockito.doReturn(Optional.of(this.expression)).when(this.editorDefinition)).getModelClass();
        ((Group)Mockito.doReturn((Object)this.viewport).when((Object)this.editorTypesContainer)).getViewport();
        ((Viewport)Mockito.doReturn((Object)this.transform).when((Object)this.viewport)).getTransform();
        ((Group)Mockito.doReturn((Object)this.editorTypesContainerLocation).when((Object)this.editorTypesContainer)).getAbsoluteLocation();
        GwtMockito.useProviderForType(Group.class, type -> this.editorTypesContainer);
        this.renderer = new MockUndefinedExpressionColumnRenderer(this.expressionEditorDefinitionsSupplier, this.gridWidget);
    }

    @Test
    public void testTooltipPositioningNoTranslation() {
        this.assertPositioning(0.0, 0.0, 100.0, 200.0, 100.0, 200.0);
    }

    @Test
    public void testTooltipPositioningWithTranslationNegative() {
        this.assertPositioning(-20.0, -40.0, 100.0, 200.0, 120.0, 240.0);
    }

    @Test
    public void testTooltipPositioningWithTranslationPositive() {
        this.assertPositioning(20.0, 40.0, 100.0, 200.0, 80.0, 160.0);
    }

    private void assertPositioning(double tx, double ty, double editorTypesContainerLocationX, double editorTypesContainerLocationY, double expectedAbsoluteCellX, double expectedAbsoluteCellY) {
        ((Transform)Mockito.doReturn((Object)tx).when((Object)this.transform)).getTranslateX();
        ((Transform)Mockito.doReturn((Object)ty).when((Object)this.transform)).getTranslateY();
        ((Point2D)Mockito.doReturn((Object)editorTypesContainerLocationX).when((Object)this.editorTypesContainerLocation)).getX();
        ((Point2D)Mockito.doReturn((Object)editorTypesContainerLocationY).when((Object)this.editorTypesContainerLocation)).getY();
        NodeMouseEnterHandler handler = this.renderer.getNodeMouseEnterHandler(this.editorDefinition, this.tooltipPlaceholder);
        handler.onNodeMouseEnter(this.mouseEnterEvent);
        ((ExpressionEditorTooltip)Mockito.verify((Object)this.tooltip)).show((ExpressionEditorDefinition)Matchers.eq(this.editorDefinition), Matchers.eq((double)expectedAbsoluteCellX), Matchers.eq((double)expectedAbsoluteCellY), (Rectangle)Matchers.eq((Object)this.tooltipPlaceholder));
    }

    private class MockUndefinedExpressionColumnRenderer
    extends UndefinedExpressionColumnRenderer {
        public MockUndefinedExpressionColumnRenderer(Supplier<ExpressionEditorDefinitions> expressionEditorDefinitionsSupplier, UndefinedExpressionGrid gridWidget) {
            super(expressionEditorDefinitionsSupplier, gridWidget);
        }

        ExpressionEditorTooltip getTooltip() {
            return UndefinedExpressionColumnRendererTest.this.tooltip;
        }
    }
}

