/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.expressions.util;

import com.ait.lienzo.client.core.shape.Text;
import com.ait.lienzo.shared.core.types.TextAlign;
import com.ait.lienzo.test.LienzoMockitoTestRunner;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.client.editors.expressions.util.RendererUtils;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.uberfire.ext.wires.core.grids.client.model.GridCell;
import org.uberfire.ext.wires.core.grids.client.model.GridCellValue;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridCell;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridCellValue;
import org.uberfire.ext.wires.core.grids.client.widget.context.GridBodyCellRenderContext;
import org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.grids.GridRenderer;
import org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.themes.GridRendererTheme;

@RunWith(value=LienzoMockitoTestRunner.class)
public class RendererUtilsTest {
    private static final String VALUE = "some text value";
    private static final double WIDTH = 200.0;
    private static final double HEIGHT = 80.0;
    private Text text;
    @Mock
    private GridRenderer gridRenderer;
    @Mock
    private GridRendererTheme gridTheme;
    @Mock
    private GridBodyCellRenderContext context;

    @Before
    public void setUp() throws Exception {
        this.text = (Text)Mockito.spy((Object)new Text(""));
        Mockito.when((Object)this.context.getRenderer()).thenReturn((Object)this.gridRenderer);
        Mockito.when((Object)this.gridRenderer.getTheme()).thenReturn((Object)this.gridTheme);
        Mockito.when((Object)this.gridTheme.getBodyText()).thenReturn((Object)this.text);
        Mockito.when((Object)this.context.getCellWidth()).thenReturn((Object)200.0);
        Mockito.when((Object)this.context.getCellHeight()).thenReturn((Object)80.0);
    }

    @Test
    public void testCenteredText() throws Exception {
        BaseGridCell cell = new BaseGridCell((GridCellValue)new BaseGridCellValue((Object)VALUE));
        RendererUtils.getCenteredCellText((GridBodyCellRenderContext)this.context, (GridCell)cell);
        ((Text)Mockito.verify((Object)this.text)).setText(VALUE);
        ((Text)Mockito.verify((Object)this.text)).setListening(false);
        ((Text)Mockito.verify((Object)this.text)).setX(100.0);
        ((Text)Mockito.verify((Object)this.text)).setY(40.0);
    }

    @Test
    public void testLeftAlignTest() throws Exception {
        BaseGridCell cell = new BaseGridCell((GridCellValue)new BaseGridCellValue((Object)VALUE));
        RendererUtils.getExpressionCellText((GridBodyCellRenderContext)this.context, (GridCell)cell);
        ((Text)Mockito.verify((Object)this.text)).setText(VALUE);
        ((Text)Mockito.verify((Object)this.text)).setListening(false);
        ((Text)Mockito.verify((Object)this.text)).setX(5.0);
        ((Text)Mockito.verify((Object)this.text)).setY(5.0);
        ((Text)Mockito.verify((Object)this.text)).setFontFamily("Courier New");
        ((Text)Mockito.verify((Object)this.text)).setTextAlign(TextAlign.LEFT);
    }
}

