/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.session;

import com.google.gwtmockito.GwtMockitoTestRunner;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.client.session.DMNClientFullSession;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvas;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.Canvas;
import org.kie.workbench.common.stunner.core.client.canvas.CanvasFactory;
import org.kie.workbench.common.stunner.core.client.canvas.controls.actions.CanvasInPlaceTextEditorControl;
import org.kie.workbench.common.stunner.core.client.canvas.controls.builder.ElementBuilderControl;
import org.kie.workbench.common.stunner.core.client.canvas.controls.connection.ConnectionAcceptorControl;
import org.kie.workbench.common.stunner.core.client.canvas.controls.containment.ContainmentAcceptorControl;
import org.kie.workbench.common.stunner.core.client.canvas.controls.docking.DockingAcceptorControl;
import org.kie.workbench.common.stunner.core.client.canvas.controls.drag.LocationControl;
import org.kie.workbench.common.stunner.core.client.canvas.controls.keyboard.KeyboardControl;
import org.kie.workbench.common.stunner.core.client.canvas.controls.pan.PanControl;
import org.kie.workbench.common.stunner.core.client.canvas.controls.resize.ResizeControl;
import org.kie.workbench.common.stunner.core.client.canvas.controls.select.SelectionControl;
import org.kie.workbench.common.stunner.core.client.canvas.controls.toolbox.ToolboxControl;
import org.kie.workbench.common.stunner.core.client.canvas.controls.zoom.ZoomControl;
import org.kie.workbench.common.stunner.core.client.canvas.listener.CanvasElementListener;
import org.kie.workbench.common.stunner.core.client.canvas.listener.CanvasShapeListener;
import org.kie.workbench.common.stunner.core.client.command.CanvasCommandManager;
import org.kie.workbench.common.stunner.core.client.command.SessionCommandManager;
import org.kie.workbench.common.stunner.core.client.session.ClientSession;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.registry.RegistryFactory;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@RunWith(value=GwtMockitoTestRunner.class)
public class DMNClientFullSessionTest {
    @Mock
    private CanvasFactory<AbstractCanvas, AbstractCanvasHandler> factory;
    @Mock
    private AbstractCanvas canvas;
    @Mock
    private AbstractCanvasHandler canvasHandler;
    @Mock
    private SelectionControl<AbstractCanvasHandler, Element> selectionControl;
    @Mock
    private ZoomControl<AbstractCanvas> zoomControl;
    @Mock
    private PanControl<AbstractCanvas> panControl;
    @Mock
    private LocationControl<AbstractCanvasHandler, Element> locationControl;
    @Mock
    private ResizeControl<AbstractCanvasHandler, Element> resizeControl;
    @Mock
    private CanvasCommandManager<AbstractCanvasHandler> canvasCommandManager;
    @Mock
    private SessionCommandManager<AbstractCanvasHandler> sessionCommandManager;
    @Mock
    private SessionCommandManager<AbstractCanvasHandler> requestCommandManager;
    @Mock
    private RegistryFactory registryFactory;
    @Mock
    private ConnectionAcceptorControl<AbstractCanvasHandler> connectionAcceptorControl;
    @Mock
    private ContainmentAcceptorControl<AbstractCanvasHandler> containmentAcceptorControl;
    @Mock
    private DockingAcceptorControl<AbstractCanvasHandler> dockingAcceptorControl;
    @Mock
    private ToolboxControl<AbstractCanvasHandler, Element> toolboxControl;
    @Mock
    private ElementBuilderControl<AbstractCanvasHandler> builderControl;
    @Mock
    private KeyboardControl<Canvas, ClientSession> keyboardControl;
    @Mock
    private CanvasInPlaceTextEditorControl<AbstractCanvasHandler, ClientSession, Element> canvasInPlaceTextEditorControl;
    private DMNClientFullSession session;

    @Before
    public void setup() throws Exception {
        Mockito.when((Object)this.factory.newCanvas()).thenReturn((Object)this.canvas);
        Mockito.when((Object)this.factory.newCanvasHandler()).thenReturn((Object)this.canvasHandler);
        Mockito.when((Object)this.factory.newControl((Class)Matchers.eq(ZoomControl.class))).thenReturn(this.zoomControl);
        Mockito.when((Object)this.factory.newControl((Class)Matchers.eq(LocationControl.class))).thenReturn(this.locationControl);
        Mockito.when((Object)this.factory.newControl((Class)Matchers.eq(PanControl.class))).thenReturn(this.panControl);
        Mockito.when((Object)this.factory.newControl((Class)Matchers.eq(CanvasInPlaceTextEditorControl.class))).thenReturn(this.canvasInPlaceTextEditorControl);
        Mockito.when((Object)this.factory.newControl((Class)Matchers.eq(SelectionControl.class))).thenReturn(this.selectionControl);
        Mockito.when((Object)this.factory.newControl((Class)Matchers.eq(ResizeControl.class))).thenReturn(this.resizeControl);
        Mockito.when((Object)this.factory.newControl((Class)Matchers.eq(ConnectionAcceptorControl.class))).thenReturn(this.connectionAcceptorControl);
        Mockito.when((Object)this.factory.newControl((Class)Matchers.eq(ContainmentAcceptorControl.class))).thenReturn(this.containmentAcceptorControl);
        Mockito.when((Object)this.factory.newControl((Class)Matchers.eq(DockingAcceptorControl.class))).thenReturn(this.dockingAcceptorControl);
        Mockito.when((Object)this.factory.newControl((Class)Matchers.eq(ToolboxControl.class))).thenReturn(this.toolboxControl);
        Mockito.when((Object)this.factory.newControl((Class)Matchers.eq(ElementBuilderControl.class))).thenReturn(this.builderControl);
        Mockito.when((Object)this.factory.newControl((Class)Matchers.eq(KeyboardControl.class))).thenReturn(this.keyboardControl);
        Mockito.when((Object)this.canvasHandler.getCanvas()).thenReturn((Object)this.canvas);
        this.session = new DMNClientFullSession(this.factory, this.canvasCommandManager, this.sessionCommandManager, this.requestCommandManager, this.registryFactory);
    }

    @Test
    public void testInit() {
        Assert.assertEquals((Object)this.canvas, (Object)this.session.getCanvas());
        Assert.assertEquals((Object)this.canvasHandler, (Object)this.session.getCanvasHandler());
        Assert.assertEquals(this.selectionControl, (Object)this.session.getSelectionControl());
        Assert.assertEquals(this.zoomControl, (Object)this.session.getZoomControl());
        Assert.assertEquals(this.canvasInPlaceTextEditorControl, (Object)this.session.getCanvasInPlaceTextEditorControl());
        Assert.assertEquals(this.locationControl, (Object)this.session.getLocationControl());
        Assert.assertEquals(this.resizeControl, (Object)this.session.getResizeControl());
        Assert.assertEquals(this.toolboxControl, (Object)this.session.getToolboxControl());
        Assert.assertEquals(this.panControl, (Object)this.session.getPanControl());
        Assert.assertEquals(this.canvasCommandManager, (Object)this.session.getCommandManager());
        Assert.assertEquals(this.connectionAcceptorControl, (Object)this.session.getConnectionAcceptorControl());
        Assert.assertEquals(this.containmentAcceptorControl, (Object)this.session.getContainmentAcceptorControl());
        Assert.assertEquals(this.dockingAcceptorControl, (Object)this.session.getDockingAcceptorControl());
        Assert.assertEquals(this.builderControl, (Object)this.session.getBuilderControl());
        Assert.assertEquals(this.keyboardControl, (Object)this.session.getKeyboardControl());
    }

    @Test
    public void testOpenSession() {
        this.session.open();
        ((AbstractCanvas)Mockito.verify((Object)this.canvas, (VerificationMode)Mockito.times((int)1))).addRegistrationListener((CanvasShapeListener)Matchers.any(CanvasShapeListener.class));
        ((AbstractCanvasHandler)Mockito.verify((Object)this.canvasHandler, (VerificationMode)Mockito.times((int)1))).addRegistrationListener((CanvasElementListener)Matchers.any(CanvasElementListener.class));
        ((SelectionControl)Mockito.verify(this.selectionControl, (VerificationMode)Mockito.times((int)1))).enable(Matchers.eq((Object)this.canvasHandler));
        ((ZoomControl)Mockito.verify(this.zoomControl, (VerificationMode)Mockito.times((int)1))).enable(Matchers.eq((Object)this.canvas));
        ((CanvasInPlaceTextEditorControl)Mockito.verify(this.canvasInPlaceTextEditorControl, (VerificationMode)Mockito.times((int)1))).enable(Matchers.eq((Object)this.canvasHandler));
        ((LocationControl)Mockito.verify(this.locationControl, (VerificationMode)Mockito.times((int)1))).enable(Matchers.eq((Object)this.canvasHandler));
        ((PanControl)Mockito.verify(this.panControl, (VerificationMode)Mockito.times((int)1))).enable(Matchers.eq((Object)this.canvas));
        ((ConnectionAcceptorControl)Mockito.verify(this.connectionAcceptorControl, (VerificationMode)Mockito.times((int)1))).enable(Matchers.eq((Object)this.canvasHandler));
        ((ContainmentAcceptorControl)Mockito.verify(this.containmentAcceptorControl, (VerificationMode)Mockito.times((int)1))).enable(Matchers.eq((Object)this.canvasHandler));
        ((DockingAcceptorControl)Mockito.verify(this.dockingAcceptorControl, (VerificationMode)Mockito.times((int)1))).enable(Matchers.eq((Object)this.canvasHandler));
        ((ElementBuilderControl)Mockito.verify(this.builderControl, (VerificationMode)Mockito.times((int)1))).enable(Matchers.eq((Object)this.canvasHandler));
        ((KeyboardControl)Mockito.verify(this.keyboardControl, (VerificationMode)Mockito.times((int)1))).bind((ClientSession)Matchers.eq((Object)this.session));
    }

    @Test
    public void testDestroySession() {
        this.session.open();
        this.session.destroy();
        Assert.assertFalse((boolean)this.session.isOpened());
        ((AbstractCanvas)Mockito.verify((Object)this.canvas, (VerificationMode)Mockito.times((int)1))).removeRegistrationListener((CanvasShapeListener)Matchers.any(CanvasShapeListener.class));
        ((AbstractCanvasHandler)Mockito.verify((Object)this.canvasHandler, (VerificationMode)Mockito.times((int)1))).removeRegistrationListener((CanvasElementListener)Matchers.any(CanvasElementListener.class));
        ((AbstractCanvasHandler)Mockito.verify((Object)this.canvasHandler, (VerificationMode)Mockito.times((int)1))).destroy();
        ((SelectionControl)Mockito.verify(this.selectionControl, (VerificationMode)Mockito.times((int)1))).disable();
        ((ZoomControl)Mockito.verify(this.zoomControl, (VerificationMode)Mockito.times((int)1))).disable();
        ((LocationControl)Mockito.verify(this.locationControl, (VerificationMode)Mockito.times((int)1))).disable();
        ((CanvasInPlaceTextEditorControl)Mockito.verify(this.canvasInPlaceTextEditorControl, (VerificationMode)Mockito.times((int)1))).disable();
        ((PanControl)Mockito.verify(this.panControl, (VerificationMode)Mockito.times((int)1))).disable();
        ((ConnectionAcceptorControl)Mockito.verify(this.connectionAcceptorControl, (VerificationMode)Mockito.times((int)1))).disable();
        ((ContainmentAcceptorControl)Mockito.verify(this.containmentAcceptorControl, (VerificationMode)Mockito.times((int)1))).disable();
        ((DockingAcceptorControl)Mockito.verify(this.dockingAcceptorControl, (VerificationMode)Mockito.times((int)1))).disable();
        ((ElementBuilderControl)Mockito.verify(this.builderControl, (VerificationMode)Mockito.times((int)1))).disable();
        ((KeyboardControl)Mockito.verify(this.keyboardControl, (VerificationMode)Mockito.times((int)1))).unbind();
    }

    @Test
    public void testPauseSession() {
        this.session.open();
        this.session.pause();
        ((KeyboardControl)Mockito.verify(this.keyboardControl, (VerificationMode)Mockito.times((int)1))).disable();
    }

    @Test
    public void testResumeSession() {
        this.session.open();
        Mockito.reset((Object[])new KeyboardControl[]{this.keyboardControl});
        this.session.resume();
        ((KeyboardControl)Mockito.verify(this.keyboardControl, (VerificationMode)Mockito.times((int)1))).enable(Matchers.eq((Object)this.canvas));
    }
}

