/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.session.presenters.impl;

import java.lang.annotation.Annotation;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.client.session.BaseCommandsTest;
import org.kie.workbench.common.dmn.client.session.presenters.impl.SessionPreviewImpl;
import org.kie.workbench.common.stunner.client.widgets.presenters.session.SessionViewer;
import org.kie.workbench.common.stunner.client.widgets.views.WidgetWrapperView;
import org.kie.workbench.common.stunner.core.api.DefinitionManager;
import org.kie.workbench.common.stunner.core.client.api.ShapeManager;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvas;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.BaseCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.CanvasFactory;
import org.kie.workbench.common.stunner.core.client.canvas.command.AbstractCanvasGraphCommand;
import org.kie.workbench.common.stunner.core.client.canvas.controls.actions.TextPropertyProviderFactory;
import org.kie.workbench.common.stunner.core.client.canvas.controls.select.SelectionControl;
import org.kie.workbench.common.stunner.core.client.canvas.controls.zoom.ZoomControl;
import org.kie.workbench.common.stunner.core.client.command.CanvasCommandFactory;
import org.kie.workbench.common.stunner.core.client.command.CanvasCommandManager;
import org.kie.workbench.common.stunner.core.client.session.impl.AbstractClientSession;
import org.kie.workbench.common.stunner.core.command.Command;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.core.diagram.DiagramImpl;
import org.kie.workbench.common.stunner.core.diagram.Metadata;
import org.kie.workbench.common.stunner.core.diagram.MetadataImpl;
import org.kie.workbench.common.stunner.core.graph.Graph;
import org.kie.workbench.common.stunner.core.graph.content.Bounds;
import org.kie.workbench.common.stunner.core.graph.content.definition.DefinitionSetImpl;
import org.kie.workbench.common.stunner.core.graph.content.view.BoundImpl;
import org.kie.workbench.common.stunner.core.graph.content.view.BoundsImpl;
import org.kie.workbench.common.stunner.core.graph.impl.GraphImpl;
import org.kie.workbench.common.stunner.core.graph.store.GraphNodeStore;
import org.kie.workbench.common.stunner.core.graph.store.GraphNodeStoreImpl;
import org.kie.workbench.common.stunner.core.graph.util.GraphUtils;
import org.kie.workbench.common.stunner.core.util.DefinitionUtils;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class SessionPreviewImplTest
extends BaseCommandsTest {
    @Mock
    private DefinitionManager definitionManager;
    @Mock
    private ShapeManager shapeManager;
    @Mock
    private TextPropertyProviderFactory textPropertyProviderFactory;
    @Mock
    private CanvasCommandManager<AbstractCanvasHandler> canvasCommandManager;
    @Mock
    private DefinitionUtils definitionUtils;
    @Mock
    private GraphUtils graphUtils;
    @Mock
    private ManagedInstance<BaseCanvasHandler> canvasHandlerFactories;
    @Mock
    private ManagedInstance<CanvasCommandFactory> canvasCommandFactories;
    @Mock
    private SelectionControl<AbstractCanvasHandler, ?> selectionControl;
    @Mock
    private WidgetWrapperView view;
    @Mock
    private AbstractClientSession session;
    @Mock
    private SessionViewer.SessionViewerCallback callback;
    @Mock
    private CanvasFactory canvasFactory;
    @Mock
    private ZoomControl zoomControl;
    @Mock
    private AbstractCanvas canvas;
    @Mock
    private AbstractCanvas.View canvasView;
    private SessionPreviewImpl preview;

    @Before
    public void setup() {
        this.preview = new SessionPreviewImpl(this.definitionManager, this.shapeManager, this.textPropertyProviderFactory, this.canvasCommandManager, this.definitionUtils, this.graphUtils, this.canvasHandlerFactories, this.canvasCommandFactories, this.selectionControl, this.view);
        DiagramImpl diagram = new DiagramImpl("diagram", (Metadata)new MetadataImpl());
        GraphImpl graph = new GraphImpl("graph", (GraphNodeStore)new GraphNodeStoreImpl());
        DefinitionSetImpl definitionSet = new DefinitionSetImpl("id");
        diagram.setGraph((Graph)graph);
        graph.setContent((Object)definitionSet);
        definitionSet.setBounds((Bounds)new BoundsImpl(new BoundImpl(Double.valueOf(0.0), Double.valueOf(0.0)), new BoundImpl(Double.valueOf(100.0), Double.valueOf(100.0))));
        Mockito.when((Object)this.session.getCanvasHandler()).thenReturn((Object)this.canvasHandler);
        Mockito.when((Object)this.session.getCanvas()).thenReturn((Object)this.canvas);
        Mockito.when((Object)this.canvasHandler.getDiagram()).thenReturn((Object)diagram);
        Mockito.when((Object)this.shapeManager.getCanvasFactory((Diagram)Mockito.any(Diagram.class))).thenReturn((Object)this.canvasFactory);
        Mockito.when((Object)this.canvasFactory.newCanvas()).thenReturn((Object)this.canvas);
        Mockito.when((Object)this.canvasFactory.newControl((Class)Mockito.eq(ZoomControl.class))).thenReturn((Object)this.zoomControl);
        Mockito.when((Object)this.canvasHandlerFactories.select(new Annotation[]{(Annotation)Mockito.any(Annotation.class)})).thenReturn(this.canvasHandlerFactories);
        Mockito.when((Object)this.canvasHandlerFactories.get()).thenReturn((Object)this.canvasHandler);
        Mockito.when((Object)this.canvas.getView()).thenReturn((Object)this.canvasView);
        this.preview.open(this.session, this.callback);
    }

    @Test
    public void checkExecutionCommands() {
        BaseCommandsTest.MockCommand command = new BaseCommandsTest.MockCommand();
        this.preview.handleCanvasCommandExecutedEvent(this.makeCommandExecutionContext((Command)command));
        ((CanvasCommandManager)Mockito.verify(this.canvasCommandManager)).execute(Mockito.any(BaseCanvasHandler.class), (Command)Mockito.eq((Object)((Object)command)));
    }

    @Test
    public void checkVetoExecutionCommands() {
        BaseCommandsTest.MockVetoExecutionCommand command = new BaseCommandsTest.MockVetoExecutionCommand();
        this.preview.handleCanvasCommandExecutedEvent(this.makeCommandExecutionContext((Command)command));
        ((CanvasCommandManager)Mockito.verify(this.canvasCommandManager, (VerificationMode)Mockito.never())).execute(Mockito.any(AbstractCanvasHandler.class), (Command)Mockito.any(AbstractCanvasGraphCommand.class));
    }

    @Test
    public void checkUndoCommands() {
        BaseCommandsTest.MockCommand command = new BaseCommandsTest.MockCommand();
        this.preview.handleCanvasUndoCommandExecutedEvent(this.makeCommandUndoContext((Command)command));
        ((CanvasCommandManager)Mockito.verify(this.canvasCommandManager)).undo(Mockito.any(BaseCanvasHandler.class), (Command)Mockito.eq((Object)((Object)command)));
    }

    @Test
    public void checkVetoUndoCommands() {
        BaseCommandsTest.MockVetoUndoCommand command = new BaseCommandsTest.MockVetoUndoCommand();
        this.preview.handleCanvasUndoCommandExecutedEvent(this.makeCommandUndoContext((Command)command));
        ((CanvasCommandManager)Mockito.verify(this.canvasCommandManager, (VerificationMode)Mockito.never())).undo(Mockito.any(AbstractCanvasHandler.class), (Command)Mockito.any(AbstractCanvasGraphCommand.class));
    }
}

