/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.shape.view;

import com.ait.lienzo.client.core.shape.Attributes;
import com.ait.lienzo.client.core.types.BoundingBox;
import com.ait.lienzo.client.core.types.Point2D;
import com.ait.lienzo.client.core.types.Point2DArray;
import com.ait.lienzo.test.LienzoMockitoTestRunner;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.client.shape.view.DirectionalLine;
import org.mockito.Mockito;

@RunWith(value=LienzoMockitoTestRunner.class)
public class DirectionalLineTest {
    public static final Point2D P_START = new Point2D(0.0, 0.0);
    public static final Point2D P_END = new Point2D(15.5, 50.2);
    private DirectionalLine tested;

    @Before
    public void setup() {
        this.tested = new DirectionalLine(P_START, P_END);
    }

    @Test
    public void testBoundingBoxGeneration() throws Exception {
        BoundingBox bb1 = this.tested.getBoundingBox();
        Assert.assertEquals((double)0.0, (double)bb1.getMinX(), (double)0.0);
        Assert.assertEquals((double)0.0, (double)bb1.getMinY(), (double)0.0);
        Assert.assertEquals((double)15.5, (double)bb1.getMaxX(), (double)0.0);
        Assert.assertEquals((double)50.2, (double)bb1.getMaxY(), (double)0.0);
        this.tested.refresh();
        BoundingBox bb2 = this.tested.getBoundingBox();
        Assert.assertEquals((double)0.0, (double)bb2.getMinX(), (double)0.0);
        Assert.assertEquals((double)0.0, (double)bb2.getMinY(), (double)0.0);
        Assert.assertEquals((double)15.5, (double)bb2.getMaxX(), (double)0.0);
        Assert.assertEquals((double)50.2, (double)bb2.getMaxY(), (double)0.0);
    }

    @Test
    public void testParsePoints() throws Exception {
        Attributes attr = (Attributes)Mockito.mock(Attributes.class);
        Point2DArray points = new Point2DArray(0.0, 0.0).push(20.0, 30.0);
        Mockito.when((Object)attr.getControlPoints()).thenReturn((Object)points);
        boolean parsed = this.tested.parse(attr);
        Assert.assertTrue((boolean)parsed);
    }

    @Test
    public void testStkipParse() throws Exception {
        Attributes attr = (Attributes)Mockito.mock(Attributes.class);
        Point2DArray points = new Point2DArray();
        Mockito.when((Object)attr.getControlPoints()).thenReturn((Object)points);
        boolean parsed = this.tested.parse(attr);
        Assert.assertFalse((boolean)parsed);
    }
}

