/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.widgets.grid;

import com.ait.lienzo.client.core.shape.Node;
import com.ait.lienzo.client.core.shape.Viewport;
import com.ait.lienzo.test.LienzoMockitoTestRunner;
import java.util.Arrays;
import java.util.Optional;
import javax.enterprise.event.Event;
import org.jboss.errai.common.client.api.IsElement;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.definition.HasExpression;
import org.kie.workbench.common.dmn.api.definition.HasName;
import org.kie.workbench.common.dmn.api.definition.v1_1.LiteralExpression;
import org.kie.workbench.common.dmn.client.events.ExpressionEditorSelectedEvent;
import org.kie.workbench.common.dmn.client.widgets.grid.BaseExpressionGrid;
import org.kie.workbench.common.dmn.client.widgets.grid.model.BaseUIModelMapper;
import org.kie.workbench.common.dmn.client.widgets.grid.model.GridCellTuple;
import org.kie.workbench.common.dmn.client.widgets.layer.DMNGridLayer;
import org.kie.workbench.common.dmn.client.widgets.panel.DMNGridPanel;
import org.kie.workbench.common.stunner.core.client.api.SessionManager;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.command.SessionCommandManager;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.grids.GridRenderer;
import org.uberfire.mocks.EventSourceMock;

@RunWith(value=LienzoMockitoTestRunner.class)
public class BaseExpressionGridTest {
    @Mock
    private GridRenderer renderer;
    @Mock
    private DMNGridPanel gridPanel;
    @Mock
    private DMNGridLayer gridLayer;
    @Mock
    private Viewport viewport;
    @Mock
    private SessionManager sessionManager;
    @Mock
    private SessionCommandManager<AbstractCanvasHandler> sessionCommandManager;
    @Mock
    private EventSourceMock<ExpressionEditorSelectedEvent> editorSelectedEvent;
    @Mock
    private BaseUIModelMapper mapper;
    @Mock
    private Node gridParent;
    private BaseExpressionGrid grid;

    @Before
    public void setup() {
        GridCellTuple parent = new GridCellTuple(0, 0, null);
        HasExpression hasExpression = (HasExpression)Mockito.mock(HasExpression.class);
        Optional<Object> expression = Optional.of(Mockito.mock(LiteralExpression.class));
        Optional<Object> hasName = Optional.of(Mockito.mock(HasName.class));
        this.grid = (BaseExpressionGrid)Mockito.spy((Object)new BaseExpressionGrid(parent, hasExpression, expression, hasName, this.gridPanel, this.gridLayer, this.renderer, this.sessionManager, (SessionCommandManager)this.sessionCommandManager, (Event)this.editorSelectedEvent){

            protected BaseUIModelMapper makeUiModelMapper() {
                return BaseExpressionGridTest.this.mapper;
            }

            protected void initialiseUiColumns() {
            }

            protected void initialiseUiModel() {
            }

            public Optional<IsElement> getEditorControls() {
                return Optional.empty();
            }
        });
        ((DMNGridLayer)Mockito.doReturn((Object)this.viewport).when((Object)this.gridLayer)).getViewport();
    }

    @Test
    public void testGetMinimumWidthNoColumns() {
        this.assertMinimumWidth(0.0, new MockColumnData[0]);
        this.grid.getMinimumWidth();
    }

    @Test
    public void testGetMinimumWidthOneColumn() {
        double COL_0_MIN = 100.0;
        this.assertMinimumWidth(100.0, new MockColumnData(200.0, 100.0));
    }

    @Test
    public void testGetMinimumWidthTwoColumns() {
        double COL_0_ACTUAL = 200.0;
        double COL_1_MIN = 150.0;
        this.assertMinimumWidth(350.0, new MockColumnData(200.0, 100.0), new MockColumnData(225.0, 150.0));
    }

    @Test
    public void testGetMinimumWidthMultipleColumns() {
        double COL_0_ACTUAL = 50.0;
        double COL_1_ACTUAL = 65.0;
        double COL_2_MIN = 150.0;
        this.assertMinimumWidth(265.0, new MockColumnData(50.0, 25.0), new MockColumnData(65.0, 35.0), new MockColumnData(225.0, 150.0));
    }

    @Test
    public void testGetViewportGridAttachedToLayer() {
        ((BaseExpressionGrid)Mockito.doReturn((Object)this.gridParent).when((Object)this.grid)).getParent();
        ((Node)Mockito.doReturn((Object)this.viewport).when((Object)this.gridParent)).getViewport();
        Assert.assertEquals((Object)this.viewport, (Object)this.grid.getViewport());
    }

    @Test
    public void testGetViewportGridNotAttachedToLayer() {
        Assert.assertEquals((Object)this.viewport, (Object)this.grid.getViewport());
    }

    @Test
    public void testGetLayerGridAttachedToLayer() {
        ((BaseExpressionGrid)Mockito.doReturn((Object)this.gridParent).when((Object)this.grid)).getParent();
        ((Node)Mockito.doReturn((Object)this.gridLayer).when((Object)this.gridParent)).getLayer();
        Assert.assertEquals((Object)this.gridLayer, (Object)this.grid.getLayer());
    }

    @Test
    public void testGetLayerGridNotAttachedToLayer() {
        Assert.assertEquals((Object)this.gridLayer, (Object)this.grid.getLayer());
    }

    private void assertMinimumWidth(double expectedMinimumWidth, MockColumnData ... columnData) {
        Arrays.asList(columnData).forEach(cd -> {
            GridColumn uiColumn = (GridColumn)Mockito.mock(GridColumn.class);
            ((GridColumn)Mockito.doReturn((Object)((MockColumnData)cd).width).when((Object)uiColumn)).getWidth();
            ((GridColumn)Mockito.doReturn((Object)((MockColumnData)cd).minWidth).when((Object)uiColumn)).getMinimumWidth();
            this.grid.getModel().appendColumn(uiColumn);
        });
        Assert.assertEquals((double)expectedMinimumWidth, (double)this.grid.getMinimumWidth(), (double)0.0);
    }

    private static class MockColumnData {
        private double width;
        private double minWidth;

        public MockColumnData(double width, double minWidth) {
            this.width = width;
            this.minWidth = minWidth;
        }
    }
}

