/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.widgets.grid.columns;

import com.google.gwt.user.client.ui.Focusable;
import com.google.gwt.user.client.ui.HasValue;
import com.google.gwt.user.client.ui.Widget;
import org.junit.Before;
import org.junit.Test;
import org.kie.workbench.common.dmn.client.widgets.grid.BaseExpressionGrid;
import org.kie.workbench.common.dmn.client.widgets.grid.model.DMNGridData;
import org.kie.workbench.common.dmn.client.widgets.layer.DMNGridLayer;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.uberfire.client.callbacks.Callback;
import org.uberfire.ext.wires.core.grids.client.model.GridCell;
import org.uberfire.ext.wires.core.grids.client.model.GridCellValue;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.model.GridData;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridCell;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridCellValue;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridColumn;
import org.uberfire.ext.wires.core.grids.client.widget.context.GridBodyCellRenderContext;
import org.uberfire.ext.wires.core.grids.client.widget.dom.HasDOMElementResources;
import org.uberfire.ext.wires.core.grids.client.widget.dom.impl.BaseDOMElement;
import org.uberfire.ext.wires.core.grids.client.widget.dom.single.HasSingletonDOMElementResource;
import org.uberfire.ext.wires.core.grids.client.widget.dom.single.impl.BaseSingletonDOMElementFactory;

public abstract class BaseDOMElementSingletonColumnTest<F extends BaseSingletonDOMElementFactory, D extends BaseDOMElement, W extends Widget & Focusable, C extends BaseGridColumn, G extends BaseExpressionGrid> {
    @Mock
    protected GridColumn.HeaderMetaData headerMetaData;
    @Mock
    protected GridBodyCellRenderContext context;
    @Mock
    protected DMNGridLayer gridLayer;
    @Captor
    protected ArgumentCaptor<Callback<D>> domElementOnCreationCallbackCaptor;
    @Captor
    protected ArgumentCaptor<Callback<D>> domElementOnDisplayCallbackCaptor;
    protected GridData model;
    protected F factory;
    protected D domElement;
    protected W widget;
    protected G gridWidget;
    protected C column;

    @Before
    public void setup() {
        this.model = new DMNGridData(this.gridLayer);
        this.factory = this.getFactory();
        this.domElement = this.getDomElement();
        this.widget = this.getWidget();
        this.gridWidget = this.getGridWidget();
        this.column = this.getColumn();
        Mockito.when((Object)this.domElement.getWidget()).thenReturn(this.widget);
        Mockito.when((Object)this.gridWidget.getModel()).thenReturn((Object)this.model);
    }

    protected abstract F getFactory();

    protected abstract D getDomElement();

    protected abstract W getWidget();

    protected abstract G getGridWidget();

    protected abstract C getColumn();

    @Test
    public void checkEdit() {
        BaseGridCell cell = new BaseGridCell((GridCellValue)new BaseGridCellValue((Object)"value"));
        this.column.edit((GridCell)cell, this.context, result -> {});
        ((BaseSingletonDOMElementFactory)Mockito.verify(this.factory)).attachDomElement((GridBodyCellRenderContext)Matchers.eq((Object)this.context), (Callback)this.domElementOnCreationCallbackCaptor.capture(), (Callback)this.domElementOnDisplayCallbackCaptor.capture());
        Callback domElementOnCreationCallback = (Callback)this.domElementOnCreationCallbackCaptor.getValue();
        domElementOnCreationCallback.callback(this.domElement);
        ((HasValue)((Widget)Mockito.verify(this.widget))).setValue(Matchers.eq((Object)"value"));
        Callback domElementOnDisplayCallback = (Callback)this.domElementOnDisplayCallbackCaptor.getValue();
        domElementOnDisplayCallback.callback(this.domElement);
        ((Focusable)((Widget)Mockito.verify(this.widget))).setFocus(Matchers.eq((boolean)true));
    }

    @Test
    public void checkFlushFactory() {
        ((HasSingletonDOMElementResource)this.column).flush();
        ((BaseSingletonDOMElementFactory)Mockito.verify(this.factory)).flush();
    }

    @Test
    public void checkDestroyFactoryResources() {
        ((HasDOMElementResources)this.column).destroyResources();
        ((BaseSingletonDOMElementFactory)Mockito.verify(this.factory)).destroyResources();
    }
}

