/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.widgets.grid.columns;

import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.gwtbootstrap3.client.ui.TextBox;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.api.definition.HasName;
import org.kie.workbench.common.dmn.api.property.dmn.Name;
import org.kie.workbench.common.dmn.client.widgets.grid.columns.EditableHeaderMetaData;
import org.kie.workbench.common.dmn.client.widgets.grid.columns.factory.dom.TextBoxDOMElement;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.uberfire.ext.wires.core.grids.client.widget.dom.single.SingletonDOMElementFactory;

@RunWith(value=MockitoJUnitRunner.class)
public class EditableHeaderMetaDataTest {
    @Mock
    private SingletonDOMElementFactory<TextBox, TextBoxDOMElement> factory;
    private Optional<HasName> hasName = Optional.empty();
    private EditableHeaderMetaData header;

    @Before
    public void setup() {
        this.header = new MockEditableHeaderMetaData(() -> this.hasName.orElse(HasName.NOP).getName().getValue(), s -> this.hasName.orElse(HasName.NOP).getName().setValue(s), this.factory);
    }

    @Test
    public void checkGetTitleWithHasName() {
        this.hasName = Optional.of(new MockHasName("name"));
        Assert.assertEquals((Object)"name", (Object)this.header.getTitle());
    }

    @Test
    public void checkGetTitleWithoutHasName() {
        this.hasName = Optional.empty();
        Assert.assertEquals((Object)"", (Object)this.header.getTitle());
    }

    @Test
    public void checkSetTitleWithHasName() {
        MockHasName mockHasName = new MockHasName("name");
        this.hasName = Optional.of(mockHasName);
        this.header.setTitle("new-name");
        Assert.assertEquals((Object)"new-name", (Object)mockHasName.getName().getValue());
    }

    @Test
    public void checkSetTitleWithoutHasName() {
        MockHasName mockHasName = new MockHasName("name");
        this.hasName = Optional.empty();
        this.header.setTitle("new-name");
        Assert.assertEquals((Object)"name", (Object)mockHasName.getName().getValue());
    }

    @Test
    public void checkFactoryResourcesAreDestroyed() {
        this.header.destroyResources();
        ((SingletonDOMElementFactory)Mockito.verify(this.factory)).destroyResources();
    }

    private static class MockHasName
    implements HasName {
        private Name name;

        MockHasName(String name) {
            this.name = new Name(name);
        }

        public Name getName() {
            return this.name;
        }

        public void setName(Name name) {
            this.name = name;
        }
    }

    private static class MockEditableHeaderMetaData
    extends EditableHeaderMetaData<TextBox, TextBoxDOMElement> {
        public MockEditableHeaderMetaData(Supplier<String> titleGetter, Consumer<String> titleSetter, SingletonDOMElementFactory<TextBox, TextBoxDOMElement> factory) {
            super(titleGetter, titleSetter, factory);
        }
    }
}

