/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.widgets.grid.columns;

import com.ait.lienzo.client.core.shape.Viewport;
import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.client.widgets.grid.columns.EditableHeaderUtilities;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.widget.context.GridBodyCellRenderContext;
import org.uberfire.ext.wires.core.grids.client.widget.grid.GridWidget;
import org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.grids.GridRenderer;
import org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.grids.impl.BaseGridRendererHelper;

@RunWith(value=MockitoJUnitRunner.class)
public class EditableHeaderUtilitiesTest {
    private static final double HEADER_HEIGHT = 50.0;
    private static final double HEADER_ROW_HEIGHT = 25.0;
    @Mock
    private GridWidget gridWidget;
    @Mock
    private GridRenderer gridRenderer;
    @Mock
    private BaseGridRendererHelper gridRendererHelper;
    @Mock
    private BaseGridRendererHelper.RenderingInformation ri;
    @Mock
    private BaseGridRendererHelper.ColumnInformation ci;
    @Mock
    private BaseGridRendererHelper.RenderingBlockInformation floatingBlockInformation;

    @Before
    public void setup() {
        ((GridWidget)Mockito.doReturn((Object)this.gridRenderer).when((Object)this.gridWidget)).getRenderer();
        ((GridWidget)Mockito.doReturn((Object)this.gridRendererHelper).when((Object)this.gridWidget)).getRendererHelper();
        ((BaseGridRendererHelper)Mockito.doReturn((Object)this.ri).when((Object)this.gridRendererHelper)).getRenderingInformation();
        ((GridRenderer)Mockito.doReturn((Object)50.0).when((Object)this.gridRenderer)).getHeaderHeight();
        ((GridRenderer)Mockito.doReturn((Object)50.0).when((Object)this.gridRenderer)).getHeaderRowHeight();
        ((BaseGridRendererHelper.RenderingInformation)Mockito.doReturn((Object)this.floatingBlockInformation).when((Object)this.ri)).getFloatingBlockInformation();
        ((BaseGridRendererHelper.RenderingBlockInformation)Mockito.doReturn((Object)0.0).when((Object)this.floatingBlockInformation)).getX();
        ((BaseGridRendererHelper.RenderingBlockInformation)Mockito.doReturn((Object)0.0).when((Object)this.floatingBlockInformation)).getWidth();
        ((GridWidget)Mockito.doReturn((Object)Mockito.mock(Viewport.class)).when((Object)this.gridWidget)).getViewport();
    }

    @Test
    public void testGetUiHeaderRowIndexHeaderMinY() {
        GridColumn<?> uiColumn = this.mockGridColumn(100.0);
        Integer uiHeaderRowIndex = EditableHeaderUtilities.getUiHeaderRowIndex((GridWidget)this.gridWidget, uiColumn, (double)-5.0);
        Assert.assertNull((Object)uiHeaderRowIndex);
    }

    @Test
    public void testGetUiHeaderRowIndexHeaderMaxY() {
        GridColumn<?> uiColumn = this.mockGridColumn(100.0);
        Integer uiHeaderRowIndex = EditableHeaderUtilities.getUiHeaderRowIndex((GridWidget)this.gridWidget, uiColumn, (double)55.0);
        Assert.assertNull((Object)uiHeaderRowIndex);
    }

    @Test
    public void testGetUiHeaderRowIndexRow0() {
        GridColumn<?> uiColumn = this.mockGridColumn(100.0);
        Integer uiHeaderRowIndex = EditableHeaderUtilities.getUiHeaderRowIndex((GridWidget)this.gridWidget, uiColumn, (double)20.0);
        Assert.assertNotNull((Object)uiHeaderRowIndex);
        Assert.assertEquals((long)0L, (long)uiHeaderRowIndex.intValue());
    }

    @Test
    public void testGetUiHeaderRowIndexRow1() {
        GridColumn<?> uiColumn = this.mockGridColumn(100.0);
        Integer uiHeaderRowIndex = EditableHeaderUtilities.getUiHeaderRowIndex((GridWidget)this.gridWidget, uiColumn, (double)30.0);
        Assert.assertNotNull((Object)uiHeaderRowIndex);
        Assert.assertEquals((long)1L, (long)uiHeaderRowIndex.intValue());
    }

    @Test
    public void testMakeRenderContextNoBlock() {
        ArrayList allColumns = new ArrayList();
        GridColumn<?> uiColumn = this.mockGridColumn(100.0);
        allColumns.add(uiColumn);
        ((BaseGridRendererHelper.RenderingInformation)Mockito.doReturn(allColumns).when((Object)this.ri)).getAllColumns();
        ((BaseGridRendererHelper.ColumnInformation)Mockito.doReturn(uiColumn).when((Object)this.ci)).getColumn();
        ((BaseGridRendererHelper.ColumnInformation)Mockito.doReturn((Object)0.0).when((Object)this.ci)).getOffsetX();
        ((BaseGridRendererHelper.ColumnInformation)Mockito.doReturn((Object)0).when((Object)this.ci)).getUiColumnIndex();
        GridBodyCellRenderContext context = EditableHeaderUtilities.makeRenderContext((GridWidget)this.gridWidget, (BaseGridRendererHelper.RenderingInformation)this.ri, (BaseGridRendererHelper.ColumnInformation)this.ci, (int)0);
        Assert.assertNotNull((Object)context);
        Assert.assertEquals((double)0.0, (double)context.getAbsoluteCellX(), (double)0.0);
        Assert.assertEquals((double)100.0, (double)context.getCellWidth(), (double)0.0);
    }

    @Test
    public void testMakeRenderContextNoBlockMultipleColumns() {
        ArrayList allColumns = new ArrayList();
        GridColumn<?> uiColumn1 = this.mockGridColumn(25.0);
        GridColumn<?> uiColumn2 = this.mockGridColumn(50.0);
        GridColumn<?> uiColumn3 = this.mockGridColumn(100.0);
        allColumns.add(uiColumn1);
        allColumns.add(uiColumn2);
        allColumns.add(uiColumn3);
        ((BaseGridRendererHelper.RenderingInformation)Mockito.doReturn(allColumns).when((Object)this.ri)).getAllColumns();
        ((BaseGridRendererHelper.ColumnInformation)Mockito.doReturn(uiColumn2).when((Object)this.ci)).getColumn();
        ((BaseGridRendererHelper.ColumnInformation)Mockito.doReturn((Object)25.0).when((Object)this.ci)).getOffsetX();
        ((BaseGridRendererHelper.ColumnInformation)Mockito.doReturn((Object)1).when((Object)this.ci)).getUiColumnIndex();
        GridBodyCellRenderContext context = EditableHeaderUtilities.makeRenderContext((GridWidget)this.gridWidget, (BaseGridRendererHelper.RenderingInformation)this.ri, (BaseGridRendererHelper.ColumnInformation)this.ci, (int)0);
        Assert.assertNotNull((Object)context);
        Assert.assertEquals((double)25.0, (double)context.getAbsoluteCellX(), (double)0.0);
        Assert.assertEquals((double)50.0, (double)context.getCellWidth(), (double)0.0);
    }

    @Test
    public void testMakeRenderContextLeadBlock() {
        ArrayList allColumns = new ArrayList();
        GridColumn<?> uiColumn1 = this.mockGridColumn(25.0);
        GridColumn<?> uiColumn2 = this.mockGridColumn(50.0, uiColumn1.getHeaderMetaData());
        allColumns.add(uiColumn1);
        allColumns.add(uiColumn2);
        ((BaseGridRendererHelper.RenderingInformation)Mockito.doReturn(allColumns).when((Object)this.ri)).getAllColumns();
        ((BaseGridRendererHelper.ColumnInformation)Mockito.doReturn(uiColumn2).when((Object)this.ci)).getColumn();
        ((BaseGridRendererHelper.ColumnInformation)Mockito.doReturn((Object)25.0).when((Object)this.ci)).getOffsetX();
        ((BaseGridRendererHelper.ColumnInformation)Mockito.doReturn((Object)1).when((Object)this.ci)).getUiColumnIndex();
        GridBodyCellRenderContext context = EditableHeaderUtilities.makeRenderContext((GridWidget)this.gridWidget, (BaseGridRendererHelper.RenderingInformation)this.ri, (BaseGridRendererHelper.ColumnInformation)this.ci, (int)0);
        Assert.assertNotNull((Object)context);
        Assert.assertEquals((double)0.0, (double)context.getAbsoluteCellX(), (double)0.0);
        Assert.assertEquals((double)75.0, (double)context.getCellWidth(), (double)0.0);
    }

    @Test
    public void testMakeRenderContextLeadBlockWithExtraLeadNonBlockColumn() {
        ArrayList allColumns = new ArrayList();
        GridColumn<?> uiColumn1 = this.mockGridColumn(25.0);
        GridColumn<?> uiColumn2 = this.mockGridColumn(50.0);
        GridColumn<?> uiColumn3 = this.mockGridColumn(75.0, uiColumn2.getHeaderMetaData());
        allColumns.add(uiColumn1);
        allColumns.add(uiColumn2);
        allColumns.add(uiColumn3);
        ((BaseGridRendererHelper.RenderingInformation)Mockito.doReturn(allColumns).when((Object)this.ri)).getAllColumns();
        ((BaseGridRendererHelper.ColumnInformation)Mockito.doReturn(uiColumn3).when((Object)this.ci)).getColumn();
        ((BaseGridRendererHelper.ColumnInformation)Mockito.doReturn((Object)75.0).when((Object)this.ci)).getOffsetX();
        ((BaseGridRendererHelper.ColumnInformation)Mockito.doReturn((Object)2).when((Object)this.ci)).getUiColumnIndex();
        GridBodyCellRenderContext context = EditableHeaderUtilities.makeRenderContext((GridWidget)this.gridWidget, (BaseGridRendererHelper.RenderingInformation)this.ri, (BaseGridRendererHelper.ColumnInformation)this.ci, (int)0);
        Assert.assertNotNull((Object)context);
        Assert.assertEquals((double)25.0, (double)context.getAbsoluteCellX(), (double)0.0);
        Assert.assertEquals((double)125.0, (double)context.getCellWidth(), (double)0.0);
    }

    @Test
    public void testMakeRenderContextTailBlock() {
        ArrayList allColumns = new ArrayList();
        GridColumn<?> uiColumn1 = this.mockGridColumn(25.0);
        GridColumn<?> uiColumn2 = this.mockGridColumn(50.0, uiColumn1.getHeaderMetaData());
        allColumns.add(uiColumn1);
        allColumns.add(uiColumn2);
        ((BaseGridRendererHelper.RenderingInformation)Mockito.doReturn(allColumns).when((Object)this.ri)).getAllColumns();
        ((BaseGridRendererHelper.ColumnInformation)Mockito.doReturn(uiColumn1).when((Object)this.ci)).getColumn();
        ((BaseGridRendererHelper.ColumnInformation)Mockito.doReturn((Object)0.0).when((Object)this.ci)).getOffsetX();
        ((BaseGridRendererHelper.ColumnInformation)Mockito.doReturn((Object)0).when((Object)this.ci)).getUiColumnIndex();
        GridBodyCellRenderContext context = EditableHeaderUtilities.makeRenderContext((GridWidget)this.gridWidget, (BaseGridRendererHelper.RenderingInformation)this.ri, (BaseGridRendererHelper.ColumnInformation)this.ci, (int)0);
        Assert.assertNotNull((Object)context);
        Assert.assertEquals((double)0.0, (double)context.getAbsoluteCellX(), (double)0.0);
        Assert.assertEquals((double)75.0, (double)context.getCellWidth(), (double)0.0);
    }

    @Test
    public void testMakeRenderContextTailBlockWithExtraTailNonBlockColumn() {
        ArrayList allColumns = new ArrayList();
        GridColumn<?> uiColumn1 = this.mockGridColumn(25.0);
        GridColumn<?> uiColumn2 = this.mockGridColumn(50.0, uiColumn1.getHeaderMetaData());
        GridColumn<?> uiColumn3 = this.mockGridColumn(100.0);
        allColumns.add(uiColumn1);
        allColumns.add(uiColumn2);
        allColumns.add(uiColumn3);
        ((BaseGridRendererHelper.RenderingInformation)Mockito.doReturn(allColumns).when((Object)this.ri)).getAllColumns();
        ((BaseGridRendererHelper.ColumnInformation)Mockito.doReturn(uiColumn1).when((Object)this.ci)).getColumn();
        ((BaseGridRendererHelper.ColumnInformation)Mockito.doReturn((Object)0.0).when((Object)this.ci)).getOffsetX();
        ((BaseGridRendererHelper.ColumnInformation)Mockito.doReturn((Object)0).when((Object)this.ci)).getUiColumnIndex();
        GridBodyCellRenderContext context = EditableHeaderUtilities.makeRenderContext((GridWidget)this.gridWidget, (BaseGridRendererHelper.RenderingInformation)this.ri, (BaseGridRendererHelper.ColumnInformation)this.ci, (int)0);
        Assert.assertNotNull((Object)context);
        Assert.assertEquals((double)0.0, (double)context.getAbsoluteCellX(), (double)0.0);
        Assert.assertEquals((double)75.0, (double)context.getCellWidth(), (double)0.0);
    }

    private GridColumn<?> mockGridColumn(double width) {
        ArrayList<GridColumn.HeaderMetaData> headerMetaData = new ArrayList<GridColumn.HeaderMetaData>();
        headerMetaData.add((GridColumn.HeaderMetaData)Mockito.mock(GridColumn.HeaderMetaData.class));
        headerMetaData.add((GridColumn.HeaderMetaData)Mockito.mock(GridColumn.HeaderMetaData.class));
        return this.mockGridColumn(width, headerMetaData);
    }

    private GridColumn<?> mockGridColumn(double width, List<GridColumn.HeaderMetaData> headerMetaData) {
        GridColumn uiColumn = (GridColumn)Mockito.mock(GridColumn.class);
        ((GridColumn)Mockito.doReturn(headerMetaData).when((Object)uiColumn)).getHeaderMetaData();
        ((GridColumn)Mockito.doReturn((Object)width).when((Object)uiColumn)).getWidth();
        return uiColumn;
    }
}

