/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.widgets.grid.columns.factory.dom;

import com.google.gwt.dom.client.Style;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.ui.Widget;
import java.util.Optional;
import java.util.function.Supplier;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.workbench.common.dmn.client.commands.general.DeleteCellValueCommand;
import org.kie.workbench.common.dmn.client.commands.general.SetCellValueCommand;
import org.kie.workbench.common.dmn.client.widgets.grid.model.BaseUIModelMapper;
import org.kie.workbench.common.stunner.core.client.api.SessionManager;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.command.SessionCommandManager;
import org.kie.workbench.common.stunner.core.client.session.impl.AbstractClientSession;
import org.kie.workbench.common.stunner.core.command.Command;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommandExecutionContext;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.uberfire.ext.wires.core.grids.client.model.GridCellValue;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridData;
import org.uberfire.ext.wires.core.grids.client.widget.context.GridBodyCellRenderContext;
import org.uberfire.ext.wires.core.grids.client.widget.dom.impl.BaseDOMElement;
import org.uberfire.ext.wires.core.grids.client.widget.grid.GridWidget;
import org.uberfire.ext.wires.core.grids.client.widget.layer.GridLayer;

public abstract class BaseDOMElementTest<W extends Widget, D extends BaseDOMElement> {
    @Mock
    private Element widgetElement;
    @Mock
    private Style widgetElementStyle;
    @Mock
    private AbstractClientSession session;
    @Mock
    private AbstractCanvasHandler canvasHandler;
    @Mock
    private GridBodyCellRenderContext context;
    @Mock
    private GraphCommandExecutionContext graphCommandExecutionContext;
    @Captor
    private ArgumentCaptor<SetCellValueCommand> setCellValueCommandArgumentCaptor;
    @Captor
    private ArgumentCaptor<DeleteCellValueCommand> deleteCellValueCommandArgumentCaptor;
    @Captor
    private ArgumentCaptor<Supplier<Optional<GridCellValue<?>>>> valueSupplierArgumentCaptor;
    @Mock
    protected GridLayer gridLayer;
    @Mock
    protected GridWidget gridWidget;
    @Mock
    protected SessionManager sessionManager;
    @Mock
    protected SessionCommandManager<AbstractCanvasHandler> sessionCommandManager;
    @Mock
    protected BaseUIModelMapper<?> uiModelMapper;
    protected W widget;
    private D domElement;

    @Before
    public void setup() {
        this.widget = this.getWidget();
        Mockito.when((Object)this.widget.getElement()).thenReturn((Object)this.widgetElement);
        Mockito.when((Object)this.widgetElement.getStyle()).thenReturn((Object)this.widgetElementStyle);
        Mockito.when((Object)this.sessionManager.getCurrentSession()).thenReturn((Object)this.session);
        Mockito.when((Object)this.session.getCanvasHandler()).thenReturn((Object)this.canvasHandler);
        Mockito.when((Object)this.context.getRowIndex()).thenReturn((Object)0);
        Mockito.when((Object)this.context.getColumnIndex()).thenReturn((Object)1);
        Mockito.when((Object)this.gridWidget.getModel()).thenReturn((Object)new BaseGridData());
        this.domElement = this.getDomElement();
        this.domElement.setContext(this.context);
    }

    @Test
    public void checkFlushWithValue() {
        this.domElement.flush((Object)"value");
        ((SessionCommandManager)Mockito.verify(this.sessionCommandManager)).execute(Mockito.eq((Object)this.canvasHandler), (Command)this.setCellValueCommandArgumentCaptor.capture());
        SetCellValueCommand command = (SetCellValueCommand)this.setCellValueCommandArgumentCaptor.getValue();
        command.getGraphCommand(this.canvasHandler).execute((Object)this.graphCommandExecutionContext);
        ((BaseUIModelMapper)Mockito.verify(this.uiModelMapper)).toDMNModel(Mockito.eq((int)0), Mockito.eq((int)1), (Supplier)this.valueSupplierArgumentCaptor.capture());
        Supplier valueSupplier = (Supplier)this.valueSupplierArgumentCaptor.getValue();
        Assert.assertTrue((boolean)((Optional)valueSupplier.get()).isPresent());
        Assert.assertEquals((Object)"value", (Object)((GridCellValue)((Optional)valueSupplier.get()).get()).getValue().toString());
    }

    @Test
    public void checkFlushWithoutValue() {
        this.domElement.flush((Object)"");
        ((SessionCommandManager)Mockito.verify(this.sessionCommandManager)).execute(Mockito.eq((Object)this.canvasHandler), (Command)this.deleteCellValueCommandArgumentCaptor.capture());
        DeleteCellValueCommand command = (DeleteCellValueCommand)this.deleteCellValueCommandArgumentCaptor.getValue();
        command.getGraphCommand(this.canvasHandler).execute((Object)this.graphCommandExecutionContext);
        ((BaseUIModelMapper)Mockito.verify(this.uiModelMapper)).toDMNModel(Mockito.eq((int)0), Mockito.eq((int)1), (Supplier)this.valueSupplierArgumentCaptor.capture());
        Supplier valueSupplier = (Supplier)this.valueSupplierArgumentCaptor.getValue();
        Assert.assertFalse((boolean)((Optional)valueSupplier.get()).isPresent());
    }

    protected abstract W getWidget();

    protected abstract D getDomElement();
}

