/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.widgets.grid.model;

import com.ait.lienzo.test.LienzoMockitoTestRunner;
import java.util.HashMap;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.client.editors.expressions.types.context.ExpressionCellValue;
import org.kie.workbench.common.dmn.client.widgets.grid.BaseExpressionGrid;
import org.kie.workbench.common.dmn.client.widgets.grid.model.DMNGridRow;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.uberfire.ext.wires.core.grids.client.model.GridCell;
import org.uberfire.ext.wires.core.grids.client.model.GridCellValue;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridCell;

@RunWith(value=LienzoMockitoTestRunner.class)
public class DMNGridRowTest {
    @Mock
    private BaseExpressionGrid view;

    @Test
    public void testEmptyRow() throws Exception {
        DMNGridRow row = new DMNGridRow();
        Assertions.assertThat((double)row.getHeight()).isEqualTo(100.0);
    }

    @Test
    public void testRowNoHigherThanDefault() throws Exception {
        DMNGridRow row = (DMNGridRow)Mockito.spy(DMNGridRow.class);
        HashMap<Integer, GridCell> cells = new HashMap<Integer, GridCell>(){
            {
                ((BaseExpressionGrid)Mockito.doReturn((Object)99.0).when((Object)DMNGridRowTest.this.view)).getHeight();
                this.put(0, new BaseGridCell((GridCellValue)new ExpressionCellValue(Optional.of(DMNGridRowTest.this.view))));
            }
        };
        ((DMNGridRow)Mockito.doReturn((Object)cells).when((Object)row)).getCells();
        Assertions.assertThat((double)row.getHeight()).isBetween(Double.valueOf(0.0), Double.valueOf(100.0));
    }

    @Test
    public void testRowHigherThanDefault() throws Exception {
        DMNGridRow row = (DMNGridRow)Mockito.spy(DMNGridRow.class);
        HashMap<Integer, GridCell> cells = new HashMap<Integer, GridCell>(){
            {
                ((BaseExpressionGrid)Mockito.doReturn((Object)101.0).when((Object)DMNGridRowTest.this.view)).getHeight();
                this.put(0, new BaseGridCell((GridCellValue)new ExpressionCellValue(Optional.of(DMNGridRowTest.this.view))));
            }
        };
        ((DMNGridRow)Mockito.doReturn((Object)cells).when((Object)row)).getCells();
        Assertions.assertThat((double)row.getHeight()).isGreaterThan(100.0);
    }
}

