/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.widgets.grid.model;

import com.ait.lienzo.test.LienzoMockitoTestRunner;
import java.util.Collections;
import java.util.List;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.dmn.client.widgets.grid.model.DMNGridData;
import org.kie.workbench.common.dmn.client.widgets.grid.model.DelegatingGridData;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.uberfire.ext.wires.core.grids.client.model.GridCellValue;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.model.GridRow;

@RunWith(value=LienzoMockitoTestRunner.class)
public class DelegatingGridDataTest {
    @Mock
    private GridRow gridRow;
    @Mock
    private GridColumn gridColumn;
    @Mock
    private GridCellValue gridCellValue;
    @Mock
    private DMNGridData delegate;
    private DelegatingGridData uiModel;

    @Before
    public void setup() {
        this.uiModel = new DelegatingGridData(this.delegate);
    }

    @Test
    public void testMoveRowTo() {
        this.uiModel.moveRowTo(0, this.gridRow);
        ((DMNGridData)Mockito.verify((Object)this.delegate)).moveRowTo(Matchers.eq((int)0), (GridRow)Matchers.eq((Object)this.gridRow));
    }

    @Test
    public void testMoveRowsTo() {
        List<GridRow> gridRows = Collections.singletonList(this.gridRow);
        this.uiModel.moveRowsTo(0, gridRows);
        ((DMNGridData)Mockito.verify((Object)this.delegate)).moveRowsTo(Matchers.eq((int)0), (List)Matchers.eq(gridRows));
    }

    @Test
    public void testDelegateMoveColumnTo() {
        this.uiModel.moveColumnTo(1, this.gridColumn);
        ((DMNGridData)Mockito.verify((Object)this.delegate)).moveColumnTo(Matchers.eq((int)1), (GridColumn)Matchers.eq((Object)this.gridColumn));
    }

    @Test
    public void testDelegateMoveColumnsTo() {
        List<GridColumn> gridColumns = Collections.singletonList(this.gridColumn);
        this.uiModel.moveColumnsTo(1, gridColumns);
        ((DMNGridData)Mockito.verify((Object)this.delegate)).moveColumnsTo(Matchers.eq((int)1), (List)Matchers.eq(gridColumns));
    }

    @Test
    public void testDelegateSelectCell() {
        this.uiModel.selectCell(0, 1);
        ((DMNGridData)Mockito.verify((Object)this.delegate)).selectCell(Matchers.eq((int)0), Matchers.eq((int)1));
    }

    @Test
    public void testDelegateSelectCells() {
        this.uiModel.selectCells(0, 1, 2, 3);
        ((DMNGridData)Mockito.verify((Object)this.delegate)).selectCells(Matchers.eq((int)0), Matchers.eq((int)1), Matchers.eq((int)2), Matchers.eq((int)3));
    }

    @Test
    public void testDelegateSetCell() {
        this.uiModel.setCell(0, 1, this.gridCellValue);
        ((DMNGridData)Mockito.verify((Object)this.delegate)).setCell(Matchers.eq((int)0), Matchers.eq((int)1), (GridCellValue)Matchers.eq((Object)this.gridCellValue));
    }

    @Test
    public void testDelegateDeleteCell() {
        this.uiModel.deleteCell(0, 1);
        ((DMNGridData)Mockito.verify((Object)this.delegate)).deleteCell(Matchers.eq((int)0), Matchers.eq((int)1));
    }

    @Test
    public void testDelegateGetColumns() {
        this.uiModel.getColumns();
        ((DMNGridData)Mockito.verify((Object)this.delegate)).getColumns();
    }

    @Test
    public void testDelegateGetColumnCount() {
        this.uiModel.getColumnCount();
        ((DMNGridData)Mockito.verify((Object)this.delegate)).getColumnCount();
    }

    @Test
    public void testDelegateAppendColumn() {
        this.uiModel.appendColumn(this.gridColumn);
        ((DMNGridData)Mockito.verify((Object)this.delegate)).appendColumn((GridColumn)Matchers.eq((Object)this.gridColumn));
    }

    @Test
    public void testDelegateInsertColumn() {
        this.uiModel.insertColumn(0, this.gridColumn);
        ((DMNGridData)Mockito.verify((Object)this.delegate)).insertColumn(Matchers.eq((int)0), (GridColumn)Matchers.eq((Object)this.gridColumn));
    }

    @Test
    public void testDelegateDeleteColumn() {
        this.uiModel.deleteColumn(this.gridColumn);
        ((DMNGridData)Mockito.verify((Object)this.delegate)).deleteColumn((GridColumn)Matchers.eq((Object)this.gridColumn));
    }

    @Test
    public void testDelegateGetRows() {
        this.uiModel.getRows();
        ((DMNGridData)Mockito.verify((Object)this.delegate)).getRows();
    }

    @Test
    public void testDelegateExpandCell() {
        this.uiModel.expandCell(0, 1);
        ((DMNGridData)Mockito.verify((Object)this.delegate)).expandCell(Matchers.eq((int)0), Matchers.eq((int)1));
    }

    @Test
    public void testDelegateCollapseCell() {
        this.uiModel.collapseCell(0, 1);
        ((DMNGridData)Mockito.verify((Object)this.delegate)).collapseCell(Matchers.eq((int)0), Matchers.eq((int)1));
    }

    @Test
    public void testDelegateSetColumnDraggingEnabled() {
        this.uiModel.setColumnDraggingEnabled(true);
        ((DMNGridData)Mockito.verify((Object)this.delegate)).setColumnDraggingEnabled(Matchers.eq((boolean)true));
    }

    @Test
    public void testDelegateIsColumnDraggingEnabled() {
        this.uiModel.isColumnDraggingEnabled();
        ((DMNGridData)Mockito.verify((Object)this.delegate)).isColumnDraggingEnabled();
    }

    @Test
    public void testDelegateSetRowDraggingEnabled() {
        this.uiModel.setRowDraggingEnabled(true);
        ((DMNGridData)Mockito.verify((Object)this.delegate)).setRowDraggingEnabled(Matchers.eq((boolean)true));
    }

    @Test
    public void testDelegateIsRowDraggingEnabled() {
        this.uiModel.isRowDraggingEnabled();
        ((DMNGridData)Mockito.verify((Object)this.delegate)).isRowDraggingEnabled();
    }

    @Test
    public void testDelegateSetMerged() {
        this.uiModel.setMerged(true);
        ((DMNGridData)Mockito.verify((Object)this.delegate)).setMerged(Matchers.eq((boolean)true));
    }

    @Test
    public void testDelegateIsMerged() {
        this.uiModel.isMerged();
        ((DMNGridData)Mockito.verify((Object)this.delegate)).isMerged();
    }

    @Test
    public void testDelegateUpdateColumn() {
        this.uiModel.updateColumn(0, this.gridColumn);
        ((DMNGridData)Mockito.verify((Object)this.delegate)).updateColumn(Matchers.eq((int)0), (GridColumn)Matchers.eq((Object)this.gridColumn));
    }

    @Test
    public void testDelegateClearSelections() {
        this.uiModel.clearSelections();
        ((DMNGridData)Mockito.verify((Object)this.delegate)).clearSelections();
    }

    @Test
    public void testDelegateGetSelectedCells() {
        this.uiModel.getSelectedCells();
        ((DMNGridData)Mockito.verify((Object)this.delegate)).getSelectedCells();
    }

    @Test
    public void testDelegateGetSelectedCellsOrigin() {
        this.uiModel.getSelectedCellsOrigin();
        ((DMNGridData)Mockito.verify((Object)this.delegate)).getSelectedCellsOrigin();
    }

    @Test
    public void testDelegateGetCell() {
        this.uiModel.getCell(0, 1);
        ((DMNGridData)Mockito.verify((Object)this.delegate)).getCell(Matchers.eq((int)0), Matchers.eq((int)1));
    }

    @Test
    public void testDelegateSetHeaderRowCount() {
        this.uiModel.setHeaderRowCount(1);
        ((DMNGridData)Mockito.verify((Object)this.delegate)).setHeaderRowCount(Matchers.eq((int)1));
    }

    @Test
    public void testDelegateGetHeaderRowCount() {
        this.uiModel.getHeaderRowCount();
        ((DMNGridData)Mockito.verify((Object)this.delegate)).getHeaderRowCount();
    }

    @Test
    public void testDelegateGetRowCount() {
        this.uiModel.getRowCount();
        ((DMNGridData)Mockito.verify((Object)this.delegate)).getRowCount();
    }

    @Test
    public void testDelegateDeleteRow() {
        this.uiModel.deleteRow(0);
        ((DMNGridData)Mockito.verify((Object)this.delegate)).deleteRow(Matchers.eq((int)0));
    }

    @Test
    public void testDelegateInsertRow() {
        this.uiModel.insertRow(0, this.gridRow);
        ((DMNGridData)Mockito.verify((Object)this.delegate)).insertRow(Matchers.eq((int)0), (GridRow)Matchers.eq((Object)this.gridRow));
    }

    @Test
    public void testDelegateAppendRow() {
        this.uiModel.appendRow(this.gridRow);
        ((DMNGridData)Mockito.verify((Object)this.delegate)).appendRow((GridRow)Matchers.eq((Object)this.gridRow));
    }

    @Test
    public void testDelegateGetRow() {
        this.uiModel.getRow(0);
        ((DMNGridData)Mockito.verify((Object)this.delegate)).getRow(Matchers.eq((int)0));
    }
}

