/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.commands.expressions.types.function;

import java.util.Map;
import java.util.Optional;
import org.kie.workbench.common.dmn.api.definition.v1_1.Expression;
import org.kie.workbench.common.dmn.api.definition.v1_1.FunctionDefinition;
import org.kie.workbench.common.dmn.client.commands.VetoExecutionCommand;
import org.kie.workbench.common.dmn.client.commands.VetoUndoCommand;
import org.kie.workbench.common.dmn.client.widgets.grid.model.GridCellValueTuple;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.command.AbstractCanvasCommand;
import org.kie.workbench.common.stunner.core.client.canvas.command.AbstractCanvasGraphCommand;
import org.kie.workbench.common.stunner.core.client.command.CanvasCommandResultBuilder;
import org.kie.workbench.common.stunner.core.client.command.CanvasViolation;
import org.kie.workbench.common.stunner.core.command.CommandResult;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommandExecutionContext;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommandResultBuilder;
import org.kie.workbench.common.stunner.core.graph.command.impl.AbstractGraphCommand;
import org.kie.workbench.common.stunner.core.rule.RuleViolation;
import org.uberfire.ext.wires.core.grids.client.model.GridCell;
import org.uberfire.ext.wires.core.grids.client.model.GridCellValue;
import org.uberfire.ext.wires.core.grids.client.model.GridData;
import org.uberfire.mvp.Command;

public class SetKindCommand
extends AbstractCanvasGraphCommand
implements VetoExecutionCommand,
VetoUndoCommand {
    private final GridCellValueTuple cellTuple;
    private final FunctionDefinition function;
    private final FunctionDefinition.Kind kind;
    private final Optional<Expression> expression;
    private final Command canvasOperation;
    private final FunctionDefinition.Kind oldKind;
    private final Optional<Expression> oldExpression;
    private final Optional<GridCellValue<?>> oldCellValue;

    public SetKindCommand(GridCellValueTuple cellTuple, FunctionDefinition function, FunctionDefinition.Kind kind, Optional<Expression> expression, Command canvasOperation) {
        this.cellTuple = cellTuple;
        this.function = function;
        this.kind = kind;
        this.expression = expression;
        this.canvasOperation = canvasOperation;
        this.oldKind = this.getKind();
        this.oldExpression = Optional.ofNullable(function.getExpression());
        this.oldCellValue = Optional.ofNullable(this.extractGridCellValue(cellTuple.getRowIndex(), cellTuple.getColumnIndex()));
    }

    GridCellValue<?> extractGridCellValue(int rowIndex, int columnIndex) {
        GridCell cell = this.cellTuple.getGridData().getCell(rowIndex, columnIndex);
        return cell == null ? null : cell.getValue();
    }

    protected org.kie.workbench.common.stunner.core.command.Command<GraphCommandExecutionContext, RuleViolation> newGraphCommand(AbstractCanvasHandler handler) {
        return new AbstractGraphCommand(){

            protected CommandResult<RuleViolation> check(GraphCommandExecutionContext gce) {
                return GraphCommandResultBuilder.SUCCESS;
            }

            public CommandResult<RuleViolation> execute(GraphCommandExecutionContext gce) {
                SetKindCommand.this.setKind(SetKindCommand.this.kind);
                SetKindCommand.this.function.setExpression((Expression)SetKindCommand.this.expression.orElse(null));
                return GraphCommandResultBuilder.SUCCESS;
            }

            public CommandResult<RuleViolation> undo(GraphCommandExecutionContext gce) {
                SetKindCommand.this.setKind(SetKindCommand.this.oldKind);
                SetKindCommand.this.function.setExpression((Expression)SetKindCommand.this.oldExpression.orElse(null));
                return GraphCommandResultBuilder.SUCCESS;
            }
        };
    }

    private FunctionDefinition.Kind getKind() {
        Map attributes = this.function.getAdditionalAttributes();
        return FunctionDefinition.Kind.determineFromString((String)((String)attributes.get(FunctionDefinition.KIND_QNAME)));
    }

    private void setKind(FunctionDefinition.Kind kind) {
        Map nsContext = this.function.getNsContext();
        nsContext.put("drools", "http://www.drools.org/kie/dmn/1.1");
        Map attributes = this.function.getAdditionalAttributes();
        attributes.put(FunctionDefinition.KIND_QNAME, kind.code());
    }

    protected org.kie.workbench.common.stunner.core.command.Command<AbstractCanvasHandler, CanvasViolation> newCanvasCommand(AbstractCanvasHandler handler) {
        return new AbstractCanvasCommand(){

            public CommandResult<CanvasViolation> execute(AbstractCanvasHandler handler) {
                GridData gridData = SetKindCommand.this.cellTuple.getGridData();
                gridData.setCell(SetKindCommand.this.cellTuple.getRowIndex(), SetKindCommand.this.cellTuple.getColumnIndex(), SetKindCommand.this.cellTuple.getValue());
                SetKindCommand.this.canvasOperation.execute();
                return CanvasCommandResultBuilder.SUCCESS;
            }

            public CommandResult<CanvasViolation> undo(AbstractCanvasHandler handler) {
                if (SetKindCommand.this.oldCellValue.isPresent()) {
                    SetKindCommand.this.cellTuple.getGridData().setCell(SetKindCommand.this.cellTuple.getRowIndex(), SetKindCommand.this.cellTuple.getColumnIndex(), (GridCellValue)SetKindCommand.this.oldCellValue.get());
                } else {
                    SetKindCommand.this.cellTuple.getGridData().deleteCell(SetKindCommand.this.cellTuple.getRowIndex(), SetKindCommand.this.cellTuple.getColumnIndex());
                }
                SetKindCommand.this.canvasOperation.execute();
                return CanvasCommandResultBuilder.SUCCESS;
            }
        };
    }
}

