/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.commands.expressions.types.relation;

import org.kie.workbench.common.dmn.api.definition.v1_1.Expression;
import org.kie.workbench.common.dmn.api.definition.v1_1.InformationItem;
import org.kie.workbench.common.dmn.api.definition.v1_1.LiteralExpression;
import org.kie.workbench.common.dmn.api.definition.v1_1.Relation;
import org.kie.workbench.common.dmn.client.commands.VetoExecutionCommand;
import org.kie.workbench.common.dmn.client.commands.VetoUndoCommand;
import org.kie.workbench.common.dmn.client.editors.expressions.types.relation.RelationColumn;
import org.kie.workbench.common.dmn.client.editors.expressions.types.relation.RelationUIModelMapper;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.command.AbstractCanvasCommand;
import org.kie.workbench.common.stunner.core.client.canvas.command.AbstractCanvasGraphCommand;
import org.kie.workbench.common.stunner.core.client.command.CanvasCommandResultBuilder;
import org.kie.workbench.common.stunner.core.client.command.CanvasViolation;
import org.kie.workbench.common.stunner.core.command.CommandResult;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommandExecutionContext;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommandResultBuilder;
import org.kie.workbench.common.stunner.core.graph.command.impl.AbstractGraphCommand;
import org.kie.workbench.common.stunner.core.rule.RuleViolation;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.model.GridData;
import org.uberfire.mvp.Command;

public class AddRelationColumnCommand
extends AbstractCanvasGraphCommand
implements VetoExecutionCommand,
VetoUndoCommand {
    private final Relation relation;
    private final InformationItem informationItem;
    private final GridData uiModel;
    private final RelationColumn uiModelColumn;
    private final RelationUIModelMapper uiModelMapper;
    private final Command canvasOperation;

    public AddRelationColumnCommand(Relation relation, InformationItem informationItem, GridData uiModel, RelationColumn uiModelColumn, RelationUIModelMapper uiModelMapper, Command canvasOperation) {
        this.relation = relation;
        this.informationItem = informationItem;
        this.uiModel = uiModel;
        this.uiModelColumn = uiModelColumn;
        this.uiModelMapper = uiModelMapper;
        this.canvasOperation = canvasOperation;
    }

    protected org.kie.workbench.common.stunner.core.command.Command<GraphCommandExecutionContext, RuleViolation> newGraphCommand(AbstractCanvasHandler handler) {
        return new AbstractGraphCommand(){

            protected CommandResult<RuleViolation> check(GraphCommandExecutionContext gce) {
                return GraphCommandResultBuilder.SUCCESS;
            }

            public CommandResult<RuleViolation> execute(GraphCommandExecutionContext gce) {
                AddRelationColumnCommand.this.relation.getColumn().add(AddRelationColumnCommand.this.informationItem);
                AddRelationColumnCommand.this.relation.getRow().forEach(row -> {
                    LiteralExpression le = new LiteralExpression();
                    row.getExpression().add(le);
                });
                return GraphCommandResultBuilder.SUCCESS;
            }

            public CommandResult<RuleViolation> undo(GraphCommandExecutionContext gce) {
                int columnIndex = AddRelationColumnCommand.this.relation.getColumn().indexOf(AddRelationColumnCommand.this.informationItem);
                AddRelationColumnCommand.this.relation.getRow().forEach(row -> {
                    Expression cfr_ignored_0 = (Expression)row.getExpression().remove(columnIndex);
                });
                AddRelationColumnCommand.this.relation.getColumn().remove(AddRelationColumnCommand.this.informationItem);
                return GraphCommandResultBuilder.SUCCESS;
            }
        };
    }

    protected org.kie.workbench.common.stunner.core.command.Command<AbstractCanvasHandler, CanvasViolation> newCanvasCommand(AbstractCanvasHandler handler) {
        return new AbstractCanvasCommand(){

            public CommandResult<CanvasViolation> execute(AbstractCanvasHandler handler) {
                AddRelationColumnCommand.this.uiModel.appendColumn((GridColumn)AddRelationColumnCommand.this.uiModelColumn);
                int columnIndex = AddRelationColumnCommand.this.uiModel.getColumns().indexOf((Object)AddRelationColumnCommand.this.uiModelColumn);
                for (int rowIndex = 0; rowIndex < AddRelationColumnCommand.this.relation.getRow().size(); ++rowIndex) {
                    AddRelationColumnCommand.this.uiModelMapper.fromDMNModel(rowIndex, columnIndex);
                }
                AddRelationColumnCommand.this.canvasOperation.execute();
                return CanvasCommandResultBuilder.SUCCESS;
            }

            public CommandResult<CanvasViolation> undo(AbstractCanvasHandler handler) {
                AddRelationColumnCommand.this.uiModel.deleteColumn((GridColumn)AddRelationColumnCommand.this.uiModelColumn);
                AddRelationColumnCommand.this.canvasOperation.execute();
                return CanvasCommandResultBuilder.SUCCESS;
            }
        };
    }
}

