/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.commands.expressions.types.relation;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.kie.workbench.common.dmn.api.definition.v1_1.Relation;
import org.kie.workbench.common.dmn.client.commands.VetoExecutionCommand;
import org.kie.workbench.common.dmn.client.commands.VetoUndoCommand;
import org.kie.workbench.common.dmn.client.editors.expressions.types.relation.RelationUIModelMapperHelper;
import org.kie.workbench.common.dmn.client.widgets.grid.model.DMNGridData;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.command.AbstractCanvasCommand;
import org.kie.workbench.common.stunner.core.client.canvas.command.AbstractCanvasGraphCommand;
import org.kie.workbench.common.stunner.core.client.command.CanvasCommandResultBuilder;
import org.kie.workbench.common.stunner.core.client.command.CanvasViolation;
import org.kie.workbench.common.stunner.core.command.CommandResult;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommandExecutionContext;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommandResultBuilder;
import org.kie.workbench.common.stunner.core.graph.command.impl.AbstractGraphCommand;
import org.kie.workbench.common.stunner.core.rule.RuleViolation;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.mvp.Command;

public class MoveColumnsCommand
extends AbstractCanvasGraphCommand
implements VetoExecutionCommand,
VetoUndoCommand {
    private final Relation relation;
    private final DMNGridData uiModel;
    private final int index;
    private final List<GridColumn<?>> columns;
    private final Command canvasOperation;
    private final int oldIndex;

    public MoveColumnsCommand(Relation relation, DMNGridData uiModel, int index, List<GridColumn<?>> columns, Command canvasOperation) {
        this.relation = relation;
        this.uiModel = uiModel;
        this.index = index;
        this.columns = new ArrayList(columns);
        this.canvasOperation = canvasOperation;
        this.oldIndex = uiModel.getColumns().indexOf(columns.get(0));
    }

    protected org.kie.workbench.common.stunner.core.command.Command<GraphCommandExecutionContext, RuleViolation> newGraphCommand(AbstractCanvasHandler context) {
        return new AbstractGraphCommand(){

            protected CommandResult<RuleViolation> check(GraphCommandExecutionContext context) {
                return this.isColumnInValidSection() ? GraphCommandResultBuilder.SUCCESS : GraphCommandResultBuilder.FAILED;
            }

            private boolean isColumnInValidSection() {
                RelationUIModelMapperHelper.RelationSection section = RelationUIModelMapperHelper.getSection(MoveColumnsCommand.this.relation, MoveColumnsCommand.this.index);
                return section == RelationUIModelMapperHelper.RelationSection.INFORMATION_ITEM;
            }

            public CommandResult<RuleViolation> execute(GraphCommandExecutionContext context) {
                return this.moveInformationItems(MoveColumnsCommand.this.index);
            }

            public CommandResult<RuleViolation> undo(GraphCommandExecutionContext context) {
                return this.moveInformationItems(MoveColumnsCommand.this.oldIndex);
            }

            private CommandResult<RuleViolation> moveInformationItems(int index) {
                RelationUIModelMapperHelper.RelationSection section = RelationUIModelMapperHelper.getSection(MoveColumnsCommand.this.relation, index);
                if (section == RelationUIModelMapperHelper.RelationSection.INFORMATION_ITEM) {
                    int oldIndex = MoveColumnsCommand.this.uiModel.getColumns().indexOf(MoveColumnsCommand.this.columns.get(0));
                    int relativeIndex = RelationUIModelMapperHelper.getInformationItemIndex(MoveColumnsCommand.this.relation, index);
                    int relativeOldIndex = RelationUIModelMapperHelper.getInformationItemIndex(MoveColumnsCommand.this.relation, oldIndex);
                    List<Integer> informationItemIndexesToMove = MoveColumnsCommand.this.columns.stream().map(c -> MoveColumnsCommand.this.uiModel.getColumns().indexOf(c)).map(i -> RelationUIModelMapperHelper.getInformationItemIndex(MoveColumnsCommand.this.relation, i)).collect(Collectors.toList());
                    this.moveInformationItems(relativeIndex, relativeOldIndex, MoveColumnsCommand.this.relation.getColumn(), informationItemIndexesToMove);
                    this.updateRowsData(relativeIndex, relativeOldIndex, MoveColumnsCommand.this.relation.getRow(), informationItemIndexesToMove);
                    return GraphCommandResultBuilder.SUCCESS;
                }
                return GraphCommandResultBuilder.FAILED;
            }

            private <T> void moveInformationItems(int relativeIndex, int relativeOldIndex, List<T> informationItems, List<Integer> informationItemIndexesToMove) {
                List informationItemsToMove = informationItemIndexesToMove.stream().map(informationItems::get).collect(Collectors.toList());
                informationItems.removeAll(informationItemsToMove);
                if (relativeIndex < relativeOldIndex) {
                    informationItems.addAll(relativeIndex, informationItemsToMove);
                } else if (relativeIndex > relativeOldIndex) {
                    informationItems.addAll(relativeIndex - informationItemsToMove.size() + 1, informationItemsToMove);
                }
            }

            private void updateRowsData(int relativeIndex, int relativeOldIndex, List<org.kie.workbench.common.dmn.api.definition.v1_1.List> rows, List<Integer> informationItemIndexesToMove) {
                rows.forEach(row -> this.moveInformationItems(relativeIndex, relativeOldIndex, row.getExpression(), informationItemIndexesToMove));
            }
        };
    }

    protected org.kie.workbench.common.stunner.core.command.Command<AbstractCanvasHandler, CanvasViolation> newCanvasCommand(AbstractCanvasHandler context) {
        return new AbstractCanvasCommand(){

            public CommandResult<CanvasViolation> execute(AbstractCanvasHandler context) {
                MoveColumnsCommand.this.uiModel.moveColumnsTo(MoveColumnsCommand.this.index, MoveColumnsCommand.this.columns);
                MoveColumnsCommand.this.canvasOperation.execute();
                return CanvasCommandResultBuilder.SUCCESS;
            }

            public CommandResult<CanvasViolation> undo(AbstractCanvasHandler context) {
                MoveColumnsCommand.this.uiModel.moveColumnsTo(MoveColumnsCommand.this.oldIndex, MoveColumnsCommand.this.columns);
                MoveColumnsCommand.this.canvasOperation.execute();
                return CanvasCommandResultBuilder.SUCCESS;
            }
        };
    }
}

