/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.commands.general;

import com.google.gwt.core.client.Scheduler;
import com.google.gwt.dom.client.Style;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import java.util.Optional;
import org.jboss.errai.common.client.dom.HTMLElement;
import org.jboss.errai.common.client.ui.ElementWrapperWidget;
import org.kie.workbench.common.dmn.api.definition.HasExpression;
import org.kie.workbench.common.dmn.api.definition.HasName;
import org.kie.workbench.common.dmn.client.commands.general.NavigateToDRGEditorCommand;
import org.kie.workbench.common.dmn.client.commands.general.NavigateToExpressionEditorCommand;
import org.kie.workbench.common.dmn.client.editors.expressions.ExpressionEditorView;
import org.kie.workbench.common.stunner.client.widgets.palette.PaletteWidget;
import org.kie.workbench.common.stunner.client.widgets.presenters.session.SessionPresenter;
import org.kie.workbench.common.stunner.client.widgets.presenters.session.impl.AbstractSessionPresenter;
import org.kie.workbench.common.stunner.core.client.api.SessionManager;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.CanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.Layer;
import org.kie.workbench.common.stunner.core.client.canvas.command.AbstractCanvasGraphCommand;
import org.kie.workbench.common.stunner.core.client.command.SessionCommandManager;
import org.kie.workbench.common.stunner.core.client.session.impl.AbstractClientFullSession;
import org.kie.workbench.common.stunner.core.client.session.impl.AbstractClientSession;
import org.kie.workbench.common.stunner.core.command.Command;
import org.kie.workbench.common.stunner.core.command.CommandResult;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommandExecutionContext;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommandResultBuilder;
import org.kie.workbench.common.stunner.core.graph.command.impl.AbstractGraphCommand;
import org.kie.workbench.common.stunner.core.rule.RuleViolation;
import org.uberfire.client.workbench.widgets.listbar.ResizeFlowPanel;

public abstract class BaseNavigateCommand
extends AbstractCanvasGraphCommand {
    public static final PaletteWidget.PaletteVisibility HIDDEN = () -> false;
    static final NoOperationGraphCommand NOP_GRAPH_COMMAND = new NoOperationGraphCommand();
    protected ExpressionEditorView.Presenter editor;
    protected SessionPresenter<AbstractClientFullSession, ?, Diagram> presenter;
    protected SessionManager sessionManager;
    protected SessionCommandManager<AbstractCanvasHandler> sessionCommandManager;
    protected Optional<HasName> hasName;
    protected HasExpression hasExpression;

    public BaseNavigateCommand(ExpressionEditorView.Presenter editor, SessionPresenter<AbstractClientFullSession, ?, Diagram> presenter, SessionManager sessionManager, SessionCommandManager<AbstractCanvasHandler> sessionCommandManager, Optional<HasName> hasName, HasExpression hasExpression) {
        this.editor = editor;
        this.presenter = presenter;
        this.sessionManager = sessionManager;
        this.sessionCommandManager = sessionCommandManager;
        this.hasName = hasName;
        this.hasExpression = hasExpression;
    }

    protected void navigateToExpressionEditor(Optional<HasName> hasName, HasExpression hasExpression) {
        this.sessionCommandManager.execute((Object)((AbstractCanvasHandler)this.sessionManager.getCurrentSession().getCanvasHandler()), (Command)new NavigateToExpressionEditorCommand(this.editor, this.presenter, this.sessionManager, this.sessionCommandManager, hasName, hasExpression));
    }

    protected void navigateToDRGEditor(Optional<HasName> hasName, HasExpression hasExpression) {
        this.sessionCommandManager.execute((Object)((AbstractCanvasHandler)this.sessionManager.getCurrentSession().getCanvasHandler()), (Command)new NavigateToDRGEditorCommand(this.editor, this.presenter, this.sessionManager, this.sessionCommandManager, hasName, hasExpression));
    }

    protected void enableHandlers(boolean enabled) {
        CanvasHandler handler = this.getCanvasHandler();
        if (handler == null) {
            return;
        }
        Layer layer = handler.getCanvas().getLayer();
        if (enabled) {
            layer.enableHandlers();
            ((AbstractClientSession)this.sessionManager.getCurrentSession()).resume();
        } else {
            layer.disableHandlers();
            ((AbstractClientSession)this.sessionManager.getCurrentSession()).pause();
        }
    }

    protected void addExpressionEditorToCanvasWidget() {
        ResizeFlowPanel container = this.wrapElementForErrai1090();
        ((SessionPresenter.View)this.presenter.getView()).setCanvasWidget((IsWidget)container);
        ((SessionPresenter.View)this.presenter.getView()).setContentScrollType(SessionPresenter.View.ScrollType.CUSTOM);
        Scheduler.get().scheduleDeferred(() -> ((ResizeFlowPanel)container).onResize());
    }

    protected ResizeFlowPanel wrapElementForErrai1090() {
        ElementWrapperWidget w = ElementWrapperWidget.getWidget((HTMLElement)this.editor.getElement());
        ResizeFlowPanel container = new ResizeFlowPanel(){

            public void onResize() {
                super.onResize();
                BaseNavigateCommand.this.editor.getView().onResize();
            }
        };
        container.getElement().setId("dmn-expression-editor-container");
        container.getElement().getStyle().setDisplay(Style.Display.FLEX);
        container.getElement().getStyle().setWidth(100.0, Style.Unit.PCT);
        container.getElement().getStyle().setHeight(100.0, Style.Unit.PCT);
        container.add((Widget)w);
        return container;
    }

    protected void addDRGEditorToCanvasWidget() {
        ((SessionPresenter.View)this.presenter.getView()).setCanvasWidget(((AbstractSessionPresenter)this.presenter).getDisplayer().getView());
        ((SessionPresenter.View)this.presenter.getView()).setContentScrollType(SessionPresenter.View.ScrollType.AUTO);
    }

    protected void hidePaletteWidget(boolean hidden) {
        this.presenter.getPalette().setVisible(hidden ? HIDDEN : PaletteWidget.VISIBLE);
    }

    private CanvasHandler getCanvasHandler() {
        return null != this.sessionManager.getCurrentSession() ? this.sessionManager.getCurrentSession().getCanvasHandler() : null;
    }

    public static class NoOperationGraphCommand
    extends AbstractGraphCommand {
        protected CommandResult<RuleViolation> check(GraphCommandExecutionContext context) {
            return GraphCommandResultBuilder.SUCCESS;
        }

        public CommandResult<RuleViolation> execute(GraphCommandExecutionContext context) {
            return GraphCommandResultBuilder.SUCCESS;
        }

        public CommandResult<RuleViolation> undo(GraphCommandExecutionContext context) {
            return GraphCommandResultBuilder.SUCCESS;
        }
    }
}

