/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.commands.general;

import java.util.Optional;
import java.util.function.Supplier;
import org.kie.workbench.common.dmn.client.commands.VetoExecutionCommand;
import org.kie.workbench.common.dmn.client.commands.VetoUndoCommand;
import org.kie.workbench.common.dmn.client.widgets.grid.model.GridCellValueTuple;
import org.kie.workbench.common.dmn.client.widgets.grid.model.UIModelMapper;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.command.AbstractCanvasCommand;
import org.kie.workbench.common.stunner.core.client.canvas.command.AbstractCanvasGraphCommand;
import org.kie.workbench.common.stunner.core.client.command.CanvasCommandResultBuilder;
import org.kie.workbench.common.stunner.core.client.command.CanvasViolation;
import org.kie.workbench.common.stunner.core.command.CommandResult;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommandExecutionContext;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommandResultBuilder;
import org.kie.workbench.common.stunner.core.graph.command.impl.AbstractGraphCommand;
import org.kie.workbench.common.stunner.core.rule.RuleViolation;
import org.uberfire.ext.wires.core.grids.client.model.GridCell;
import org.uberfire.ext.wires.core.grids.client.model.GridCellValue;
import org.uberfire.ext.wires.core.grids.client.model.GridData;
import org.uberfire.mvp.Command;

public class SetCellValueCommand
extends AbstractCanvasGraphCommand
implements VetoExecutionCommand,
VetoUndoCommand {
    private final GridCellValueTuple cellTuple;
    private final Supplier<UIModelMapper> uiModelMapper;
    private final Command canvasOperation;
    private final Optional<GridCellValue<?>> oldCellValue;

    public SetCellValueCommand(GridCellValueTuple cellTuple, Supplier<UIModelMapper> uiModelMapper, Command canvasOperation) {
        this.cellTuple = cellTuple;
        this.uiModelMapper = uiModelMapper;
        this.canvasOperation = canvasOperation;
        this.oldCellValue = Optional.ofNullable(this.extractGridCellValue(cellTuple.getRowIndex(), cellTuple.getColumnIndex()));
    }

    GridCellValue<?> extractGridCellValue(int rowIndex, int columnIndex) {
        GridCell cell = this.cellTuple.getGridData().getCell(rowIndex, columnIndex);
        return cell == null ? null : cell.getValue();
    }

    protected org.kie.workbench.common.stunner.core.command.Command<GraphCommandExecutionContext, RuleViolation> newGraphCommand(AbstractCanvasHandler context) {
        return new AbstractGraphCommand(){

            protected CommandResult<RuleViolation> check(GraphCommandExecutionContext context) {
                return GraphCommandResultBuilder.SUCCESS;
            }

            public CommandResult<RuleViolation> execute(GraphCommandExecutionContext context) {
                ((UIModelMapper)SetCellValueCommand.this.uiModelMapper.get()).toDMNModel(SetCellValueCommand.this.cellTuple.getRowIndex(), SetCellValueCommand.this.cellTuple.getColumnIndex(), () -> Optional.of(SetCellValueCommand.this.cellTuple.getValue()));
                return GraphCommandResultBuilder.SUCCESS;
            }

            public CommandResult<RuleViolation> undo(GraphCommandExecutionContext context) {
                ((UIModelMapper)SetCellValueCommand.this.uiModelMapper.get()).toDMNModel(SetCellValueCommand.this.cellTuple.getRowIndex(), SetCellValueCommand.this.cellTuple.getColumnIndex(), () -> SetCellValueCommand.this.oldCellValue);
                return GraphCommandResultBuilder.SUCCESS;
            }
        };
    }

    protected org.kie.workbench.common.stunner.core.command.Command<AbstractCanvasHandler, CanvasViolation> newCanvasCommand(AbstractCanvasHandler context) {
        return new AbstractCanvasCommand(){

            public CommandResult<CanvasViolation> execute(AbstractCanvasHandler context) {
                GridData gridData = SetCellValueCommand.this.cellTuple.getGridData();
                gridData.setCell(SetCellValueCommand.this.cellTuple.getRowIndex(), SetCellValueCommand.this.cellTuple.getColumnIndex(), SetCellValueCommand.this.cellTuple.getValue());
                SetCellValueCommand.this.canvasOperation.execute();
                return CanvasCommandResultBuilder.SUCCESS;
            }

            public CommandResult<CanvasViolation> undo(AbstractCanvasHandler context) {
                if (SetCellValueCommand.this.oldCellValue.isPresent()) {
                    SetCellValueCommand.this.cellTuple.getGridData().setCell(SetCellValueCommand.this.cellTuple.getRowIndex(), SetCellValueCommand.this.cellTuple.getColumnIndex(), (GridCellValue)SetCellValueCommand.this.oldCellValue.get());
                } else {
                    SetCellValueCommand.this.cellTuple.getGridData().deleteCell(SetCellValueCommand.this.cellTuple.getRowIndex(), SetCellValueCommand.this.cellTuple.getColumnIndex());
                }
                SetCellValueCommand.this.canvasOperation.execute();
                return CanvasCommandResultBuilder.SUCCESS;
            }
        };
    }
}

