/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.components.palette.widget;

import java.util.Objects;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.jboss.errai.common.client.dom.DOMUtil;
import org.jboss.errai.common.client.dom.Div;
import org.jboss.errai.common.client.dom.Node;
import org.jboss.errai.common.client.dom.UnorderedList;
import org.jboss.errai.ui.client.local.api.IsElement;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.kie.workbench.common.dmn.client.components.palette.widget.DMNPaletteItemWidget;
import org.kie.workbench.common.dmn.client.components.palette.widget.DMNPaletteWidgetView;
import org.kie.workbench.common.stunner.client.widgets.palette.BS3PaletteWidget;
import org.kie.workbench.common.stunner.core.client.components.drag.DragProxy;
import org.kie.workbench.common.stunner.core.client.components.drag.DragProxyCallback;
import org.kie.workbench.common.stunner.core.client.components.glyph.ShapeGlyphDragHandler;
import org.kie.workbench.common.stunner.core.client.components.palette.model.definition.DefinitionsPalette;
import org.kie.workbench.common.stunner.core.definition.shape.Glyph;

@Templated
@Dependent
public class DMNPaletteWidgetViewImpl
implements DMNPaletteWidgetView,
IsElement {
    private ShapeGlyphDragHandler shapeGlyphDragHandler;
    private BS3PaletteWidget<DefinitionsPalette> presenter;
    @Inject
    @DataField(value="kie-palette")
    private Div palette;
    @Inject
    @DataField(value="list-group")
    private UnorderedList ul;
    private DragProxy itemDragProxy;

    public DMNPaletteWidgetViewImpl() {
    }

    @Inject
    public DMNPaletteWidgetViewImpl(ShapeGlyphDragHandler shapeGlyphDragHandler) {
        this.shapeGlyphDragHandler = shapeGlyphDragHandler;
    }

    public void init(BS3PaletteWidget<DefinitionsPalette> presenter) {
        this.presenter = presenter;
    }

    @Override
    public void showDragProxy(final String itemId, double x, double y, final double width, final double height) {
        final Glyph glyph = this.presenter.getShapeGlyph(itemId);
        this.itemDragProxy = this.shapeGlyphDragHandler.show((Object)new ShapeGlyphDragHandler.Item(){

            public Glyph getShape() {
                return glyph;
            }

            public int getWidth() {
                return (int)width;
            }

            public int getHeight() {
                return (int)height;
            }
        }, (int)x, (int)y, (Object)new DragProxyCallback(){

            public void onStart(int x, int y) {
                DMNPaletteWidgetViewImpl.this.presenter.onDragStart(itemId, (double)x, (double)y);
            }

            public void onMove(int x, int y) {
                DMNPaletteWidgetViewImpl.this.presenter.onDragProxyMove(itemId, (double)x, (double)y);
            }

            public void onComplete(int x, int y) {
                DMNPaletteWidgetViewImpl.this.presenter.onDragProxyComplete(itemId, (double)x, (double)y);
            }
        });
    }

    @Override
    public void add(DMNPaletteItemWidget widget) {
        PortablePreconditions.checkNotNull((String)"widget", (Object)widget);
        this.ul.appendChild((Node)widget.getElement());
    }

    @Override
    public void clear() {
        DOMUtil.removeAllChildren((Node)this.ul);
        if (Objects.nonNull(this.itemDragProxy)) {
            this.itemDragProxy.clear();
        }
    }

    @Override
    public void destroy() {
        this.clear();
        if (Objects.nonNull(this.itemDragProxy)) {
            this.itemDragProxy.destroy();
        }
    }

    @Override
    public void setBackgroundColor(String backgroundColor) {
        this.palette.getStyle().setProperty("background-color", backgroundColor);
    }

    @Override
    public void showEmptyView(boolean showEmptyView) {
        this.palette.setHidden(showEmptyView);
    }
}

