/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.expressions;

import java.util.Optional;
import java.util.function.Supplier;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.jboss.errai.common.client.dom.HTMLElement;
import org.kie.workbench.common.dmn.api.definition.HasExpression;
import org.kie.workbench.common.dmn.api.definition.HasName;
import org.kie.workbench.common.dmn.api.definition.v1_1.Expression;
import org.kie.workbench.common.dmn.api.qualifiers.DMNEditor;
import org.kie.workbench.common.dmn.client.editors.expressions.ExpressionEditorView;
import org.kie.workbench.common.dmn.client.editors.expressions.types.ExpressionEditorDefinition;
import org.kie.workbench.common.dmn.client.editors.expressions.types.ExpressionEditorDefinitions;
import org.kie.workbench.common.dmn.client.events.ExpressionEditorSelectedEvent;
import org.kie.workbench.common.stunner.client.widgets.presenters.session.SessionPresenter;
import org.kie.workbench.common.stunner.client.widgets.toolbar.ToolbarCommand;
import org.kie.workbench.common.stunner.client.widgets.toolbar.impl.EditorToolbar;
import org.kie.workbench.common.stunner.core.client.api.SessionManager;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.command.SessionCommandManager;
import org.kie.workbench.common.stunner.core.client.session.ClientSession;
import org.kie.workbench.common.stunner.core.client.session.Session;
import org.kie.workbench.common.stunner.core.client.session.impl.AbstractClientFullSession;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.uberfire.mvp.Command;

@Dependent
public class ExpressionEditor
implements ExpressionEditorView.Presenter {
    private ExpressionEditorView view;
    private SessionManager sessionManager;
    private SessionCommandManager<AbstractCanvasHandler> sessionCommandManager;
    private Supplier<ExpressionEditorDefinitions> expressionEditorDefinitions;
    private Optional<Command> exitCommand;
    private Optional<HasName> hasName = Optional.empty();
    private HasExpression hasExpression;
    private ToolbarCommandStateHandler toolbarCommandStateHandler;

    public ExpressionEditor() {
    }

    @Inject
    public ExpressionEditor(ExpressionEditorView view, SessionManager sessionManager, @Session SessionCommandManager<AbstractCanvasHandler> sessionCommandManager, @DMNEditor Supplier<ExpressionEditorDefinitions> expressionEditorDefinitions) {
        this.view = view;
        this.sessionManager = sessionManager;
        this.sessionCommandManager = sessionCommandManager;
        this.expressionEditorDefinitions = expressionEditorDefinitions;
        this.view.init(this);
    }

    public HTMLElement getElement() {
        return this.view.getElement();
    }

    @Override
    public ExpressionEditorView getView() {
        return this.view;
    }

    @Override
    public void init(SessionPresenter<AbstractClientFullSession, ?, Diagram> presenter) {
        this.toolbarCommandStateHandler = new ToolbarCommandStateHandler((EditorToolbar)presenter.getToolbar());
    }

    @Override
    public void setHasName(Optional<HasName> hasName) {
        this.hasName = hasName;
    }

    @Override
    public void setHasExpression(HasExpression hasExpression) {
        this.hasExpression = hasExpression;
        Expression e = hasExpression.getExpression();
        this.setExpression(Optional.ofNullable(e));
        this.toolbarCommandStateHandler.enter();
    }

    @Override
    public void setExpression(Optional<Expression> expression) {
        Optional<ExpressionEditorDefinition<Expression>> expressionEditorDefinition = this.expressionEditorDefinitions.get().getExpressionEditorDefinition(expression);
        expressionEditorDefinition.ifPresent(ed -> this.view.setEditor((ExpressionEditorDefinition<Expression>)ed, this.hasExpression, this.hasName, expression));
    }

    @Override
    public void onExpressionEditorSelected(@Observes ExpressionEditorSelectedEvent event) {
        if (this.isSameSession(event.getSession())) {
            this.view.onExpressionEditorSelected(event.getEditor());
        }
    }

    private boolean isSameSession(ClientSession other) {
        return null != other && null != this.getSession() && other.equals(this.getSession());
    }

    private ClientSession getSession() {
        return this.sessionManager.getCurrentSession();
    }

    @Override
    public void setExitCommand(Command exitCommand) {
        this.exitCommand = Optional.ofNullable(exitCommand);
    }

    @Override
    public void exit() {
        this.exitCommand.ifPresent(c -> {
            this.toolbarCommandStateHandler.exit();
            c.execute();
        });
    }

    ToolbarCommandStateHandler getToolbarCommandStateHandler() {
        return this.toolbarCommandStateHandler;
    }

    static class ToolbarCommandStateHandler {
        private EditorToolbar toolbar;
        boolean visitGraphToolbarCommandEnabled = false;
        boolean clearToolbarCommandEnabled = false;
        boolean clearStatesToolbarCommandEnabled = false;
        boolean deleteSelectionToolbarCommandEnabled = false;
        boolean switchGridToolbarCommandEnabled = false;
        boolean undoToolbarCommandEnabled = false;
        boolean redoToolbarCommandEnabled = false;
        boolean validateToolbarCommandEnabled = false;
        boolean exportToPngToolbarCommandEnabled = false;
        boolean exportToJpgToolbarCommandEnabled = false;
        boolean exportToPdfToolbarCommandEnabled = false;
        boolean copyCommandEnabled = false;
        boolean cutCommandEnabled = false;
        boolean pasteCommandEnabled = false;

        private ToolbarCommandStateHandler(EditorToolbar toolbar) {
            this.toolbar = toolbar;
        }

        private void enter() {
            this.visitGraphToolbarCommandEnabled = this.toolbar.isEnabled((ToolbarCommand)this.toolbar.getVisitGraphToolbarCommand());
            this.clearToolbarCommandEnabled = this.toolbar.isEnabled((ToolbarCommand)this.toolbar.getClearToolbarCommand());
            this.clearStatesToolbarCommandEnabled = this.toolbar.isEnabled((ToolbarCommand)this.toolbar.getClearStatesToolbarCommand());
            this.deleteSelectionToolbarCommandEnabled = this.toolbar.isEnabled((ToolbarCommand)this.toolbar.getDeleteSelectionToolbarCommand());
            this.switchGridToolbarCommandEnabled = this.toolbar.isEnabled((ToolbarCommand)this.toolbar.getSwitchGridToolbarCommand());
            this.undoToolbarCommandEnabled = this.toolbar.isEnabled((ToolbarCommand)this.toolbar.getUndoToolbarCommand());
            this.redoToolbarCommandEnabled = this.toolbar.isEnabled((ToolbarCommand)this.toolbar.getRedoToolbarCommand());
            this.validateToolbarCommandEnabled = this.toolbar.isEnabled((ToolbarCommand)this.toolbar.getValidateToolbarCommand());
            this.exportToPngToolbarCommandEnabled = this.toolbar.isEnabled((ToolbarCommand)this.toolbar.getExportToPngToolbarCommand());
            this.exportToJpgToolbarCommandEnabled = this.toolbar.isEnabled((ToolbarCommand)this.toolbar.getExportToJpgToolbarCommand());
            this.exportToPdfToolbarCommandEnabled = this.toolbar.isEnabled((ToolbarCommand)this.toolbar.getExportToPdfToolbarCommand());
            this.copyCommandEnabled = this.toolbar.isEnabled((ToolbarCommand)this.toolbar.getCopyToolbarCommand());
            this.cutCommandEnabled = this.toolbar.isEnabled((ToolbarCommand)this.toolbar.getCutToolbarCommand());
            this.pasteCommandEnabled = this.toolbar.isEnabled((ToolbarCommand)this.toolbar.getPasteToolbarCommand());
            this.enableToolbarCommand((ToolbarCommand)this.toolbar.getVisitGraphToolbarCommand(), false);
            this.enableToolbarCommand((ToolbarCommand)this.toolbar.getClearToolbarCommand(), false);
            this.enableToolbarCommand((ToolbarCommand)this.toolbar.getClearStatesToolbarCommand(), false);
            this.enableToolbarCommand((ToolbarCommand)this.toolbar.getDeleteSelectionToolbarCommand(), false);
            this.enableToolbarCommand((ToolbarCommand)this.toolbar.getSwitchGridToolbarCommand(), false);
            this.enableToolbarCommand((ToolbarCommand)this.toolbar.getUndoToolbarCommand(), false);
            this.enableToolbarCommand((ToolbarCommand)this.toolbar.getRedoToolbarCommand(), false);
            this.enableToolbarCommand((ToolbarCommand)this.toolbar.getValidateToolbarCommand(), false);
            this.enableToolbarCommand((ToolbarCommand)this.toolbar.getExportToPngToolbarCommand(), false);
            this.enableToolbarCommand((ToolbarCommand)this.toolbar.getExportToJpgToolbarCommand(), false);
            this.enableToolbarCommand((ToolbarCommand)this.toolbar.getExportToPdfToolbarCommand(), false);
            this.enableToolbarCommand((ToolbarCommand)this.toolbar.getCopyToolbarCommand(), false);
            this.enableToolbarCommand((ToolbarCommand)this.toolbar.getCutToolbarCommand(), false);
            this.enableToolbarCommand((ToolbarCommand)this.toolbar.getPasteToolbarCommand(), false);
        }

        private void exit() {
            this.enableToolbarCommand((ToolbarCommand)this.toolbar.getVisitGraphToolbarCommand(), this.visitGraphToolbarCommandEnabled);
            this.enableToolbarCommand((ToolbarCommand)this.toolbar.getClearToolbarCommand(), this.clearToolbarCommandEnabled);
            this.enableToolbarCommand((ToolbarCommand)this.toolbar.getClearStatesToolbarCommand(), this.clearStatesToolbarCommandEnabled);
            this.enableToolbarCommand((ToolbarCommand)this.toolbar.getDeleteSelectionToolbarCommand(), this.deleteSelectionToolbarCommandEnabled);
            this.enableToolbarCommand((ToolbarCommand)this.toolbar.getSwitchGridToolbarCommand(), this.switchGridToolbarCommandEnabled);
            this.enableToolbarCommand((ToolbarCommand)this.toolbar.getUndoToolbarCommand(), this.undoToolbarCommandEnabled);
            this.enableToolbarCommand((ToolbarCommand)this.toolbar.getRedoToolbarCommand(), this.redoToolbarCommandEnabled);
            this.enableToolbarCommand((ToolbarCommand)this.toolbar.getValidateToolbarCommand(), this.validateToolbarCommandEnabled);
            this.enableToolbarCommand((ToolbarCommand)this.toolbar.getExportToPngToolbarCommand(), this.exportToPngToolbarCommandEnabled);
            this.enableToolbarCommand((ToolbarCommand)this.toolbar.getExportToJpgToolbarCommand(), this.exportToJpgToolbarCommandEnabled);
            this.enableToolbarCommand((ToolbarCommand)this.toolbar.getExportToPdfToolbarCommand(), this.exportToPdfToolbarCommandEnabled);
            this.enableToolbarCommand((ToolbarCommand)this.toolbar.getCopyToolbarCommand(), this.copyCommandEnabled);
            this.enableToolbarCommand((ToolbarCommand)this.toolbar.getCutToolbarCommand(), this.cutCommandEnabled);
            this.enableToolbarCommand((ToolbarCommand)this.toolbar.getPasteToolbarCommand(), this.pasteCommandEnabled);
        }

        private void enableToolbarCommand(ToolbarCommand command, boolean enabled) {
            if (enabled) {
                this.toolbar.enable(command);
            } else {
                this.toolbar.disable(command);
            }
        }
    }
}

