/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.expressions;

import com.ait.lienzo.client.core.mediator.IMediator;
import com.ait.lienzo.client.core.shape.IPrimitive;
import com.ait.lienzo.client.core.types.Transform;
import com.google.gwt.dom.client.Document;
import com.google.gwt.event.dom.client.ClickEvent;
import java.util.Optional;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.jboss.errai.common.client.api.IsElement;
import org.jboss.errai.common.client.dom.Anchor;
import org.jboss.errai.common.client.dom.DOMUtil;
import org.jboss.errai.common.client.dom.Div;
import org.jboss.errai.common.client.dom.Node;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.EventHandler;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.kie.workbench.common.dmn.api.definition.HasExpression;
import org.kie.workbench.common.dmn.api.definition.HasName;
import org.kie.workbench.common.dmn.api.definition.v1_1.Expression;
import org.kie.workbench.common.dmn.api.qualifiers.DMNEditor;
import org.kie.workbench.common.dmn.client.editors.expressions.ExpressionContainer;
import org.kie.workbench.common.dmn.client.editors.expressions.ExpressionEditorView;
import org.kie.workbench.common.dmn.client.editors.expressions.types.ExpressionEditorDefinition;
import org.kie.workbench.common.dmn.client.editors.expressions.types.context.ExpressionCellValue;
import org.kie.workbench.common.dmn.client.widgets.grid.BaseExpressionGrid;
import org.kie.workbench.common.dmn.client.widgets.grid.BoundaryTransformMediator;
import org.kie.workbench.common.dmn.client.widgets.grid.model.GridCellTuple;
import org.kie.workbench.common.dmn.client.widgets.layer.DMNGridLayer;
import org.kie.workbench.common.dmn.client.widgets.panel.DMNGridPanel;
import org.kie.workbench.common.stunner.core.client.api.SessionManager;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.command.SessionCommandManager;
import org.kie.workbench.common.stunner.core.client.session.Session;
import org.uberfire.ext.wires.core.grids.client.model.GridCellValue;
import org.uberfire.ext.wires.core.grids.client.widget.grid.GridWidget;
import org.uberfire.ext.wires.core.grids.client.widget.layer.impl.GridLienzoPanel;
import org.uberfire.ext.wires.core.grids.client.widget.layer.pinning.TransformMediator;
import org.uberfire.ext.wires.core.grids.client.widget.layer.pinning.impl.RestrictedMousePanMediator;

@Templated
@Dependent
public class ExpressionEditorViewImpl
implements ExpressionEditorView {
    static final double VP_SCALE = 1.0;
    private ExpressionEditorView.Presenter presenter;
    @DataField(value="returnToDRG")
    private Anchor returnToDRG;
    @DataField(value="editorControls")
    private Div expressionEditorControls;
    private org.jboss.errai.common.client.dom.Document document;
    private TranslationService translationService;
    private DMNGridPanel gridPanel;
    private DMNGridLayer gridLayer;
    private RestrictedMousePanMediator mousePanMediator;
    private SessionManager sessionManager;
    private SessionCommandManager<AbstractCanvasHandler> sessionCommandManager;
    protected ExpressionContainer expressionContainer;

    public ExpressionEditorViewImpl() {
    }

    @Inject
    public ExpressionEditorViewImpl(Anchor returnToDRG, Div expressionEditorControls, org.jboss.errai.common.client.dom.Document document, TranslationService translationService, @DMNEditor DMNGridPanel gridPanel, @DMNEditor DMNGridLayer gridLayer, @DMNEditor RestrictedMousePanMediator mousePanMediator, SessionManager sessionManager, @Session SessionCommandManager<AbstractCanvasHandler> sessionCommandManager) {
        this.returnToDRG = returnToDRG;
        this.expressionEditorControls = expressionEditorControls;
        this.document = document;
        this.translationService = translationService;
        this.gridPanel = gridPanel;
        this.gridLayer = gridLayer;
        this.mousePanMediator = mousePanMediator;
        this.sessionManager = sessionManager;
        this.sessionCommandManager = sessionCommandManager;
        this.setupGridPanel();
        this.setupGridWidget();
        this.setupGridWidgetPanControl();
    }

    @DataField(value="dmn-table")
    public GridLienzoPanel getGridPanel() {
        return this.gridPanel;
    }

    protected void setupGridPanel() {
        Transform transform = new Transform().scale(1.0);
        this.gridPanel.getViewport().setTransform(transform);
        this.gridPanel.add(this.gridLayer);
        this.gridPanel.getElement().setId("dmn_container_" + Document.get().createUniqueId());
    }

    protected void setupGridWidget() {
        this.expressionContainer = new ExpressionContainer(this.gridLayer);
        this.gridLayer.removeAll();
        this.gridLayer.add((IPrimitive)this.expressionContainer);
        this.gridLayer.select((GridWidget)this.expressionContainer);
        this.gridLayer.enterPinnedMode((GridWidget)this.expressionContainer, () -> {});
    }

    protected void setupGridWidgetPanControl() {
        BoundaryTransformMediator defaultTransformMediator = new BoundaryTransformMediator((GridWidget)this.expressionContainer);
        this.mousePanMediator.setTransformMediator((TransformMediator)defaultTransformMediator);
        this.mousePanMediator.setBatchDraw(true);
        this.gridLayer.setDefaultTransformMediator(defaultTransformMediator);
        this.gridPanel.getViewport().getMediators().push((IMediator)this.mousePanMediator);
    }

    public void init(ExpressionEditorView.Presenter presenter) {
        this.presenter = presenter;
    }

    @Override
    public void setEditor(ExpressionEditorDefinition<Expression> definition, HasExpression hasExpression, Optional<HasName> hasName, Optional<Expression> expression) {
        GridCellTuple parent = this.getExpressionContainerTuple();
        Optional<BaseExpressionGrid> oEditor = definition.getEditor(parent, hasExpression, expression, hasName, false);
        this.expressionContainer.getModel().setCell(0, 0, (GridCellValue)new ExpressionCellValue(oEditor));
        parent.onResize();
        this.gridPanel.refreshScrollPosition();
        this.gridPanel.updatePanelSize();
        this.gridLayer.batch();
        hasName.ifPresent(name -> this.returnToDRG.setTextContent(this.translationService.format("ExpressionEditor.ReturnToDRG", new Object[]{name.getName().getValue()})));
        this.onExpressionEditorSelected(oEditor);
    }

    GridCellTuple getExpressionContainerTuple() {
        return new GridCellTuple(0, 0, this.expressionContainer.getModel());
    }

    @Override
    public void onExpressionEditorSelected(Optional<BaseExpressionGrid> oEditor) {
        BaseExpressionGrid editor;
        Optional oEditorControls;
        DOMUtil.removeAllChildren((Node)this.expressionEditorControls);
        if (oEditor.isPresent() && (oEditorControls = (editor = oEditor.get()).getEditorControls()).isPresent()) {
            IsElement editorControls = (IsElement)oEditorControls.get();
            this.expressionEditorControls.appendChild((Node)editorControls.getElement());
        }
    }

    @EventHandler(value={"returnToDRG"})
    void onClickReturnToDRG(ClickEvent event) {
        this.presenter.exit();
    }

    @Override
    public void onResize() {
        this.gridPanel.onResize();
    }
}

