/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.expressions.types.context;

import java.util.Optional;
import java.util.function.Supplier;
import org.kie.workbench.common.dmn.api.definition.HasExpression;
import org.kie.workbench.common.dmn.api.definition.v1_1.Context;
import org.kie.workbench.common.dmn.api.definition.v1_1.ContextEntry;
import org.kie.workbench.common.dmn.api.definition.v1_1.Expression;
import org.kie.workbench.common.dmn.api.definition.v1_1.InformationItem;
import org.kie.workbench.common.dmn.api.property.dmn.Name;
import org.kie.workbench.common.dmn.client.editors.expressions.types.ExpressionEditorDefinition;
import org.kie.workbench.common.dmn.client.editors.expressions.types.ExpressionEditorDefinitions;
import org.kie.workbench.common.dmn.client.editors.expressions.types.context.ContextUIModelMapperHelper;
import org.kie.workbench.common.dmn.client.editors.expressions.types.context.ExpressionCellValue;
import org.kie.workbench.common.dmn.client.widgets.grid.BaseExpressionGrid;
import org.kie.workbench.common.dmn.client.widgets.grid.model.BaseUIModelMapper;
import org.kie.workbench.common.dmn.client.widgets.grid.model.GridCellTuple;
import org.uberfire.ext.wires.core.grids.client.model.GridCellValue;
import org.uberfire.ext.wires.core.grids.client.model.GridData;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridCellValue;

public class ContextUIModelMapper
extends BaseUIModelMapper<Context> {
    public static final String DEFAULT_ROW_CAPTION = "default";
    private Supplier<ExpressionEditorDefinitions> expressionEditorDefinitionsSupplier;

    public ContextUIModelMapper(Supplier<GridData> uiModel, Supplier<Optional<Context>> dmnModel, Supplier<ExpressionEditorDefinitions> expressionEditorDefinitionsSupplier) {
        super(uiModel, dmnModel);
        this.expressionEditorDefinitionsSupplier = expressionEditorDefinitionsSupplier;
    }

    @Override
    public void fromDMNModel(int rowIndex, int columnIndex) {
        ((Optional)this.dmnModel.get()).ifPresent(context -> {
            ContextUIModelMapperHelper.ContextSection section = ContextUIModelMapperHelper.getSection(columnIndex);
            switch (section) {
                case ROW_INDEX: {
                    ((GridData)this.uiModel.get()).setCell(rowIndex, columnIndex, (GridCellValue)new BaseGridCellValue((Object)(rowIndex + 1)));
                    break;
                }
                case NAME: {
                    InformationItem variable = ((ContextEntry)context.getContextEntry().get(rowIndex)).getVariable();
                    String name = variable == null ? DEFAULT_ROW_CAPTION : variable.getName().getValue();
                    ((GridData)this.uiModel.get()).setCell(rowIndex, columnIndex, (GridCellValue)new BaseGridCellValue((Object)name));
                    break;
                }
                case EXPRESSION: {
                    ContextEntry ce = (ContextEntry)context.getContextEntry().get(rowIndex);
                    Optional<Expression> expression = Optional.ofNullable(ce.getExpression());
                    Optional<ExpressionEditorDefinition<Expression>> expressionEditorDefinition = this.expressionEditorDefinitionsSupplier.get().getExpressionEditorDefinition(expression);
                    expressionEditorDefinition.ifPresent(ed -> {
                        Optional<BaseExpressionGrid> editor = ed.getEditor(new GridCellTuple(rowIndex, columnIndex, (GridData)this.uiModel.get()), (HasExpression)ce, expression, Optional.ofNullable(ce.getVariable()), true);
                        ((GridData)this.uiModel.get()).setCell(rowIndex, columnIndex, (GridCellValue)new ExpressionCellValue(editor));
                    });
                }
            }
        });
    }

    @Override
    public void toDMNModel(int rowIndex, int columnIndex, Supplier<Optional<GridCellValue<?>>> cell) {
        ((Optional)this.dmnModel.get()).ifPresent(context -> {
            ContextUIModelMapperHelper.ContextSection section = ContextUIModelMapperHelper.getSection(columnIndex);
            switch (section) {
                case ROW_INDEX: {
                    break;
                }
                case NAME: {
                    ((ContextEntry)context.getContextEntry().get(rowIndex)).getVariable().setName(new Name(((GridCellValue)((Optional)cell.get()).orElse(new BaseGridCellValue((Object)""))).getValue().toString()));
                    break;
                }
                case EXPRESSION: {
                    ((Optional)cell.get()).ifPresent(v -> {
                        ExpressionCellValue ecv = (ExpressionCellValue)((Object)((Object)v));
                        ((Optional)ecv.getValue()).ifPresent(beg -> beg.getExpression().ifPresent(e -> ((ContextEntry)context.getContextEntry().get(rowIndex)).setExpression((Expression)e)));
                    });
                }
            }
        });
    }
}

