/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.expressions.types.context;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.kie.workbench.common.dmn.client.editors.expressions.types.context.ExpressionCellValue;
import org.kie.workbench.common.dmn.client.editors.expressions.types.context.ExpressionEditorColumnRenderer;
import org.kie.workbench.common.dmn.client.widgets.grid.BaseExpressionGrid;
import org.kie.workbench.common.dmn.client.widgets.grid.model.DMNGridColumn;
import org.kie.workbench.common.dmn.client.widgets.grid.model.RequiresResize;
import org.uberfire.ext.wires.core.grids.client.model.GridCell;
import org.uberfire.ext.wires.core.grids.client.model.GridCellValue;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.model.GridData;
import org.uberfire.ext.wires.core.grids.client.model.GridRow;
import org.uberfire.ext.wires.core.grids.client.widget.dom.HasDOMElementResources;
import org.uberfire.ext.wires.core.grids.client.widget.grid.GridWidget;

public class ExpressionEditorColumn
extends DMNGridColumn<Optional<BaseExpressionGrid>>
implements RequiresResize,
HasDOMElementResources {
    public ExpressionEditorColumn(GridColumn.HeaderMetaData headerMetaData, GridWidget gridWidget) {
        this(Collections.singletonList(headerMetaData), gridWidget);
    }

    public ExpressionEditorColumn(List<GridColumn.HeaderMetaData> headerMetaData, GridWidget gridWidget) {
        super(headerMetaData, new ExpressionEditorColumnRenderer(), gridWidget);
        this.setMovable(false);
        this.setResizable(false);
    }

    public Double getMinimumWidth() {
        double minimumWidth = super.getMinimumWidth();
        GridData model = this.gridWidget.getModel();
        int columnIndex = this.getLogicalColumnIndex(model);
        if (columnIndex != -1) {
            for (GridRow row : model.getRows()) {
                GridCellValue value;
                GridCell cell = (GridCell)row.getCells().get(columnIndex);
                if (cell == null || !((value = cell.getValue()) instanceof ExpressionCellValue)) continue;
                ExpressionCellValue ecv = (ExpressionCellValue)value;
                minimumWidth = Math.max(minimumWidth, ecv.getMinimumWidth().orElse(0.0) + 0.0);
            }
        }
        return minimumWidth;
    }

    public void setWidth(double width) {
        super.setWidth(width);
        this.updateWidthOfChildren();
        this.updateWidthOfPeers();
    }

    @Override
    public void setWidthInternal(double width) {
        super.setWidth(width);
        this.updateWidthOfChildren();
    }

    protected void updateWidthOfChildren() {
        double columnWidth = this.getWidth();
        GridData model = this.gridWidget.getModel();
        int columnIndex = this.getLogicalColumnIndex(model);
        if (columnIndex != -1) {
            for (GridRow row : model.getRows()) {
                ExpressionCellValue ecv;
                Optional editor;
                GridCellValue value;
                GridCell cell = (GridCell)row.getCells().get(columnIndex);
                if (cell == null || !((value = cell.getValue()) instanceof ExpressionCellValue) || !(editor = (Optional)(ecv = (ExpressionCellValue)value).getValue()).isPresent()) continue;
                BaseExpressionGrid beg = (BaseExpressionGrid)editor.get();
                this.updateWidthOfLastColumn(beg, columnWidth);
            }
        }
    }

    private void updateWidthOfLastColumn(BaseExpressionGrid gridWidget, double columnWidth) {
        List gwcs = gridWidget.getModel().getColumns();
        double targetGridWidth = columnWidth - 0.0;
        for (GridColumn gwc : gwcs) {
            targetGridWidth -= gwc.getWidth();
        }
        if (gwcs.size() > 0) {
            GridColumn lastColumn = (GridColumn)gwcs.get(gwcs.size() - 1);
            double lastColumnWidth = lastColumn.getWidth();
            if (lastColumn instanceof DMNGridColumn) {
                ((DMNGridColumn)lastColumn).setWidthInternal(lastColumnWidth + targetGridWidth);
            }
        }
    }

    @Override
    public void onResize() {
        double requiredColumnWidth;
        double currentColumnWidth = this.getWidth();
        if (currentColumnWidth != (requiredColumnWidth = this.getRequiredColumnWidth())) {
            this.setWidth(requiredColumnWidth);
        }
    }

    private double getRequiredColumnWidth() {
        double requiredColumnWidth = 100.0;
        GridData model = this.gridWidget.getModel();
        int columnIndex = this.getLogicalColumnIndex(model);
        if (columnIndex != -1) {
            for (GridRow row : model.getRows()) {
                ExpressionCellValue ecv;
                Optional editor;
                GridCellValue value;
                GridCell cell = (GridCell)row.getCells().get(columnIndex);
                if (cell == null || !((value = cell.getValue()) instanceof ExpressionCellValue) || !(editor = (Optional)(ecv = (ExpressionCellValue)value).getValue()).isPresent()) continue;
                BaseExpressionGrid beg = (BaseExpressionGrid)editor.get();
                requiredColumnWidth = Math.max(requiredColumnWidth, beg.getWidth() + 0.0);
            }
        }
        return requiredColumnWidth;
    }

    private int getLogicalColumnIndex(GridData model) {
        int columnIndex = model.getColumns().indexOf(this);
        return columnIndex != -1 ? ((GridColumn)model.getColumns().get(columnIndex)).getIndex() : -1;
    }

    public void destroyResources() {
        this.getHeaderMetaData().stream().filter(md -> md instanceof HasDOMElementResources).map(md -> (HasDOMElementResources)md).forEach(HasDOMElementResources::destroyResources);
    }
}

