/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.expressions.types.dtable;

import com.google.gwt.core.client.Scheduler;
import com.google.gwt.user.client.Event;
import java.util.List;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.jboss.errai.common.client.dom.Div;
import org.jboss.errai.common.client.dom.Document;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.EventHandler;
import org.jboss.errai.ui.shared.api.annotations.SinkNative;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.kie.workbench.common.dmn.api.definition.v1_1.BuiltinAggregator;
import org.kie.workbench.common.dmn.api.definition.v1_1.DecisionTableOrientation;
import org.kie.workbench.common.dmn.api.definition.v1_1.HitPolicy;
import org.kie.workbench.common.dmn.client.editors.expressions.types.dtable.DecisionTableGridControls;
import org.uberfire.client.views.pfly.widgets.Select;
import org.uberfire.mvp.Command;

@Templated
@Dependent
public class DecisionTableGridControlsImpl
implements DecisionTableGridControls {
    @DataField(value="addInputClause")
    private Div addInputClause;
    @DataField(value="addOutputClause")
    private Div addOutputClause;
    @DataField(value="addDecisionRule")
    private Div addDecisionRule;
    @DataField(value="lstHitPolicies")
    private Select lstHitPolicies;
    @DataField(value="lstBuiltinAggregator")
    private Select lstBuiltinAggregator;
    @DataField(value="lstDecisionTableOrientation")
    private Select lstDecisionTableOrientation;
    private Document document;
    private DecisionTableGridControls.Presenter presenter;

    public DecisionTableGridControlsImpl() {
    }

    @Inject
    public DecisionTableGridControlsImpl(Div addInputClause, Div addOutputClause, Div addDecisionRule, Select lstHitPolicies, Select lstBuiltinAggregator, Select lstDecisionTableOrientation, Document document) {
        this.addInputClause = addInputClause;
        this.addOutputClause = addOutputClause;
        this.addDecisionRule = addDecisionRule;
        this.lstHitPolicies = lstHitPolicies;
        this.lstBuiltinAggregator = lstBuiltinAggregator;
        this.lstDecisionTableOrientation = lstDecisionTableOrientation;
        this.document = document;
        this.setupHitPolicyEventHandler();
        this.setupBuiltinAggregatorEventHandler();
        this.setupDecisionTableOrientationEventHandler();
    }

    private void setupHitPolicyEventHandler() {
        this.setupChangeEventHandler(this.lstHitPolicies, () -> {
            HitPolicy hp = HitPolicy.fromValue((String)this.lstHitPolicies.getValue());
            this.presenter.setHitPolicy(hp);
        });
    }

    private void setupBuiltinAggregatorEventHandler() {
        this.setupChangeEventHandler(this.lstBuiltinAggregator, () -> {
            BuiltinAggregator aggregator = BuiltinAggregator.fromValue((String)this.lstBuiltinAggregator.getValue());
            this.presenter.setBuiltinAggregator(aggregator);
        });
    }

    private void setupDecisionTableOrientationEventHandler() {
        this.setupChangeEventHandler(this.lstDecisionTableOrientation, () -> {
            DecisionTableOrientation orientation = DecisionTableOrientation.fromValue((String)this.lstDecisionTableOrientation.getValue());
            this.presenter.setDecisionTableOrientation(orientation);
        });
    }

    private void setupChangeEventHandler(Select select, Command command) {
        select.getElement().addEventListener("change", event -> command.execute(), false);
    }

    public void init(DecisionTableGridControls.Presenter presenter) {
        this.presenter = presenter;
    }

    @Override
    public void initHitPolicies(List<HitPolicy> hitPolicies) {
        hitPolicies.forEach(hp -> this.lstHitPolicies.addOption(hp.value()));
    }

    @Override
    public void initBuiltinAggregators(List<BuiltinAggregator> aggregators) {
        aggregators.forEach(a -> this.lstBuiltinAggregator.addOption(a.value()));
    }

    @Override
    public void initDecisionTableOrientations(List<DecisionTableOrientation> orientations) {
        orientations.forEach(o -> this.lstDecisionTableOrientation.addOption(o.value()));
    }

    @Override
    public void initSelectedHitPolicy(HitPolicy hitPolicy) {
        this.initSelect(this.lstHitPolicies, hitPolicy.value());
    }

    @Override
    public void initSelectedBuiltinAggregator(BuiltinAggregator aggregator) {
        this.initSelect(this.lstBuiltinAggregator, aggregator.value());
    }

    @Override
    public void initSelectedDecisionTableOrientation(DecisionTableOrientation orientation) {
        this.initSelect(this.lstDecisionTableOrientation, orientation.value());
    }

    private void initSelect(Select select, String value) {
        Scheduler.get().scheduleDeferred(() -> select.refresh(s -> s.setValue(value)));
    }

    @Override
    public void enableHitPolicies(boolean enabled) {
        if (enabled) {
            this.lstHitPolicies.enable();
        } else {
            this.lstHitPolicies.disable();
        }
    }

    @Override
    public void enableBuiltinAggregators(boolean enabled) {
        if (enabled) {
            this.lstBuiltinAggregator.enable();
        } else {
            this.lstBuiltinAggregator.disable();
        }
    }

    @Override
    public void enableDecisionTableOrientation(boolean enabled) {
        if (enabled) {
            this.lstDecisionTableOrientation.enable();
        } else {
            this.lstDecisionTableOrientation.disable();
        }
    }

    @EventHandler(value={"addInputClause"})
    @SinkNative(value=1)
    public void onClickAddInputClause(Event event) {
        this.presenter.addInputClause();
    }

    @EventHandler(value={"addOutputClause"})
    @SinkNative(value=1)
    public void onClickAddOutputClause(Event event) {
        this.presenter.addOutputClause();
    }

    @EventHandler(value={"addDecisionRule"})
    @SinkNative(value=1)
    public void onClickAddDecisionRule(Event event) {
        this.presenter.addDecisionRule();
    }
}

