/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.expressions.types.function;

import com.ait.lienzo.shared.core.types.EventPropagationMode;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.enterprise.event.Event;
import org.gwtbootstrap3.client.ui.TextBox;
import org.jboss.errai.common.client.api.IsElement;
import org.kie.workbench.common.dmn.api.definition.HasExpression;
import org.kie.workbench.common.dmn.api.definition.HasName;
import org.kie.workbench.common.dmn.api.definition.v1_1.Expression;
import org.kie.workbench.common.dmn.api.definition.v1_1.FunctionDefinition;
import org.kie.workbench.common.dmn.api.definition.v1_1.InformationItem;
import org.kie.workbench.common.dmn.api.property.dmn.Name;
import org.kie.workbench.common.dmn.client.commands.expressions.types.function.AddParameterCommand;
import org.kie.workbench.common.dmn.client.commands.expressions.types.function.SetKindCommand;
import org.kie.workbench.common.dmn.client.commands.general.SetCellValueCommand;
import org.kie.workbench.common.dmn.client.editors.expressions.types.ExpressionEditorDefinition;
import org.kie.workbench.common.dmn.client.editors.expressions.types.ExpressionEditorDefinitions;
import org.kie.workbench.common.dmn.client.editors.expressions.types.ExpressionType;
import org.kie.workbench.common.dmn.client.editors.expressions.types.context.ExpressionCellValue;
import org.kie.workbench.common.dmn.client.editors.expressions.types.context.ExpressionEditorColumn;
import org.kie.workbench.common.dmn.client.editors.expressions.types.function.FunctionColumnNameHeaderMetaData;
import org.kie.workbench.common.dmn.client.editors.expressions.types.function.FunctionColumnParametersHeaderMetaData;
import org.kie.workbench.common.dmn.client.editors.expressions.types.function.FunctionGridControls;
import org.kie.workbench.common.dmn.client.editors.expressions.types.function.FunctionGridRenderer;
import org.kie.workbench.common.dmn.client.editors.expressions.types.function.FunctionUIModelMapper;
import org.kie.workbench.common.dmn.client.events.ExpressionEditorSelectedEvent;
import org.kie.workbench.common.dmn.client.widgets.grid.BaseExpressionGrid;
import org.kie.workbench.common.dmn.client.widgets.grid.columns.factory.TextBoxSingletonDOMElementFactory;
import org.kie.workbench.common.dmn.client.widgets.grid.columns.factory.dom.TextBoxDOMElement;
import org.kie.workbench.common.dmn.client.widgets.grid.model.DMNGridRow;
import org.kie.workbench.common.dmn.client.widgets.grid.model.GridCellTuple;
import org.kie.workbench.common.dmn.client.widgets.grid.model.GridCellValueTuple;
import org.kie.workbench.common.dmn.client.widgets.layer.DMNGridLayer;
import org.kie.workbench.common.dmn.client.widgets.panel.DMNGridPanel;
import org.kie.workbench.common.stunner.core.client.api.SessionManager;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.command.SessionCommandManager;
import org.kie.workbench.common.stunner.core.command.Command;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.model.GridRow;
import org.uberfire.ext.wires.core.grids.client.widget.dom.single.SingletonDOMElementFactory;
import org.uberfire.ext.wires.core.grids.client.widget.grid.GridWidget;
import org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.grids.GridRenderer;
import org.uberfire.ext.wires.core.grids.client.widget.layer.GridLayer;
import org.uberfire.ext.wires.core.grids.client.widget.layer.impl.GridLayerRedrawManager;

public class FunctionGrid
extends BaseExpressionGrid<FunctionDefinition, FunctionUIModelMapper>
implements FunctionGridControls.Presenter {
    private final FunctionGridControls controls;
    private final Supplier<ExpressionEditorDefinitions> expressionEditorDefinitionsSupplier;
    private final Supplier<ExpressionEditorDefinitions> supplementaryEditorDefinitionsSupplier;

    public FunctionGrid(GridCellTuple parent, HasExpression hasExpression, Optional<FunctionDefinition> expression, Optional<HasName> hasName, DMNGridPanel gridPanel, DMNGridLayer gridLayer, SessionManager sessionManager, SessionCommandManager<AbstractCanvasHandler> sessionCommandManager, Supplier<ExpressionEditorDefinitions> expressionEditorDefinitionsSupplier, Supplier<ExpressionEditorDefinitions> supplementaryEditorDefinitionsSupplier, Event<ExpressionEditorSelectedEvent> editorSelectedEvent, FunctionGridControls controls, boolean nested) {
        super(parent, hasExpression, expression, hasName, gridPanel, gridLayer, (GridRenderer)new FunctionGridRenderer(nested), sessionManager, sessionCommandManager, editorSelectedEvent);
        this.controls = controls;
        this.expressionEditorDefinitionsSupplier = expressionEditorDefinitionsSupplier;
        this.supplementaryEditorDefinitionsSupplier = supplementaryEditorDefinitionsSupplier;
        this.setEventPropagationMode(EventPropagationMode.NO_ANCESTORS);
        super.doInitialisation();
        this.controls.init(this);
        this.controls.initKinds(Arrays.asList(FunctionDefinition.Kind.values()));
        this.controls.initExpressionTypes(expressionEditorDefinitionsSupplier.get().stream().map(ExpressionEditorDefinition::getType).collect(Collectors.toList()));
    }

    @Override
    protected void doInitialisation() {
    }

    @Override
    public FunctionUIModelMapper makeUiModelMapper() {
        return new FunctionUIModelMapper(() -> ((FunctionGrid)this).getModel(), () -> this.expression, this.expressionEditorDefinitionsSupplier, this.supplementaryEditorDefinitionsSupplier);
    }

    @Override
    protected void initialiseUiColumns() {
        TextBoxSingletonDOMElementFactory headerFactory = new TextBoxSingletonDOMElementFactory(this.gridPanel, (GridLayer)this.gridLayer, (GridWidget)this, this.sessionManager, (SessionCommandManager<AbstractCanvasHandler>)this.sessionCommandManager, this.newHeaderHasNoValueCommand(), this.newHeaderHasValueCommand());
        ExpressionEditorColumn expressionColumn = new ExpressionEditorColumn(Arrays.asList(new GridColumn.HeaderMetaData[]{new FunctionColumnNameHeaderMetaData(() -> this.hasName.orElse(HasName.NOP).getName().getValue(), s -> this.hasName.orElse(HasName.NOP).getName().setValue(s), (SingletonDOMElementFactory<TextBox, TextBoxDOMElement>)headerFactory), new FunctionColumnParametersHeaderMetaData(this::extractExpressionLanguage, this::extractFormalParameters)}), (GridWidget)this);
        this.model.appendColumn((GridColumn)expressionColumn);
        this.getRenderer().setColumnRenderConstraint((arg_0, arg_1) -> FunctionGrid.lambda$initialiseUiColumns$3((GridColumn)expressionColumn, arg_0, arg_1));
    }

    @Override
    protected void initialiseUiModel() {
        this.expression.ifPresent(e -> {
            this.model.appendRow((GridRow)new DMNGridRow());
            ((FunctionUIModelMapper)this.uiModelMapper).fromDMNModel(0, 0);
        });
    }

    @Override
    public Optional<IsElement> getEditorControls() {
        this.controls.enableKind(false);
        this.controls.enableExpressionType(false);
        this.expression.ifPresent(e -> {
            FunctionDefinition.Kind kind = this.extractExpressionLanguage();
            this.controls.initSelectedKind(kind);
            this.controls.enableKind(true);
            switch (kind) {
                case FEEL: {
                    Optional<ExpressionType> type = this.extractExpressionType();
                    type.ifPresent(t -> {
                        this.controls.initSelectedExpressionType((ExpressionType)((Object)((Object)t)));
                        this.controls.enableExpressionType(true);
                    });
                    break;
                }
            }
        });
        return Optional.of(this.controls);
    }

    private FunctionDefinition.Kind extractExpressionLanguage() {
        if (this.expression.isPresent()) {
            FunctionDefinition function = (FunctionDefinition)this.expression.get();
            Map attributes = function.getAdditionalAttributes();
            String code = attributes.getOrDefault(FunctionDefinition.KIND_QNAME, FunctionDefinition.Kind.FEEL.code());
            return FunctionDefinition.Kind.determineFromString((String)code);
        }
        return FunctionDefinition.Kind.FEEL;
    }

    private List<InformationItem> extractFormalParameters() {
        if (this.expression.isPresent()) {
            FunctionDefinition function = (FunctionDefinition)this.expression.get();
            return function.getFormalParameter();
        }
        return Collections.emptyList();
    }

    private Optional<ExpressionType> extractExpressionType() {
        if (this.expression.isPresent()) {
            Expression e = ((FunctionDefinition)this.expression.get()).getExpression();
            Optional<ExpressionEditorDefinition<Expression>> definition = this.expressionEditorDefinitionsSupplier.get().getExpressionEditorDefinition(Optional.ofNullable(e));
            if (definition.isPresent()) {
                return Optional.of(definition.get().getType());
            }
        }
        return Optional.empty();
    }

    @Override
    public void addFormalParameter() {
        this.expression.ifPresent(e -> {
            InformationItem parameter = new InformationItem();
            parameter.setName(new Name("p" + e.getFormalParameter().size()));
            this.sessionCommandManager.execute((Object)((AbstractCanvasHandler)this.sessionManager.getCurrentSession().getCanvasHandler()), (Command)new AddParameterCommand((FunctionDefinition)e, parameter, () -> ((DMNGridLayer)this.gridLayer).batch()));
        });
    }

    @Override
    public void setKind(FunctionDefinition.Kind kind) {
        this.expression.ifPresent(function -> {
            switch (kind) {
                case FEEL: {
                    this.doSetKind(kind, (FunctionDefinition)function, this.expressionEditorDefinitionsSupplier.get().getExpressionEditorDefinition(ExpressionType.LITERAL_EXPRESSION));
                    break;
                }
                case JAVA: {
                    this.doSetKind(kind, (FunctionDefinition)function, this.supplementaryEditorDefinitionsSupplier.get().getExpressionEditorDefinition(ExpressionType.FUNCTION_JAVA));
                    break;
                }
                case PMML: {
                    this.doSetKind(kind, (FunctionDefinition)function, this.supplementaryEditorDefinitionsSupplier.get().getExpressionEditorDefinition(ExpressionType.FUNCTION_PMML));
                }
            }
        });
    }

    private void doSetKind(FunctionDefinition.Kind kind, FunctionDefinition function, Optional<ExpressionEditorDefinition<Expression>> oDefinition) {
        oDefinition.ifPresent(definition -> {
            GridCellTuple expressionParent = new GridCellTuple(0, 0, this.model);
            Optional<Expression> expression = definition.getModelClass();
            Optional<BaseExpressionGrid> gridWidget = definition.getEditor(expressionParent, this.hasExpression, expression, this.hasName, true);
            this.doSetKind(kind, function, expression, gridWidget);
        });
    }

    void doSetKind(FunctionDefinition.Kind kind, FunctionDefinition function, Optional<Expression> expression, Optional<BaseExpressionGrid> editor) {
        GridCellValueTuple<ExpressionCellValue> gcv = new GridCellValueTuple<ExpressionCellValue>(0, 0, this.model, new ExpressionCellValue(editor));
        this.sessionCommandManager.execute((Object)((AbstractCanvasHandler)this.sessionManager.getCurrentSession().getCanvasHandler()), (Command)new SetKindCommand(gcv, function, kind, expression, () -> this.synchroniseViewWhenExpressionEditorChanged(editor)));
    }

    @Override
    public void setExpressionType(ExpressionType type) {
        Optional<ExpressionEditorDefinition<Expression>> expressionEditorDefinition = this.expressionEditorDefinitionsSupplier.get().getExpressionEditorDefinition(type);
        expressionEditorDefinition.ifPresent(ed -> {
            Optional expression = ed.getModelClass();
            GridCellTuple expressionParent = new GridCellTuple(0, 0, this.model);
            Optional<BaseExpressionGrid> editor = ed.getEditor(expressionParent, this.hasExpression, expression, this.hasName, true);
            GridCellValueTuple<ExpressionCellValue> gcv = new GridCellValueTuple<ExpressionCellValue>(0, 0, this.model, new ExpressionCellValue(editor));
            this.sessionCommandManager.execute((Object)((AbstractCanvasHandler)this.sessionManager.getCurrentSession().getCanvasHandler()), (Command)new SetCellValueCommand(gcv, () -> (FunctionUIModelMapper)this.uiModelMapper, () -> this.synchroniseViewWhenExpressionEditorChanged(editor)));
        });
    }

    void synchroniseViewWhenExpressionEditorChanged(final Optional<BaseExpressionGrid> oEditor) {
        this.parent.onResize();
        this.gridPanel.refreshScrollPosition();
        this.gridPanel.updatePanelSize();
        this.gridLayer.batch(new GridLayerRedrawManager.PrioritizedCommand(0){

            public void execute() {
                FunctionGrid.this.gridLayer.draw();
                oEditor.ifPresent(arg_0 -> ((DMNGridLayer)FunctionGrid.this.gridLayer).select(arg_0));
            }
        });
        this.getEditorControls();
    }

    private static /* synthetic */ Boolean lambda$initialiseUiColumns$3(GridColumn expressionColumn, Boolean isSelectionLayer, GridColumn gridColumn) {
        return isSelectionLayer == false || gridColumn.equals(expressionColumn);
    }
}

