/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.expressions.types.function;

import com.google.gwt.core.client.Scheduler;
import com.google.gwt.user.client.Event;
import java.util.List;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.jboss.errai.common.client.dom.Div;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.EventHandler;
import org.jboss.errai.ui.shared.api.annotations.SinkNative;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.kie.workbench.common.dmn.api.definition.v1_1.FunctionDefinition;
import org.kie.workbench.common.dmn.client.editors.expressions.types.ExpressionType;
import org.kie.workbench.common.dmn.client.editors.expressions.types.function.FunctionGridControls;
import org.uberfire.client.views.pfly.widgets.Select;
import org.uberfire.mvp.Command;

@Templated
@Dependent
public class FunctionGridControlsImpl
implements FunctionGridControls {
    @DataField(value="addFormalParameter")
    private Div addFormalParameter;
    @DataField(value="lstKinds")
    private Select lstKinds;
    @DataField(value="lstExpressionTypes")
    private Select lstExpressionTypes;
    private FunctionGridControls.Presenter presenter;

    public FunctionGridControlsImpl() {
    }

    @Inject
    public FunctionGridControlsImpl(Div addFormalParameter, Select lstKinds, Select lstExpressionTypes) {
        this.addFormalParameter = addFormalParameter;
        this.lstKinds = lstKinds;
        this.lstExpressionTypes = lstExpressionTypes;
        this.setupKindsEventHandler();
        this.setupExpressionTypesHandler();
    }

    private void setupKindsEventHandler() {
        this.setupChangeEventHandler(this.lstKinds, () -> {
            FunctionDefinition.Kind kind = FunctionDefinition.Kind.determineFromString((String)this.lstKinds.getValue());
            this.presenter.setKind(kind);
        });
    }

    private void setupExpressionTypesHandler() {
        this.setupChangeEventHandler(this.lstExpressionTypes, () -> {
            ExpressionType type = ExpressionType.valueOf(this.lstExpressionTypes.getValue());
            this.presenter.setExpressionType(type);
        });
    }

    private void setupChangeEventHandler(Select select, Command command) {
        select.getElement().addEventListener("change", event -> command.execute(), false);
    }

    public void init(FunctionGridControls.Presenter presenter) {
        this.presenter = presenter;
    }

    @Override
    public void initKinds(List<FunctionDefinition.Kind> kinds) {
        kinds.forEach(k -> this.lstKinds.addOption(k.code()));
    }

    @Override
    public void initExpressionTypes(List<ExpressionType> types) {
        types.forEach(t -> this.lstExpressionTypes.addOption(t.name()));
    }

    @Override
    public void initSelectedKind(FunctionDefinition.Kind kind) {
        Scheduler.get().scheduleDeferred(() -> this.lstKinds.refresh(s -> s.setValue(kind.code())));
    }

    @Override
    public void initSelectedExpressionType(ExpressionType type) {
        Scheduler.get().scheduleDeferred(() -> this.lstExpressionTypes.refresh(s -> s.setValue(type.name())));
    }

    @Override
    public void enableKind(boolean enabled) {
        if (enabled) {
            this.lstKinds.enable();
        } else {
            this.lstKinds.disable();
        }
    }

    @Override
    public void enableExpressionType(boolean enabled) {
        if (enabled) {
            this.lstExpressionTypes.enable();
        } else {
            this.lstExpressionTypes.disable();
        }
    }

    @EventHandler(value={"addFormalParameter"})
    @SinkNative(value=1)
    public void onClickAddFormalParameter(Event event) {
        this.presenter.addFormalParameter();
    }
}

