/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.expressions.types.invocation;

import java.util.Optional;
import java.util.function.Supplier;
import org.kie.workbench.common.dmn.api.definition.HasExpression;
import org.kie.workbench.common.dmn.api.definition.v1_1.Binding;
import org.kie.workbench.common.dmn.api.definition.v1_1.Expression;
import org.kie.workbench.common.dmn.api.definition.v1_1.InformationItem;
import org.kie.workbench.common.dmn.api.definition.v1_1.Invocation;
import org.kie.workbench.common.dmn.api.property.dmn.Name;
import org.kie.workbench.common.dmn.client.editors.expressions.types.ExpressionEditorDefinition;
import org.kie.workbench.common.dmn.client.editors.expressions.types.ExpressionEditorDefinitions;
import org.kie.workbench.common.dmn.client.editors.expressions.types.context.ExpressionCellValue;
import org.kie.workbench.common.dmn.client.widgets.grid.BaseExpressionGrid;
import org.kie.workbench.common.dmn.client.widgets.grid.model.BaseUIModelMapper;
import org.kie.workbench.common.dmn.client.widgets.grid.model.GridCellTuple;
import org.uberfire.ext.wires.core.grids.client.model.GridCellValue;
import org.uberfire.ext.wires.core.grids.client.model.GridData;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridCellValue;

public class InvocationUIModelMapper
extends BaseUIModelMapper<Invocation> {
    public static final int ROW_NUMBER_COLUMN_INDEX = 0;
    public static final int BINDING_PARAMETER_COLUMN_INDEX = 1;
    public static final int BINDING_EXPRESSION_COLUMN_INDEX = 2;
    private Supplier<ExpressionEditorDefinitions> expressionEditorDefinitionsSupplier;

    public InvocationUIModelMapper(Supplier<GridData> uiModel, Supplier<Optional<Invocation>> dmnModel, Supplier<ExpressionEditorDefinitions> expressionEditorDefinitionsSupplier) {
        super(uiModel, dmnModel);
        this.expressionEditorDefinitionsSupplier = expressionEditorDefinitionsSupplier;
    }

    @Override
    public void fromDMNModel(int rowIndex, int columnIndex) {
        ((Optional)this.dmnModel.get()).ifPresent(invocation -> {
            switch (columnIndex) {
                case 0: {
                    ((GridData)this.uiModel.get()).setCell(rowIndex, columnIndex, (GridCellValue)new BaseGridCellValue((Object)(rowIndex + 1)));
                    break;
                }
                case 1: {
                    InformationItem variable = ((Binding)invocation.getBinding().get(rowIndex)).getParameter();
                    String name = variable.getName().getValue();
                    ((GridData)this.uiModel.get()).setCell(rowIndex, columnIndex, (GridCellValue)new BaseGridCellValue((Object)name));
                    break;
                }
                case 2: {
                    Binding binding = (Binding)invocation.getBinding().get(rowIndex);
                    Optional<Expression> expression = Optional.ofNullable(binding.getExpression());
                    Optional<ExpressionEditorDefinition<Expression>> expressionEditorDefinition = this.expressionEditorDefinitionsSupplier.get().getExpressionEditorDefinition(expression);
                    expressionEditorDefinition.ifPresent(ed -> {
                        Optional<BaseExpressionGrid> editor = ed.getEditor(new GridCellTuple(rowIndex, columnIndex, (GridData)this.uiModel.get()), (HasExpression)binding, expression, Optional.ofNullable(binding.getParameter()), true);
                        ((GridData)this.uiModel.get()).setCell(rowIndex, columnIndex, (GridCellValue)new ExpressionCellValue(editor));
                    });
                }
            }
        });
    }

    @Override
    public void toDMNModel(int rowIndex, int columnIndex, Supplier<Optional<GridCellValue<?>>> cell) {
        ((Optional)this.dmnModel.get()).ifPresent(invocation -> {
            switch (columnIndex) {
                case 0: {
                    break;
                }
                case 1: {
                    ((Binding)invocation.getBinding().get(rowIndex)).getParameter().setName(new Name(((GridCellValue)((Optional)cell.get()).orElse(new BaseGridCellValue((Object)""))).getValue().toString()));
                    break;
                }
                case 2: {
                    ((Optional)cell.get()).ifPresent(v -> {
                        ExpressionCellValue ecv = (ExpressionCellValue)((Object)((Object)v));
                        ((Optional)ecv.getValue()).ifPresent(beg -> beg.getExpression().ifPresent(e -> ((Binding)invocation.getBinding().get(rowIndex)).setExpression((Expression)e)));
                    });
                }
            }
        });
    }
}

