/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.expressions.types.undefined;

import com.ait.lienzo.client.core.shape.IPrimitive;
import com.ait.lienzo.client.core.shape.Rectangle;
import com.ait.lienzo.client.core.types.BoundingBox;
import com.ait.lienzo.shared.core.types.Direction;
import org.kie.workbench.common.dmn.api.definition.v1_1.Expression;
import org.kie.workbench.common.dmn.client.editors.expressions.types.ExpressionEditorDefinition;
import org.kie.workbench.common.stunner.lienzo.toolbox.items.tooltip.PrimitiveTextTooltip;

public class ExpressionEditorTooltip {
    static final ExpressionEditorTooltip INSTANCE = new ExpressionEditorTooltip();
    private PrimitiveTextTooltip tooltip = PrimitiveTextTooltip.Builder.build((String)"").forComputedBoundingBox(BoundingBox::new).withText(text -> text.setFontSize(10.0)).towards(Direction.SOUTH).at(Direction.SOUTH);

    private ExpressionEditorTooltip() {
    }

    void show(ExpressionEditorDefinition<Expression> definition, double absoluteCellX, double absoluteCellY, Rectangle rectangle) {
        this.tooltip.withText(text -> text.setText(definition.getName())).forComputedBoundingBox(() -> this.getBoundingBox(absoluteCellX, absoluteCellY, rectangle)).show();
    }

    private BoundingBox getBoundingBox(double absoluteCellX, double absoluteCellY, Rectangle r) {
        double minX = absoluteCellX + r.getX() - 25.0;
        double maxX = absoluteCellX + r.getX() + r.getWidth() + 25.0;
        double minY = absoluteCellY + r.getY();
        double maxY = absoluteCellY + r.getY() + r.getHeight();
        return new BoundingBox(minX, minY, maxX, maxY);
    }

    void hide() {
        this.tooltip.hide();
    }

    IPrimitive<?> asPrimitive() {
        return this.tooltip.asPrimitive();
    }
}

